/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSSTMethodBody;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;

public class RSStructuredTypesMethods
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, DataTypesDesign model, String modelOVID) throws Exception {
        ArrayList list = new ArrayList(1000);
        boolean count = false;
        String designOVID = (String)map.get(design.getObjectID());
        String query_meth = "INSERT INTO DMRS_STRUCT_TYPE_METHODS (Method_ID, Method_OVID, Method_Name, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Constructor, Overridden_Method_ID, Overridden_Method_OVID, Overridden_Method_Name, Design_OVID, Overriding) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt_meth = connection.prepareStatement(query_meth);
        String query_para = "INSERT INTO DMRS_STRUCT_TYPE_METHOD_PARS (Parameter_ID, Parameter_OVID, Parameter_Name, Method_ID, Method_OVID, Method_Name, Return_Value, Reference, Seq, T_Size, T_Precision, T_Scale, Type_ID, Type_OVID, Type_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt_para = connection.prepareStatement(query_para);
        Iterator meths = model.getMethodSet().iterator();
        while (meths.hasNext()) {
            Method meth = (Method)meths.next();
            StructuredType st = meth.getStructuredType();
            stmt_meth.setString(1, meth.getObjectID());
            stmt_meth.setString(2, RSStructuredTypesMethods.getOrCreateOVID(map, meth.getObjectID()));
            stmt_meth.setString(3, meth.getName());
            stmt_meth.setString(4, st.getObjectID());
            stmt_meth.setString(5, (String)map.get(meth.getStructuredType().getObjectID()));
            stmt_meth.setString(6, st.getName());
            stmt_meth.setString(7, meth.isConstructor() ? "Y" : "N");
            if (meth.getOverridedMethod() != null) {
                stmt_meth.setString(8, meth.getOverridedMethod().getObjectID());
                stmt_meth.setString(9, RSStructuredTypesMethods.getOrCreateOVID(map, meth.getOverridedMethod().getObjectID()));
                stmt_meth.setString(10, meth.getOverridedMethod().getName());
            } else {
                stmt_meth.setString(8, null);
                stmt_meth.setString(9, null);
                stmt_meth.setString(10, null);
            }
            stmt_meth.setString(11, designOVID);
            stmt_meth.setString(12, meth.isOverriding() ? "Y" : "N");
            stmt_meth.executeUpdate();
            MethodParam para2 = meth.getReturnValue();
            if (para2 != null) {
                String paraID = para2.getObjectID();
                String size = "";
                int precision = 0;
                int scale = 0;
                DesignObject rType = para2.getType();
                if (rType instanceof DistinctType) {
                    DistinctType dt = (DistinctType)rType;
                    size = dt.getSize();
                    precision = dt.getPrecision();
                    scale = dt.getScale();
                } else {
                    size = para2.getSize();
                    precision = para2.getPrecision();
                    scale = para2.getScale();
                }
                String paraName = para2.getName();
                if (paraID == null || paraID.equals("") || paraID.equalsIgnoreCase("null")) {
                    paraID = "RTN-" + meth.getObjectID();
                }
                if (paraName == null || paraName.equals("")) {
                    paraName = "Return Value";
                }
                stmt_para.setString(1, paraID);
                stmt_para.setString(2, RSStructuredTypesMethods.getOrCreateOVID(map, paraID));
                stmt_para.setString(3, paraName);
                stmt_para.setString(4, meth.getObjectID());
                stmt_para.setString(5, RSStructuredTypesMethods.getOrCreateOVID(map, meth.getObjectID()));
                stmt_para.setString(6, meth.getName());
                stmt_para.setString(7, "Y");
                stmt_para.setString(8, para2.isReference() ? "Y" : "N");
                stmt_para.setInt(9, 0);
                stmt_para.setString(10, size);
                stmt_para.setInt(11, precision);
                stmt_para.setInt(12, scale);
                if (para2.getType() != null) {
                    stmt_para.setString(13, para2.getType().getObjectID());
                    stmt_para.setString(14, RSStructuredTypesMethods.getOrCreateOVID(map, para2.getType().getObjectID()));
                    stmt_para.setString(15, para2.getType().getName());
                } else {
                    stmt_para.setString(13, null);
                    stmt_para.setString(14, null);
                    stmt_para.setString(15, null);
                }
                stmt_para.setString(16, designOVID);
                stmt_para.executeUpdate();
            }
            int seq = 1;
            for (MethodParam para2 : meth.getParameters()) {
                stmt_para.setString(1, para2.getObjectID());
                stmt_para.setString(2, RSStructuredTypesMethods.getOrCreateOVID(map, para2.getObjectID()));
                stmt_para.setString(3, para2.getName());
                stmt_para.setString(4, meth.getObjectID());
                stmt_para.setString(5, RSStructuredTypesMethods.getOrCreateOVID(map, meth.getObjectID()));
                stmt_para.setString(6, meth.getName());
                stmt_para.setString(7, "N");
                stmt_para.setString(8, para2.isReference() ? "Y" : "N");
                stmt_para.setInt(9, seq++);
                stmt_para.setString(10, para2.getSize());
                stmt_para.setInt(11, para2.getPrecision());
                stmt_para.setInt(12, para2.getScale());
                if (para2.getType() != null) {
                    stmt_para.setString(13, para2.getType().getObjectID());
                    stmt_para.setString(14, RSStructuredTypesMethods.getOrCreateOVID(map, para2.getType().getObjectID()));
                    stmt_para.setString(15, para2.getType().getName());
                } else {
                    stmt_para.setString(13, null);
                    stmt_para.setString(14, null);
                    stmt_para.setString(15, null);
                }
                stmt_para.setString(16, designOVID);
                stmt_para.executeUpdate();
            }
            RSSTMethodBody.export(map, connection, meth);
        }
        stmt_para.close();
        stmt_para = null;
        stmt_meth.close();
        stmt_meth = null;
    }
}

