/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.RSAttributes;
import oracle.dbtools.crest.exports.reports.RSEntities;
import oracle.dbtools.crest.exports.reports.RSEntityArcs;
import oracle.dbtools.crest.exports.reports.RSEntityViews;
import oracle.dbtools.crest.exports.reports.RSKeys;
import oracle.dbtools.crest.exports.reports.RSModel;
import oracle.dbtools.crest.exports.reports.RSRelationships;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.GUID;

public class RSLogicalModel
extends RSModel {
    public static void export(Design design, Map map, Connection connection, ProgressDialog monitor) throws Exception {
        LogicalDesign model = design.getLogicalDesign();
        String modelOVID = new GUID().toString();
        map.put(model.getObjectID(), modelOVID);
        RSLogicalModel.export(model, map, connection, "Logical", null);
        monitor.setNote(Messages.getString("RSLogicalModel.ExportingEntities"));
        RSEntities.export(design, map, connection, model, modelOVID);
        monitor.setNote(Messages.getString("RSLogicalModel.ExportingAttributes"));
        RSAttributes.export(design, map, connection, model, modelOVID);
        monitor.setNote(Messages.getString("RSLogicalModel.ExportingKeys"));
        RSKeys.export(design, map, connection, model, modelOVID);
        monitor.setNote(Messages.getString("RSLogicalModel.ExportingRelationships"));
        RSRelationships.export(design, map, connection, model, modelOVID);
        monitor.setNote("Exporting Entity Arcs...");
        RSEntityArcs.export(design, map, connection, model, modelOVID);
        monitor.setNote(Messages.getString("RSLogicalModel.ExportingEntityViews"));
        RSEntityViews.export(design, map, connection, model, modelOVID);
    }
}

