/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSIndexColumns;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.util.GUID;

public class RSIndexes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_INDEXES (Index_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, State, Functional, Expression, Engineer, Table_Name, Spatial_Index, Spatial_Layer_Type, Geodetic_Index, Number_Of_Dimensions, Design_OVID, Schema_OVID, Schema_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (RelationalDesign model : design.getRelationalDesigns()) {
            ArrayList<Object> indexList = new ArrayList<Object>();
            indexList.addAll(Arrays.asList(model.getGlobalIndexSet().toArray()));
            Iterator vit = model.getTableViewSet().iterator();
            while (vit.hasNext()) {
                TableView view = (TableView)vit.next();
                indexList.addAll(Arrays.asList(view.getKeys()));
            }
            for (KeyObject keyObject : indexList) {
                if (keyObject.isFK()) continue;
                String ovid = new GUID().toString();
                map.put(keyObject.getObjectID(), ovid);
                stmt.setString(1, keyObject.getName());
                stmt.setString(2, keyObject.getObjectID());
                stmt.setString(3, ovid);
                stmt.setString(4, keyObject.getImportedId());
                stmt.setString(5, keyObject.getContainerObject().getObjectID());
                stmt.setString(6, (String)map.get(keyObject.getContainerObject().getObjectID()));
                stmt.setString(7, keyObject.getIndexState());
                if (keyObject instanceof Index) {
                    stmt.setString(8, !"".equalsIgnoreCase(((Index)keyObject).getIndexExpression()) ? "Y" : "N");
                } else {
                    stmt.setString(8, "N");
                }
                if (keyObject instanceof Index) {
                    stmt.setString(9, ((Index)keyObject).getIndexExpression());
                } else {
                    stmt.setString(9, "");
                }
                stmt.setString(10, keyObject.getShouldEngineer() ? "Y" : "N");
                stmt.setString(11, keyObject.getContainerObject().getName());
                if (keyObject instanceof Index) {
                    stmt.setString(12, ((Index)keyObject).isSpatialIndex() ? "Y" : "N");
                    stmt.setString(13, ((Index)keyObject).getLayerType());
                    stmt.setString(14, "YES".equalsIgnoreCase(((Index)keyObject).getGeodetic()) ? "Y" : "N");
                    stmt.setInt(15, ((Index)keyObject).getDimensionsNumber());
                } else {
                    stmt.setString(12, "N");
                    stmt.setString(13, "");
                    stmt.setString(14, "N");
                    stmt.setInt(15, 0);
                }
                stmt.setString(16, (String)map.get(design.getObjectID()));
                stmt.setString(17, keyObject.getSchemaObject() != null ? (String)map.get(keyObject.getSchemaObject().getObjectID()) : null);
                stmt.setString(18, keyObject.getSchemaObject() != null ? keyObject.getSchemaObject().getName() : null);
                stmt.addBatch();
                list.add(keyObject);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (KeyObject keyObject2 : list) {
                    RSObjectNotes.export(map, connection, keyObject2);
                    RSComments.export(map, connection, keyObject2);
                    RSCommentsInRDBMS.export(map, connection, keyObject2);
                    RSIndexColumns.export(design, map, connection, keyObject2);
                    RSDynamicProperties.export(design, map, connection, keyObject2);
                }
                list.clear();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (KeyObject index : list) {
                RSObjectNotes.export(map, connection, index);
                RSComments.export(map, connection, index);
                RSCommentsInRDBMS.export(map, connection, index);
                RSIndexColumns.export(design, map, connection, index);
                RSDynamicProperties.export(design, map, connection, index);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

