/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.util.GUID;

public class RSGlossary
extends RSGeneral {
    public static void export(Glossary glossary, Map map, Connection connection, String comments) throws Exception {
        String glossaryID = glossary.getId();
        String glossaryOVID = new GUID().toString();
        map.put(glossaryID, glossaryOVID);
        String query = "INSERT INTO DMRS_GLOSSARIES (Glossary_ID, Glossary_OVID, Glossary_Name, File_Name, Description, Incomplete_Modifiers, Case_Sensitive, Unique_Abbrevs, Separator_Type, Separator_Char, Date_Published, Published_By, Persistence_Version, Version_Comments) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, sysdate, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        stmt.setString(1, glossaryID);
        stmt.setString(2, glossaryOVID);
        stmt.setString(3, glossary.getName());
        stmt.setString(4, glossary.getShortFileName());
        if (glossary.getDescription().length() > 4000) {
            stmt.setString(5, glossary.getDescription().substring(0, 4000));
        } else {
            stmt.setString(5, glossary.getDescription());
        }
        stmt.setString(6, glossary.isIncompleteModifiers() ? "Y" : "N");
        stmt.setString(7, glossary.isCaseSensitive() ? "Y" : "N");
        stmt.setString(8, glossary.isUniqueAbbreviations() ? "Y" : "N");
        stmt.setString(9, glossary.getSeparatorType());
        if (glossary.getSeparatorType().equalsIgnoreCase("SPACE")) {
            stmt.setString(10, " ");
        } else {
            stmt.setString(10, String.valueOf(glossary.getMW_SeparatorChar()));
        }
        stmt.setString(11, System.getProperty("user.name"));
        stmt.setFloat(12, 1.6f);
        stmt.setString(13, comments);
        stmt.executeUpdate();
        stmt.close();
        stmt = null;
    }
}

