/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.util.GUID;

public class RSDistinctTypes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, DataTypesDesign model, String modelOVID) throws Exception {
        ArrayList<DistinctType> list = new ArrayList<DistinctType>(1000);
        int count = 0;
        String designOVID = (String)map.get(design.getObjectID());
        String query = "INSERT INTO DMRS_DISTINCT_TYPES (Design_ID, Design_OVID, Design_Name, Distinct_Type_ID, Distinct_Type_OVID, Distinct_Type_Name, Logical_Type_ID, Logical_Type_OVID, Logical_Type_Name, T_Size, T_Precision, T_Scale, Model_OVID, Model_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = model.getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType type2 = (DistinctType)it.next();
            String ovid = new GUID().toString();
            map.put(type2.getObjectID(), ovid);
            stmt.setString(1, design.getObjectID());
            stmt.setString(2, designOVID);
            stmt.setString(3, design.getName());
            stmt.setString(4, type2.getObjectID());
            stmt.setString(5, ovid);
            stmt.setString(6, type2.getName());
            if (type2.getLogicalDataType() != null) {
                stmt.setString(7, type2.getLogicalDataType().getObjectID());
                stmt.setString(8, (String)map.get(type2.getLogicalDataType().getObjectID()));
                stmt.setString(9, type2.getLogicalDataType().getName());
            } else {
                stmt.setString(7, null);
                stmt.setString(8, null);
                stmt.setString(9, null);
            }
            stmt.setString(10, type2.getSize());
            stmt.setInt(11, type2.getPrecision());
            stmt.setInt(12, type2.getScale());
            stmt.setString(13, modelOVID);
            stmt.setString(14, type2.getDesignPart().getName());
            stmt.addBatch();
            list.add(type2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (DistinctType type2 : list) {
                RSObjectNotes.export(map, connection, type2);
                RSComments.export(map, connection, type2);
                RSCommentsInRDBMS.export(map, connection, type2);
                RSDynamicProperties.export(design, map, connection, type2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (DistinctType type : list) {
                RSObjectNotes.export(map, connection, type);
                RSComments.export(map, connection, type);
                RSCommentsInRDBMS.export(map, connection, type);
                RSDynamicProperties.export(design, map, connection, type);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

