/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;

public class RSContacts
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<BIContact> list1 = new ArrayList<BIContact>(1000);
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        int count4 = 0;
        int count5 = 0;
        String query = "INSERT INTO DMRS_CONTACTS (Contact_ID, Contact_OVID, Contact_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        String emailQuery = "INSERT INTO DMRS_CONTACT_EMAILS (Contact_ID, Contact_OVID, Contact_Name, Email_ID, Email_OVID, Email_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement emailStmt = connection.prepareStatement(emailQuery);
        String locQuery = "INSERT INTO DMRS_CONTACT_LOCATIONS (Contact_ID, Contact_OVID, Contact_Name, Location_ID, Location_OVID, Location_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement locStmt = connection.prepareStatement(locQuery);
        String phoneQuery = "INSERT INTO DMRS_CONTACT_TELEPHONES (Contact_ID, Contact_OVID, Contact_Name, Telephone_ID, Telephone_OVID, Telephone_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement phoneStmt = connection.prepareStatement(phoneQuery);
        String urlQuery = "INSERT INTO DMRS_CONTACT_RES_LOCATORS (Contact_ID, Contact_OVID, Contact_Name, Resource_Locator_ID, Resource_Locator_OVID, Resource_Locator_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement urlStmt = connection.prepareStatement(urlQuery);
        BusinessInfoDesign info = design.getBusinessInfoDesign();
        String designOVID = (String)map.get(design.getObjectID());
        String infoOVID = (String)map.get(design.getObjectID());
        Iterator it = info.getContactSet().iterator();
        while (it.hasNext()) {
            BIContact contact2 = (BIContact)it.next();
            String contactOVID = RSContacts.getOrCreateOVID(map, contact2.getObjectID());
            stmt.setString(1, contact2.getObjectID());
            stmt.setString(2, contactOVID);
            stmt.setString(3, contact2.getName());
            stmt.setString(4, info.getObjectID());
            stmt.setString(5, infoOVID);
            stmt.setString(6, info.getName());
            stmt.setString(7, designOVID);
            stmt.addBatch();
            list1.add(contact2);
            if (++count1 == 1000) {
                count1 = 0;
                stmt.executeBatch();
                for (BIContact contact2 : list1) {
                    RSComments.export(map, connection, contact2);
                    RSDynamicProperties.export(design, map, connection, contact2);
                }
                list1.clear();
            }
            for (BIEmail email : contact2.getEmails()) {
                String emailOVID = RSContacts.getOrCreateOVID(map, email.getObjectID());
                emailStmt.setString(1, contact2.getObjectID());
                emailStmt.setString(2, contactOVID);
                emailStmt.setString(3, contact2.getName());
                emailStmt.setString(4, email.getObjectID());
                emailStmt.setString(5, emailOVID);
                emailStmt.setString(6, email.getName());
                emailStmt.setString(7, designOVID);
                emailStmt.addBatch();
                if (++count2 != 1000) continue;
                count2 = 0;
                emailStmt.executeBatch();
            }
            for (BILocation loc : contact2.getLocations()) {
                String locOVID = RSContacts.getOrCreateOVID(map, loc.getObjectID());
                locStmt.setString(1, contact2.getObjectID());
                locStmt.setString(2, contactOVID);
                locStmt.setString(3, contact2.getName());
                locStmt.setString(4, loc.getObjectID());
                locStmt.setString(5, locOVID);
                locStmt.setString(6, loc.getName());
                locStmt.setString(7, designOVID);
                locStmt.addBatch();
                if (++count3 != 1000) continue;
                count3 = 0;
                locStmt.executeBatch();
            }
            for (BIPhone phone : contact2.getPhones()) {
                String phoneOVID = RSContacts.getOrCreateOVID(map, phone.getObjectID());
                phoneStmt.setString(1, contact2.getObjectID());
                phoneStmt.setString(2, contactOVID);
                phoneStmt.setString(3, contact2.getName());
                phoneStmt.setString(4, phone.getObjectID());
                phoneStmt.setString(5, phoneOVID);
                phoneStmt.setString(6, phone.getName());
                phoneStmt.setString(7, designOVID);
                phoneStmt.addBatch();
                if (++count4 != 1000) continue;
                count4 = 0;
                phoneStmt.executeBatch();
            }
            for (BIResourceLocator url : contact2.getUrls()) {
                String urlOVID = RSContacts.getOrCreateOVID(map, url.getObjectID());
                urlStmt.setString(1, contact2.getObjectID());
                urlStmt.setString(2, contactOVID);
                urlStmt.setString(3, contact2.getName());
                urlStmt.setString(4, url.getObjectID());
                urlStmt.setString(5, urlOVID);
                urlStmt.setString(6, url.getName());
                urlStmt.setString(7, designOVID);
                urlStmt.addBatch();
                if (++count5 != 1000) continue;
                count5 = 0;
                urlStmt.executeBatch();
            }
        }
        if (count5 > 0) {
            urlStmt.executeBatch();
        }
        urlStmt.close();
        urlStmt = null;
        if (count4 > 0) {
            phoneStmt.executeBatch();
        }
        phoneStmt.close();
        phoneStmt = null;
        if (count3 > 0) {
            locStmt.executeBatch();
        }
        locStmt.close();
        locStmt = null;
        if (count2 > 0) {
            emailStmt.executeBatch();
        }
        emailStmt.close();
        emailStmt = null;
        if (count1 > 0) {
            stmt.executeBatch();
            for (BIContact contact : list1) {
                RSComments.export(map, connection, contact);
                RSDynamicProperties.export(design, map, connection, contact);
            }
            list1.clear();
        }
        stmt.close();
        stmt = null;
    }
}

