/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;

public class RSAVT
extends RSGeneral {
    public static void export(Connection connection, List elements, Map map, String type) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_AVT (DataElement_ID, DataElement_OVID, Type, Sequence, Value, Short_Description, Container_ID, Container_OVID, Container_Name, DataElement_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (ContainedObjectWithDomain element : elements) {
            if (element.getValueList() == null) continue;
            Iterator vit = element.getValueIterator();
            int seq = 0;
            while (vit.hasNext()) {
                ++seq;
                Object key = vit.next();
                String value = (String)element.getValueList().getValuesDescriptionMap().get(key);
                stmt.setString(1, element.getObjectID());
                stmt.setString(2, (String)map.get(element.getObjectID()));
                stmt.setString(3, type);
                stmt.setInt(4, seq);
                stmt.setString(5, key.toString());
                stmt.setString(6, value);
                stmt.setString(7, element.getContainer().getObjectID());
                stmt.setString(8, (String)map.get(element.getObjectID()));
                stmt.setString(9, element.getContainer().getName());
                stmt.setString(10, element.getName());
                stmt.setString(11, (String)map.get(element.getDesign().getObjectID()));
                stmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

