/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.exports.ddl.udb.v71.SSBTableViewProxyUDBv71;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxyUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableViewProxyUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDBv81 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableViewProxyUDBv81 && ((TableViewProxyUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableView view = null;
        TableViewProxyUDBv81 tableViewProxy = null;
        if (object instanceof TableView) {
            view = (TableView)object;
            if (this.getStorageDesign(object) instanceof StorageDesignUDBv81) {
                this.storageDesign = (StorageDesignUDBv81)this.getStorageDesign(object);
                tableViewProxy = (TableViewProxyUDBv81)this.storageDesign.getProxy(view);
            }
        } else if (object instanceof TableViewProxyUDBv81) {
            tableViewProxy = (TableViewProxyUDBv81)object;
            view = (TableView)tableViewProxy.getObject();
            this.storageDesign = (StorageDesignUDBv81)this.getStorageDesign(object);
        }
        if (!view.isValidSQL()) {
            SSBTableViewProxyUDBv81.appendStringWithSpace(buffer, "--  ERROR: Invalid View " + view.getName());
            DDLFileMaker.incrementErrors();
            SSBTableViewProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBTableViewProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
            return;
        }
        if (tableViewProxy != null) {
            if (tableViewProxy.isCommentChanged()) {
                this.appendComment(buffer, tableViewProxy);
            } else {
                this.appendComment(buffer, view);
            }
            String stmt = tableViewProxy.getDefinition();
            stmt = stmt.trim();
            if (stmt.endsWith(";")) {
                stmt = stmt.substring(0, stmt.length() - 1).trim();
            }
            if (!"".equalsIgnoreCase(stmt)) {
                int index;
                String createViewPart = "";
                boolean includesColumnList = false;
                if (Token.getFirstToken(stmt).equalsIgnoreCase("CREATE") && (index = stmt.toUpperCase().indexOf("VIEW")) > -1) {
                    int viewNameIndex;
                    int dotIndex;
                    createViewPart = stmt.substring(0, index + 4);
                    String stmtWithoutNL = (stmt = stmt.substring(index + 4).trim()).replaceAll("[\t\n\f\r\u000b]+", " ");
                    String oldViewName = Token.getFirstName(stmtWithoutNL, '\"', '\"');
                    int bracketIndex = oldViewName.indexOf(40);
                    if (bracketIndex > -1) {
                        oldViewName = oldViewName.substring(0, bracketIndex);
                    }
                    if ((dotIndex = oldViewName.indexOf(46)) > -1) {
                        oldViewName = oldViewName.substring(dotIndex + 1);
                    }
                    if ((viewNameIndex = stmt.indexOf(oldViewName, dotIndex)) > -1 && (stmt = stmt.substring(viewNameIndex + oldViewName.length())).startsWith("\"")) {
                        stmt = stmt.substring(1);
                    }
                    if ((stmt = stmt.trim()).toUpperCase().startsWith("AS")) {
                        stmt = stmt.substring(2).trim();
                    } else if (stmt.startsWith("(")) {
                        includesColumnList = true;
                    }
                }
                if (!Token.startsWithString(createViewPart, "CREATE")) {
                    createViewPart = "CREATE VIEW";
                }
                String longName = this.storageDesign.isOpen() ? tableViewProxy.getLongNameDDL() : view.getLongNameDDL();
                createViewPart = createViewPart + ' ' + this.storageDesign.getFormatedName(longName);
                if (view.isBST()) {
                    createViewPart = createViewPart + SSBTableViewProxyUDBv71.appendStructuredType(tableViewProxy);
                }
                if (includesColumnList) {
                    stmt = createViewPart + ' ' + stmt;
                } else {
                    String columnList = this.getColumnList(view);
                    stmt = createViewPart + ' ' + columnList + ' ' + "AS" + NEWLINE + stmt;
                }
                this.appendBeforeCreateScript(buffer, prettyPrint, view);
                if (view.isBST()) {
                    SSBTableViewProxyUDBv81.appendStringWithSpace(buffer, stmt);
                    SSBTableViewProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableViewProxyUDBv81.appendLineFinisher(buffer, prettyPrint);
                    DDLFileMaker.incrementCreateView();
                    SSBTableViewProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
                    this.appendAfterCreateScript(buffer, prettyPrint, view);
                } else {
                    if ("YES".equalsIgnoreCase(tableViewProxy.getFederated())) {
                        if (stmt.toUpperCase().indexOf("CREATE FEDERATED") == -1) {
                            SSBTableViewProxyUDBv81.appendStringWithSpace(buffer, stmt.toUpperCase().replaceFirst("CREATE", "CREATE FEDERATED"));
                        } else {
                            SSBTableViewProxyUDBv81.appendStringWithSpace(buffer, stmt);
                        }
                    } else {
                        SSBTableViewProxyUDBv81.appendStringWithSpace(buffer, stmt);
                    }
                    this.appendCheckOption(buffer, tableViewProxy, prettyPrint);
                    SSBTableViewProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
                    SSBTableViewProxyUDBv81.appendLineFinisher(buffer, prettyPrint);
                    DDLFileMaker.incrementCreateView();
                    SSBTableViewProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
                    this.appendAfterCreateScript(buffer, prettyPrint, view);
                }
                if (view.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendViewCommentOn(this.storageDesign, buffer, view, tableViewProxy, prettyPrint);
                }
            } else {
                SSBTableViewProxyUDBv81.appendStringWithSpace(buffer, "--  ERROR: Invalid View " + view.getName() + " with empty body");
                DDLFileMaker.incrementErrors();
            }
        } else if (view != null && view.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendViewCommentOn(this.storageDesign, buffer, view, tableViewProxy, prettyPrint);
        }
    }

    protected String appendOwner(String definition, TableViewProxyUDBv81 view) {
        String result = definition;
        String name = Token.getTokenAfter(result, "VIEW");
        if (name.indexOf(46) == -1 && view.getOwner() != null && !view.getOwner().getName().equalsIgnoreCase("[Implicit]")) {
            String owner = this.storageDesign.getFormatedName(view.getOwner().getName());
            result = this.appendOwner(result, name, owner);
        }
        return result;
    }

    protected void appendCheckOption(StringBuffer buffer, TableViewProxyUDBv81 tableViewProxy, boolean prettyPrint) {
        String checkOptionClause;
        if (!tableViewProxy.getDefinition().equalsIgnoreCase("") && tableViewProxy.getCheckOption() && buffer.indexOf(checkOptionClause = "WITH " + tableViewProxy.getCheckOptionScope() + ' ' + "CHECK OPTION") == -1) {
            SSBTableViewProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBTableViewProxyUDBv81.appendStringWithSpace(buffer, checkOptionClause);
        }
    }
}

