/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.TypeElementProxy;
import oracle.dbtools.crest.model.design.storage.udb.MethodParamProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.MethodProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;

public class SSBStructuredTypeUDB
extends AbstractSSBUDB {
    @Override
    public boolean canHandle(Object object) {
        return object instanceof StructuredTypeProxyUDB || object instanceof StructuredType;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StructuredTypeProxyUDB typeProxy;
        StructuredType type;
        if (!(object instanceof StructuredType) && object instanceof StructuredTypeProxyUDB && !(type = (typeProxy = (StructuredTypeProxyUDB)object).getStructuredType()).isPredefined()) {
            this.appendComment(buffer, typeProxy);
            this.appendDefinition(buffer, typeProxy, prettyPrint);
        }
    }

    private void appendDefinition(StringBuffer buffer, StructuredTypeProxyUDB typeProxy, boolean prettyPrint) {
        boolean haselems = false;
        StructuredType st = typeProxy.getStructuredType();
        TypeElement[] elems = st.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElementProxy element = typeProxy.getElementByDesignObject(elems[i]);
            this.appendAttribute(buffer, element, typeProxy, prettyPrint);
            haselems = true;
        }
        if (haselems) {
            SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
        }
        haselems = false;
        for (MethodProxyUDB method : typeProxy.getMethods()) {
            this.appendMethod(buffer, method, typeProxy, prettyPrint);
            haselems = true;
        }
        if (haselems) {
            SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendAttribute(StringBuffer buffer, TypeElementProxy element, StructuredTypeProxyUDB typeProxy, boolean prettyPrint) {
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, "ALTER");
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, "TYPE");
        if (typeProxy.getSchema() != null && typeProxy.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBStructuredTypeUDB.appendString(buffer, typeProxy.getStorageDesign().getFormatedName(typeProxy.getSchema().getName()));
            SSBStructuredTypeUDB.appendString(buffer, '.');
        }
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, typeProxy.getStorageDesign().getFormatedName(typeProxy.getName()));
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, "ADD");
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, "ATTRIBUTE");
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, element.getName());
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, element.getDatatype("DB2/UDB 7.1"));
        SSBStructuredTypeUDB.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendMethod(StringBuffer buffer, MethodProxyUDB method, StructuredTypeProxyUDB typeProxy, boolean prettyPrint) {
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, "ALTER");
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, "TYPE");
        if (typeProxy.getSchema() != null && typeProxy.getAppView().getSettings().isIncludeSchemaInDDL()) {
            this.appendString(buffer, typeProxy.getSchema());
            SSBStructuredTypeUDB.appendString(buffer, '.');
        }
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, typeProxy.getName());
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, "ADD");
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, "METHOD");
        SSBStructuredTypeUDB.appendStringWithSpace(buffer, method.getName());
        if (method.getParams().size() > 0) {
            SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, '(');
            Iterator it = method.getParams().iterator();
            while (it.hasNext()) {
                MethodParamProxyUDB param = (MethodParamProxyUDB)it.next();
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendString(buffer, ' ');
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, param.getName());
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, param.getMethodParam().getDataType());
                if (param.isAsLocator()) {
                    SSBStructuredTypeUDB.appendStringWithSpace(buffer, "AS LOCATOR");
                }
                if (!it.hasNext()) continue;
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, ',');
            }
            SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, ')');
        }
        if (!"".equalsIgnoreCase(method.getReturnValue())) {
            SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, "RETURNS");
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, method.getReturnValue());
        }
        if (!"".equalsIgnoreCase(method.getSpecificName())) {
            SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, "SPECIFIC");
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, method.getSpecificName());
        }
        if ("YES".equalsIgnoreCase(method.getReturnSelfAsResult())) {
            SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, "SELF");
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, "AS");
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, "RESULT");
        }
        if ("SQL".equalsIgnoreCase(method.getLanguage())) {
            if ("YES".equalsIgnoreCase(method.getDeterministic())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "DETERMINISTIC");
            }
            if ("NO".equalsIgnoreCase(method.getExternalAction())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "NO");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "EXTERNAL");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "ACTION");
            } else if (method.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "EXTERNAL");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "ACTION");
            }
            if ("CONTAINS SQL".equalsIgnoreCase(method.getSqlStatementType())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "CONTAINS");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "SQL");
            }
            if ("YES".equalsIgnoreCase(method.getFederated())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "FEDERATED");
            } else {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "NOT FEDERATED");
            }
        } else {
            SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, "LANGUAGE");
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, method.getLanguage());
            SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, "PARAMETER");
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, "STYLE");
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, method.getExt_R_ParameterStyle());
            if ("YES".equalsIgnoreCase(method.getDeterministic())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "DETERMINISTIC");
            }
            if ("FENCED".equalsIgnoreCase(method.getExt_R_Safeness())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "FENCED");
            } else if (method.getExt_R_Safeness().equalsIgnoreCase("FENCED THREAD SAFE")) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "FENCED THREAD SAFE");
            } else if (method.getExt_R_Safeness().equalsIgnoreCase("FENCED NOT THREAD SAFE")) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "FENCED NOT THREAD SAFE");
            } else {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "NOT FENCED");
            }
            if ("RETURNS NULL ON NULL INPUT".equalsIgnoreCase(method.getNullParametersTreatment())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "RETURNS");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "NULL");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "ON");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "NULL");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "INPUT");
            }
            SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, "NO");
            SSBStructuredTypeUDB.appendStringWithSpace(buffer, "SQL");
            if ("NO".equalsIgnoreCase(method.getExternalAction())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "NO");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "EXTERNAL");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "ACTION");
            } else if (method.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "EXTERNAL");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "ACTION");
            }
            if (!"".equalsIgnoreCase(method.getExt_R_Scratchpad())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "SCRATCHPAD");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, method.getExt_R_Scratchpad());
            }
            if ("YES".equalsIgnoreCase(method.getExt_R_FinalCall())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "FINAL");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "CALL");
            }
            if ("DISALLOW".equalsIgnoreCase(method.getExt_R_ParallelInvocation())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "DISALLOW");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "PARALLEL");
            }
            if (!"OLE".equalsIgnoreCase(method.getLanguage()) && "YES".equalsIgnoreCase(method.getExt_R_DBInfo())) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "DBINFO");
            } else if (method.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "NO");
                SSBStructuredTypeUDB.appendStringWithSpace(buffer, "DBINFO");
            }
        }
        SSBStructuredTypeUDB.appendNewLine(buffer, prettyPrint, 0);
        SSBStructuredTypeUDB.appendLineFinisher(buffer, prettyPrint);
    }
}

