/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SecondaryXmlIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBXMLIndexSqlServerv2k5
extends AbstractSSBSqlServer {
    StorageDesignSqlServerv2k5 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Index index = null;
        IndexProxySqlServerv2k5 indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
            indexProxy = (IndexProxySqlServerv2k5)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxySqlServer) {
            indexProxy = (IndexProxySqlServerv2k5)object;
            index = (Index)indexProxy.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
        }
        if (indexProxy != null && indexProxy.isCommentChanged()) {
            this.appendComment(buffer, indexProxy);
        } else {
            this.appendComment(buffer, index);
        }
        if (indexProxy != null) {
            if (indexProxy.isMarkedGenerate()) {
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "CREATE");
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "PRIMARY");
                this.appendPrimary(buffer, indexProxy);
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "XML");
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "INDEX");
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getName()));
                this.appendTable(buffer, indexProxy, prettyPrint);
                this.appendOptions(buffer, indexProxy, prettyPrint);
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBXMLIndexSqlServerv2k5.appendString(buffer, "GO");
                this.appendSecondaryXMLIndexP(buffer, indexProxy, prettyPrint);
                DDLFileMaker.incrementCreateIndex();
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            } else if (index.hasIndexExpression()) {
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getIndexExpression());
            } else {
                buffer.append("-- Index ").append(index.getName()).append(" on Table ").append(indexProxy.getTableName()).append(" not created in ddl");
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            }
        }
    }

    private void appendSecondaryXMLIndexP(StringBuffer buffer, IndexProxySqlServerv2k5 indexProxy, boolean prettyPrint) {
        if (indexProxy.isMarkedGenerate() && indexProxy.isSecondaryXmlIndex()) {
            for (SecondaryXmlIndexSqlServerv2k5 secXMLIndex : indexProxy.getSecondaryXMLIndexs()) {
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "CREATE");
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "XML");
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "INDEX");
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(secXMLIndex.getName()));
                this.appendTable(buffer, indexProxy, prettyPrint);
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "USING");
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "XML");
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "INDEX");
                this.appendStringWithSpace(buffer, indexProxy);
                if (this.isNotEmpty(secXMLIndex.getIndexType())) {
                    SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "FOR");
                    SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, secXMLIndex.getIndexType());
                }
                this.appendOptions(buffer, indexProxy, prettyPrint);
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBXMLIndexSqlServerv2k5.appendString(buffer, "GO");
            }
        }
    }

    private void appendPrimary(StringBuffer buffer, IndexProxySqlServerv2k5 index) {
        if (!index.isSecondaryXmlIndex()) {
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "PRIMARY");
        }
    }

    private void appendTable(StringBuffer buffer, IndexProxySqlServerv2k5 index, boolean prettyPrint) {
        SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
        SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getTableName()));
        SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '(');
        SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        if (index.getIndex().hasIndexExpression()) {
            SSBXMLIndexSqlServerv2k5.appendString(buffer, ' ');
            SSBXMLIndexSqlServerv2k5.appendString(buffer, index.getIndex().getIndexExpression());
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        }
        ColumnProxy[] columns = index.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            String sortorder = "";
            if (columns[i].getObject() != null) {
                sortorder = ((Index)index.getObject()).getColumnSortOrder(columns[i].getObject());
            }
            SSBXMLIndexSqlServerv2k5.appendString(buffer, ' ');
            if ("DESC".equalsIgnoreCase(sortorder)) {
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()) + " " + sortorder);
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()) + " ASC");
            } else {
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
            }
            if (i != columns.length - 1) {
                this.appendComma(buffer);
            }
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, ')');
    }

    private void appendOptions(StringBuffer buffer, IndexProxySqlServerv2k5 index, boolean prettyPrint) {
        if ((index.getFillFactor() > 0 || index.getIgnoreDupKey().equalsIgnoreCase("YES") || index.getRecomputeStatistics().equalsIgnoreCase("OFF") || index.getSortInTempDB().equalsIgnoreCase("YES")) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "WITH");
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '(');
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBXMLIndexSqlServerv2k5.appendSpace(buffer);
            boolean writeComma = false;
            if (index.getFillFactor() > 0) {
                if (index.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "PAD_INDEX");
                    SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                    this.appendComma(buffer);
                    SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBXMLIndexSqlServerv2k5.appendSpace(buffer);
                }
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "FILLFACTOR");
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getFillFactor());
                writeComma = true;
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if (index.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "PAD_INDEX");
                    SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
                    SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                    this.appendComma(buffer);
                    SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBXMLIndexSqlServerv2k5.appendSpace(buffer);
                }
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "FILLFACTOR");
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "0");
                writeComma = true;
            }
            if (writeComma) {
                this.appendComma(buffer);
                SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBXMLIndexSqlServerv2k5.appendSpace(buffer);
            }
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "IGNORE_DUP_KEY");
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            if (index.getIgnoreDupKey().equalsIgnoreCase("YES")) {
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            } else {
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "OFF");
            }
            this.appendComma(buffer);
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBXMLIndexSqlServerv2k5.appendSpace(buffer);
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "STATISTICS_NORECOMPUTE");
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            if (index.getRecomputeStatistics().equalsIgnoreCase("OFF")) {
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            } else {
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "OFF");
            }
            this.appendComma(buffer);
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBXMLIndexSqlServerv2k5.appendSpace(buffer);
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "SORT_IN_TEMPDB");
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            if (index.getSortInTempDB().equalsIgnoreCase("YES")) {
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            } else {
                SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "OFF");
            }
            this.appendComma(buffer);
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBXMLIndexSqlServerv2k5.appendSpace(buffer);
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "DROP_EXISTING");
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getAllowRowLocks());
            this.appendComma(buffer);
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBXMLIndexSqlServerv2k5.appendSpace(buffer);
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "ALLOW_ROW_LOCKS");
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getAllowRowLocks());
            this.appendComma(buffer);
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBXMLIndexSqlServerv2k5.appendSpace(buffer);
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, "ALLOW_PAGE_LOCKS");
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, '=');
            SSBXMLIndexSqlServerv2k5.appendStringWithSpace(buffer, index.getAllowPageLocks());
            SSBXMLIndexSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBXMLIndexSqlServerv2k5.appendString(buffer, ')');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxySqlServerv2k5 && ((IndexProxy)object).isMarkedGenerate() && ((IndexProxySqlServerv2k5)object).isPrimaryXmlIndex();
    }
}

