/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StoredProcedureSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBStoredProcedureSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StoredProcedureSqlServerv2k5 proc = (StoredProcedureSqlServerv2k5)object;
        this.storageDesign = proc.getStorageDesign();
        this.appendComment(buffer, proc);
        SSBStoredProcedureSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        SSBStoredProcedureSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        this.appendDataBase(buffer, proc.getDatabase(), prettyPrint);
        this.appendCreate(buffer, proc);
        this.appendBody(buffer, proc, prettyPrint);
        SSBStoredProcedureSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, "GO");
        SSBStoredProcedureSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateProc();
        SSBStoredProcedureSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        if (proc.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendProcedureComment(buffer, proc, prettyPrint);
        }
        SSBStoredProcedureSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
    }

    private void appendProcedureComment(StringBuffer buffer, StoredProcedureSqlServerv2k5 proc, boolean prettyPrint) {
        String comment = proc.getCommentInRDBMS();
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBStoredProcedureSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, "EXEC");
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, "'MS_Description'");
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBStoredProcedureSqlServerv2k5.appendString(buffer, '\'');
            SSBStoredProcedureSqlServerv2k5.appendString(buffer, comment);
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, ',');
            if (proc != null && proc.getSchema() != null) {
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, "SCHEMA");
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, '\'');
                this.appendString(buffer, proc.getSchema());
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else if (proc != null && proc.getOwner() != null) {
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, "USER");
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, proc.getOwner().getName());
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, ',');
            } else {
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, "USER");
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, ',');
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendString(buffer, "dbo");
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, '\'');
                SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, ',');
            }
            SSBStoredProcedureSqlServerv2k5.appendString(buffer, '\'');
            SSBStoredProcedureSqlServerv2k5.appendString(buffer, "PROCEDURE");
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, ',');
            SSBStoredProcedureSqlServerv2k5.appendString(buffer, '\'');
            SSBStoredProcedureSqlServerv2k5.appendString(buffer, proc.getLongNameDDL());
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, '\'');
            SSBStoredProcedureSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBStoredProcedureSqlServerv2k5.appendString(buffer, "GO");
            SSBStoredProcedureSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendCreate(StringBuffer buffer, StoredProcedureSqlServerv2k5 proc) {
        this.appendCreate(buffer);
        SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, "PROCEDURE");
        if (proc.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBStoredProcedureSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(proc.getSchema().getName()));
            SSBStoredProcedureSqlServerv2k5.appendString(buffer, '.');
        }
        SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(proc.getName()));
    }

    private void appendBody(StringBuffer buffer, StoredProcedureSqlServerv2k5 proc, boolean prettyPrint) {
        SSBStoredProcedureSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
        if (!proc.getBody().trim().equalsIgnoreCase("")) {
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, proc.getBody());
        } else {
            SSBStoredProcedureSqlServerv2k5.appendStringWithSpace(buffer, " -- Empty body");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StoredProcedureSqlServerv2k5 && ((StoredProcedureSqlServerv2k5)object).isMarkedGenerate();
    }
}

