/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PermissionsSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;

public class SSBPermissionsSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesignSqlServerv2k5 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        PermissionsSqlServerv2k5 permissions = (PermissionsSqlServerv2k5)object;
        if (!(permissions.getTable() == null && permissions.getView() == null || permissions.getUser() == null && permissions.getRole() == null)) {
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
            if (!"".equalsIgnoreCase(permissions.getPrivileges())) {
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                this.appendComment(buffer, permissions);
                SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "GRANT");
                if (permissions.getPrivilegesSet().contains("ALL PRIVILEGES")) {
                    SSBPermissionsSqlServerv2k5.appendString(buffer, "ALL PRIVILEGES");
                } else {
                    SSBPermissionsSqlServerv2k5.appendString(buffer, permissions.getPrivileges());
                }
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                if (!"".equalsIgnoreCase(permissions.getColumnList())) {
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, '(');
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, permissions.getColumnList());
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, ')');
                }
                SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                if (permissions.getTable() != null) {
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                } else if (permissions.getView() != null) {
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                }
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "TO");
                if (permissions.getUser() != null) {
                    SSBPermissionsSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                } else if (permissions.getRole() != null) {
                    SSBPermissionsSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(permissions.getRole().getName()));
                }
                if (permissions.getAsRole() != null) {
                    SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "AS");
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getAsRole().getName()));
                }
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBPermissionsSqlServerv2k5.appendString(buffer, "GO");
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            }
            if (!"".equalsIgnoreCase(permissions.getPrivilegesWithGrantOption())) {
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                this.appendComment(buffer, permissions);
                SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "GRANT");
                if (permissions.getPrivilegesWithGrantOptionSet().contains("ALL PRIVILEGES")) {
                    SSBPermissionsSqlServerv2k5.appendString(buffer, "ALL PRIVILEGES");
                } else {
                    SSBPermissionsSqlServerv2k5.appendString(buffer, permissions.getPrivilegesWithGrantOption());
                }
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                if (permissions.getTable() != null) {
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                } else if (permissions.getView() != null) {
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                }
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "TO");
                if (permissions.getUser() != null) {
                    SSBPermissionsSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                } else if (permissions.getRole() != null) {
                    SSBPermissionsSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(permissions.getRole().getName()));
                }
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "WITH GRANT OPTION");
                if (permissions.getAsRole() != null) {
                    SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "AS");
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getAsRole().getName()));
                }
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                SSBPermissionsSqlServerv2k5.appendString(buffer, "GO");
                SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            }
            if (!"".equalsIgnoreCase(permissions.getColumnList())) {
                StringTokenizer st = new StringTokenizer(permissions.getColumnList(), "|");
                String priv = "";
                while (st.hasMoreTokens()) {
                    String col = st.nextToken();
                    if (col.indexOf(44) <= -1) continue;
                    priv = col.substring(col.indexOf(44) + 1);
                    col = col.substring(0, col.indexOf(44));
                    this.appendComment(buffer, permissions);
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "GRANT");
                    SSBPermissionsSqlServerv2k5.appendString(buffer, priv);
                    SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, '(');
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(col));
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, ')');
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "ON");
                    if (permissions.getTable() != null) {
                        this.appendStringWithSpace(buffer, permissions.getTable());
                    } else if (permissions.getView() != null) {
                        this.appendStringWithSpace(buffer, permissions.getView());
                    }
                    SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "TO");
                    if (permissions.getUser() != null) {
                        SSBPermissionsSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                    } else if (permissions.getRole() != null) {
                        SSBPermissionsSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(permissions.getRole().getName()));
                    }
                    if (permissions.getAsRole() != null) {
                        SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                        SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, "AS");
                        SSBPermissionsSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getAsRole().getName()));
                    }
                    SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
                    SSBPermissionsSqlServerv2k5.appendString(buffer, "GO");
                    SSBPermissionsSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
                }
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof PermissionsSqlServerv2k5 && ((PermissionsSqlServerv2k5)object).isMarkedGenerate()) {
            PermissionsSqlServerv2k5 perm = (PermissionsSqlServerv2k5)object;
            if (perm.getTable() != null && perm.getTable().getDatabase() != null && !perm.getTable().getDatabase().isNullInstance()) {
                return true;
            }
            if (perm.getView() != null && perm.getView().getDataBase() != null && !perm.getView().getDataBase().isNullInstance()) {
                return true;
            }
        }
        return false;
    }
}

