/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKSqlServerv2k5
extends AbstractSSBSqlServer {
    StorageDesignSqlServerv2k5 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        FKProxySqlServerv2k5 fkproxy;
        if (object instanceof FKIndexAssociation) {
            FKIndexAssociation fk = (FKIndexAssociation)object;
            RelationalDesign rd = (RelationalDesign)fk.getDesignPart();
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign();
            fkproxy = (FKProxySqlServerv2k5)this.storageDesign.getFKProxySet().getProxy(fk.getObjectID());
            if (fkproxy == null && (fkproxy = (FKProxySqlServerv2k5)this.storageDesign.getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID())) == null) {
                return;
            }
        } else {
            fkproxy = (FKProxySqlServerv2k5)object;
            this.storageDesign = (StorageDesignSqlServerv2k5)fkproxy.getStorageDesign();
        }
        if (fkproxy.getRemoteTable() instanceof Table) {
            this.appendBeforeAlterScript(buffer, prettyPrint, fkproxy.getTable());
            this.appendComment(buffer, fkproxy);
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            this.appendDataBase(buffer, ((TableProxySqlServerv2k5)fkproxy.getTableProxy()).getDatabase(), prettyPrint);
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "ALTER");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "TABLE");
            TableProxySqlServerv2k5 tp = (TableProxySqlServerv2k5)fkproxy.getTableProxy();
            if (tp != null) {
                SSBFKSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tp.getLongNameDDL()));
            } else {
                String owner = fkproxy.getTableSchema();
                if (!"".equalsIgnoreCase(owner)) {
                    SSBFKSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(owner) + '.' + this.storageDesign.getFormatedName(fkproxy.getTableName()));
                } else {
                    SSBFKSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy.getTableName()));
                }
            }
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "ADD");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "CONSTRAINT");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy.getName()));
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "FOREIGN KEY");
            this.appendColumns(buffer, fkproxy, prettyPrint);
            this.appendReferences(buffer, fkproxy, prettyPrint);
            this.appendOnDelete(buffer, fkproxy, prettyPrint);
            this.appendOnUpdate(buffer, fkproxy, prettyPrint);
            this.appendForReplication(buffer, fkproxy, prettyPrint);
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "GO");
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 0);
            DDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(buffer, prettyPrint, fkproxy.getTable());
        }
    }

    private void appendColumns(StringBuffer buffer, FKProxySqlServerv2k5 fk, boolean prettyPrint) {
        ColumnProxy[] columns = fk.getColumnProxies();
        if (columns.length > 0) {
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, '(');
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            for (int i = 0; i < columns.length; ++i) {
                SSBFKSqlServerv2k5.appendString(buffer, ' ');
                SSBFKSqlServerv2k5.appendString(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
                if (i != columns.length - 1) {
                    this.appendComma(buffer);
                }
                SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxySqlServerv2k5 fk, boolean prettyPrint) {
        SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "REFERENCES");
        SSBFKSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fk.getReferenceTableDDL()));
        Column[] columns = (Column[])fk.getRefColumns();
        SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        SSBFKSqlServerv2k5.appendStringWithSpace(buffer, '(');
        SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        for (int i = 0; i < columns.length; ++i) {
            SSBFKSqlServerv2k5.appendString(buffer, ' ');
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
            if (i != columns.length - 1) {
                this.appendComma(buffer);
            }
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBFKSqlServerv2k5.appendStringWithSpace(buffer, ')');
    }

    private void appendOnDelete(StringBuffer buffer, FKProxySqlServerv2k5 fk, boolean prettyPrint) {
        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
        if (!"".equals(fkass.getDeleteRule())) {
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "DELETE");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, fk.getStorageDesign().getValidFKRule(fkass.getDeleteRule()));
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "DELETE");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "NO ACTION");
        }
    }

    private void appendOnUpdate(StringBuffer buffer, FKProxySqlServerv2k5 fk, boolean prettyPrint) {
        if (!"".equals(fk.getOnUpdate())) {
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "UPDATE");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, fk.getOnUpdate());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "ON");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "UPDATE");
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "NO ACTION");
        }
    }

    private void appendForReplication(StringBuffer buffer, FKProxySqlServerv2k5 fk, boolean prettyPrint) {
        if (fk.getForReplication().equalsIgnoreCase("NO")) {
            SSBFKSqlServerv2k5.appendNewLine(buffer, prettyPrint, 1);
            SSBFKSqlServerv2k5.appendStringWithSpace(buffer, "NOT FOR REPLICATION");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof RelationalObjectProxy && !((RelationalObjectProxy)object).getStorageDesign().isOpen()) {
            if (object instanceof FKProxySqlServerv2k5) {
                return ((RelationalObjectProxy)object).getObject().isMarkedGenerate();
            }
        } else if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return object instanceof FKProxySqlServerv2k5 && ((TableProxySqlServerv2k5)((FKProxySqlServerv2k5)object).getTableProxy()).getDatabase() != null && !((TableProxySqlServerv2k5)((FKProxySqlServerv2k5)object).getTableProxy()).getDatabase().isNullInstance() && ((FKProxySqlServerv2k5)object).isMarkedGenerate();
    }
}

