/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k12;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.SequenceSqlServerv2k12;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSequenceSqlServerv2k12
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        SequenceSqlServerv2k12 sequence = (SequenceSqlServerv2k12)object;
        this.storageDesign = sequence.getStorageDesign();
        if (sequence.getDatabase() != null) {
            this.appendDataBase(buffer, sequence.getDatabase(), prettyPrint);
        }
        this.appendComment(buffer, sequence);
        SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "CREATE");
        SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "SEQUENCE");
        SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(sequence));
        advancedComment = buffer.toString();
        this.appendIntegerType(buffer, sequence, prettyPrint);
        this.appendStartWith(buffer, sequence, prettyPrint);
        this.appendIncrementBy(buffer, sequence, prettyPrint);
        this.appendMinValue(buffer, sequence, prettyPrint);
        this.appendMaxValue(buffer, sequence, prettyPrint);
        this.appendCycle(buffer, sequence, prettyPrint);
        this.appendCache(buffer, sequence, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBSequenceSqlServerv2k12.appendNewLine(oldbuffer, prettyPrint, 0);
        SSBSequenceSqlServerv2k12.appendStringWithSpace(oldbuffer, "GO");
        SSBSequenceSqlServerv2k12.appendNewLine(oldbuffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateSequence();
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SequenceSqlServerv2k12 && ((SequenceSqlServerv2k12)object).isMarkedGenerate();
    }

    private void appendIntegerType(StringBuffer buffer, SequenceSqlServerv2k12 sequence, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getIntegerTypeWithPrecision())) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "AS");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, sequence.getIntegerTypeWithPrecision());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "AS");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "bigint");
        }
    }

    private void appendStartWith(StringBuffer buffer, SequenceSqlServerv2k12 sequence, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getStartWith())) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "START");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "WITH");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, sequence.getStartWith());
        }
    }

    private void appendIncrementBy(StringBuffer buffer, SequenceSqlServerv2k12 sequence, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getIncrementBy()) && !sequence.getIncrementBy().trim().equals("0")) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "INCREMENT");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "BY");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, sequence.getIncrementBy());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "INCREMENT");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "BY");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "1");
        }
    }

    private void appendMinValue(StringBuffer buffer, SequenceSqlServerv2k12 sequence, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getMinValue())) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "MINVALUE");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, sequence.getMinValue());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "NO");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "MINVALUE");
        }
    }

    private void appendMaxValue(StringBuffer buffer, SequenceSqlServerv2k12 sequence, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getMaxValue())) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "MAXVALUE");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, sequence.getMaxValue());
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "NO");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "MAXVALUE");
        }
    }

    private void appendCycle(StringBuffer buffer, SequenceSqlServerv2k12 sequence, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(sequence.getCycle())) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "CYCLE");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "NO");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "CYCLE");
        }
    }

    private void appendCache(StringBuffer buffer, SequenceSqlServerv2k12 sequence, boolean prettyPrint) {
        if ("YES".equals(sequence.getNoCache())) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "NO");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "CACHE");
        } else if (this.isNotEmpty(sequence.getCache())) {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "CACHE");
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, sequence.getCache());
        } else {
            SSBSequenceSqlServerv2k12.appendNewLine(buffer, prettyPrint, 1);
            SSBSequenceSqlServerv2k12.appendStringWithSpace(buffer, "CACHE");
        }
    }
}

