/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.PermissionsSqlServerv2k;

public class SSBPermissionsSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        PermissionsSqlServerv2k permissions = (PermissionsSqlServerv2k)object;
        this.storageDesign = permissions.getStorageDesign();
        if (!(permissions.getTable() == null && permissions.getView() == null || permissions.getUser() == null && permissions.getRole() == null)) {
            if (!"".equalsIgnoreCase(permissions.getPrivileges())) {
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                this.appendComment(buffer, permissions);
                SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "GRANT");
                if (permissions.getPrivilegesSet().contains("ALL PRIVILEGES")) {
                    SSBPermissionsSqlServerv2k.appendString(buffer, "ALL PRIVILEGES");
                } else {
                    SSBPermissionsSqlServerv2k.appendString(buffer, permissions.getPrivileges());
                }
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                if (!"".equalsIgnoreCase(permissions.getColumnList())) {
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, '(');
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, permissions.getColumnList());
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, ')');
                }
                SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "ON");
                if (permissions.getTable() != null) {
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                } else if (permissions.getView() != null) {
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                }
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "TO");
                if (permissions.getUser() != null) {
                    SSBPermissionsSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                } else if (permissions.getRole() != null) {
                    this.appendString(buffer, permissions.getRole());
                }
                if (permissions.getAsRole() != null) {
                    SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "AS");
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getAsRole().getName()));
                }
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBPermissionsSqlServerv2k.appendString(buffer, "GO");
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            }
            if (!"".equalsIgnoreCase(permissions.getPrivilegesWithGrantOption())) {
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                this.appendComment(buffer, permissions);
                SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "GRANT");
                if (permissions.getPrivilegesWithGrantOptionSet().contains("ALL PRIVILEGES")) {
                    SSBPermissionsSqlServerv2k.appendString(buffer, "ALL PRIVILEGES");
                } else {
                    SSBPermissionsSqlServerv2k.appendString(buffer, permissions.getPrivilegesWithGrantOption());
                }
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "ON");
                if (permissions.getTable() != null) {
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                } else if (permissions.getView() != null) {
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                }
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "TO");
                if (permissions.getUser() != null) {
                    SSBPermissionsSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                } else if (permissions.getRole() != null) {
                    SSBPermissionsSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(permissions.getRole().getName()));
                }
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "WITH GRANT OPTION");
                if (permissions.getAsRole() != null) {
                    SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "AS");
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getAsRole().getName()));
                }
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBPermissionsSqlServerv2k.appendString(buffer, "GO");
                SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            }
            if (!"".equalsIgnoreCase(permissions.getColumnList())) {
                StringTokenizer st = new StringTokenizer(permissions.getColumnList(), "|");
                String priv = "";
                while (st.hasMoreTokens()) {
                    String col = st.nextToken();
                    if (col.indexOf(44) <= -1) continue;
                    priv = col.substring(col.indexOf(44) + 1);
                    col = col.substring(0, col.indexOf(44));
                    this.appendComment(buffer, permissions);
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "GRANT");
                    SSBPermissionsSqlServerv2k.appendString(buffer, priv);
                    SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, '(');
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(col));
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, ')');
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "ON");
                    if (permissions.getTable() != null) {
                        this.appendStringWithSpace(buffer, permissions.getTable());
                    } else if (permissions.getView() != null) {
                        this.appendStringWithSpace(buffer, permissions.getView());
                    }
                    SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "TO");
                    if (permissions.getUser() != null) {
                        SSBPermissionsSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                    } else if (permissions.getRole() != null) {
                        SSBPermissionsSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(permissions.getRole().getName()));
                    }
                    if (permissions.getAsRole() != null) {
                        SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                        SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, "AS");
                        SSBPermissionsSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getAsRole().getName()));
                    }
                    SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                    SSBPermissionsSqlServerv2k.appendString(buffer, "GO");
                    SSBPermissionsSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
                }
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof PermissionsSqlServerv2k && ((PermissionsSqlServerv2k)object).isMarkedGenerate()) {
            PermissionsSqlServerv2k perm = (PermissionsSqlServerv2k)object;
            if (perm.getTable() != null && perm.getTable().getDatabase() != null && !perm.getTable().getDatabase().isNullInstance()) {
                return true;
            }
            if (perm.getView() != null && perm.getView().getDataBase() != null && !perm.getView().getDataBase().isNullInstance()) {
                return true;
            }
        }
        return false;
    }
}

