/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTemporaryTablespaceOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        TemporaryTablespaceOraclev9i ts = (TemporaryTablespaceOraclev9i)object;
        this.storageDesign = ts.getStorageDesign();
        this.appendComment(oldbuffer, ts);
        this.appendCreateTemporaryTablespace(buffer, ts);
        this.appendTempFile(buffer, ts, prettyPrint);
        this.appendExtent(buffer, ts, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBTemporaryTablespaceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        SSBTemporaryTablespaceOraclev9i.appendLineFinisher(buffer, prettyPrint);
        SSBTemporaryTablespaceOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateTablespace();
    }

    private void appendCreateTemporaryTablespace(StringBuffer buffer, TemporaryTablespaceOraclev9i ts) {
        this.appendCreate(buffer);
        SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "TEMPORARY");
        SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
        SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
    }

    private void appendTempFile(StringBuffer buffer, TemporaryTablespaceOraclev9i ts, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(ts.getFilename().trim())) {
            SSBTemporaryTablespaceOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "TEMPFILE");
            SSBTemporaryTablespaceOraclev9i.appendString(buffer, '\'');
            SSBTemporaryTablespaceOraclev9i.appendString(buffer, ts.getFilename());
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, '\'');
            if (ts.getSize() != 0L) {
                SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "SIZE");
                SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, ts.getSize());
                SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, ts.getMeasureUnitSize());
            }
            if ("YES".equalsIgnoreCase(ts.getReuse())) {
                SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "REUSE");
            }
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "AUTOEXTEND");
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, ts.getAutoextend());
            if (ts.getAutoextend().equalsIgnoreCase("ON")) {
                SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "NEXT");
                SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, ts.getNextBlockSize());
                SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "K");
                SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "MAXSIZE");
                if (ts.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "UNLIMITED");
                } else {
                    SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, ts.getMaxSize());
                    SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "K");
                }
            }
        }
    }

    private void appendExtent(StringBuffer buffer, TemporaryTablespaceOraclev9i ts, boolean prettyPrint) {
        if (ts.getUniformSize() != 0L) {
            SSBTemporaryTablespaceOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "EXTENT");
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "MANAGEMENT");
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "LOCAL");
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "UNIFORM");
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, "SIZE");
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, ts.getUniformSize());
            SSBTemporaryTablespaceOraclev9i.appendStringWithSpace(buffer, ts.getMeasureUnitUniformSize());
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TemporaryTablespaceOraclev9i && ((TemporaryTablespaceOraclev9i)object).isMarkedGenerate();
    }
}

