/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v11g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBIndexOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v11g.SSBIndexOraclev11g;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableOraclev11g
extends SSBTableOraclev10g {
    private SSBIndexOraclev11g ssbIndex = null;

    @Override
    protected void appendDatatype(StringBuffer buffer, String datatype, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (datatype.equalsIgnoreCase("unknown") && columnProxy.isVirtual()) {
            return;
        }
        super.appendDatatype(buffer, datatype, columnProxy, prettyPrint);
    }

    @Override
    protected void appendColumnOptions(StringBuffer buffer, TableProxyOraclev10g tableProxy, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        ColumnProxyOraclev11g columnProxy11g = (ColumnProxyOraclev11g)columnProxy;
        this.appendInvisible(buffer, columnProxy);
        if (columnProxy.isVirtual()) {
            this.appendVirtualColumnDefinition(buffer, tableProxy, columnProxy11g, prettyPrint);
        } else {
            this.appendWithDefaultDefinition(buffer, columnProxy);
        }
        this.appendEncrypt(buffer, columnProxy11g, prettyPrint);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(buffer, tableProxy, columnProxy, prettyPrint);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBTableOraclev11g.appendString(buffer, ' ');
            SSBTableOraclev11g.appendStringWithSpace(buffer, "NULL");
        }
    }

    private void appendVirtualColumnDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, ColumnProxyOraclev11g columnProxy, boolean prettyPrint) {
        SSBTableOraclev11g.appendStringWithSpace(buffer, "AS");
        SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
        SSBTableOraclev11g.appendStringWithSpace(buffer, columnProxy.getColumnExpression());
        SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
        SSBTableOraclev11g.appendStringWithSpace(buffer, "VIRTUAL");
        if (tableProxy.getOrganization().equalsIgnoreCase("INDEX")) {
            this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorVirtualColumnOrgIndex"), prettyPrint);
        }
        if (tableProxy.getCluster() != null) {
            this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorVirtualColumnCluster"), prettyPrint);
        }
        if ("YES".equalsIgnoreCase(tableProxy.getTemporary())) {
            this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorVirtualColumnTempTable"), prettyPrint);
        }
    }

    protected void appendInvisible(StringBuffer buffer, ColumnProxyOracle columnProxy) {
    }

    private void appendEncrypt(StringBuffer buffer, ColumnProxyOraclev11g columnProxy, boolean prettyPrint) {
        if (columnProxy.getEncrypt().equalsIgnoreCase("YES") && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL() && this.storageDesign.getAppView().getSettings().isIncludeEncryptionInDDL()) {
            String useSalt;
            String integrityAlgorithm;
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
            SSBTableOraclev11g.appendString(buffer, ' ');
            SSBTableOraclev11g.appendStringWithSpace(buffer, "ENCRYPT");
            String encryptionAlgorithm = columnProxy.getEncryptionAlgorithm();
            if (encryptionAlgorithm.length() > 0) {
                SSBTableOraclev11g.appendStringWithSpace(buffer, "USING");
                SSBTableOraclev11g.appendStringWithSpace(buffer, '\'' + encryptionAlgorithm + '\'');
            }
            if ((integrityAlgorithm = columnProxy.getIntegrityAlgorithm()).length() > 0) {
                SSBTableOraclev11g.appendStringWithSpace(buffer, '\'' + integrityAlgorithm + '\'');
            }
            if ((useSalt = columnProxy.getUseSalt()).equalsIgnoreCase("YES")) {
                SSBTableOraclev11g.appendStringWithSpace(buffer, "SALT");
            } else if (useSalt.equalsIgnoreCase("NO")) {
                SSBTableOraclev11g.appendStringWithSpace(buffer, "NO");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "SALT");
            }
        }
    }

    @Override
    protected void appendCompressClause(StringBuffer buffer, TableProxyOracle tableProxy) {
        String compressionType;
        SSBTableOraclev11g.appendStringWithSpace(buffer, "COMPRESS");
        if (tableProxy instanceof TableProxyOraclev11g && (compressionType = ((TableProxyOraclev11g)tableProxy).getCompressionType()).length() > 0 && !compressionType.equals("BASIC")) {
            SSBTableOraclev11g.appendStringWithSpace(buffer, "FOR");
            SSBTableOraclev11g.appendStringWithSpace(buffer, compressionType);
        }
    }

    @Override
    protected void appendRefPartitionFK(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        FKIndexAssociation fk;
        FKProxyOracle fkproxy;
        PartitionListOracle partitionList = tableProxy.getPartitionList();
        if (partitionList != null && partitionList.getPartitionType().equals("REFERENCE") && (fkproxy = ((PartitionListOraclev11g)partitionList).getRefConstraint()) != null && ((fk = fkproxy.getIndex().getFKAssociation()).getRemoteTable() != null || !fk.getReferredTableLongName().isEmpty())) {
            this.appendComma(buffer);
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            String fkName = fkproxy.getName();
            if (!fkName.startsWith("SYS_")) {
                SSBTableOraclev11g.appendStringWithSpace(buffer, "CONSTRAINT");
                SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(fkproxy));
                if (fkName.length() > tableProxy.getMaxNameLength()) {
                    this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorNameTooLong"), prettyPrint);
                }
            }
            SSBTableOraclev11g.appendStringWithSpace(buffer, "FOREIGN KEY");
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 0);
            String columnList = fkproxy.getColumns(this.storageDesign);
            if (columnList.length() > 0) {
                SSBTableOraclev11g.appendString(buffer, columnList);
            } else {
                this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorFKNoCols"), prettyPrint);
            }
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
            this.appendReferences(buffer, fkproxy);
            this.appendOnDelete(buffer, fkproxy, prettyPrint);
            this.appendConstraintState(buffer, fkproxy);
        }
    }

    private void appendReferences(StringBuffer buffer, FKProxyOracle fk) {
        SSBTableOraclev11g.appendNewLine(buffer, true, 1);
        FKContainer refTable = fk.getFKTable();
        if (refTable != null) {
            SSBTableOraclev11g.appendStringWithSpace(buffer, "REFERENCES");
            ModelIDObject refTableObject = this.storageDesign.getTableProxySet().getProxy(refTable.getObjectID());
            if (refTableObject == null) {
                refTableObject = refTable;
            }
            SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(refTableObject));
            boolean refStructType = false;
            if (refTable.isBST()) {
                ColumnProxy[] columnProxies = fk.getColumnProxies();
                for (int i = 0; i < columnProxies.length; ++i) {
                    Column column = columnProxies[i].getColumn();
                    if (!column.isReference() || column.getUse() != 3) continue;
                    refStructType = true;
                }
            }
            if (!refStructType) {
                SSBTableOraclev11g.appendNewLine(buffer, true, 1);
                SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev11g.appendNewLine(buffer, true, 0);
                SSBTableOraclev11g.appendString(buffer, fk.getReferenceColumns(this.storageDesign));
                SSBTableOraclev11g.appendNewLine(buffer, true, 1);
                SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
            }
        } else {
            FKIndexAssociation fkIndexAssociation = fk.getIndex().getFKAssociation();
            String formattedTableLongName = fkIndexAssociation.getFormattedReferredTableLongName();
            if (!formattedTableLongName.isEmpty()) {
                SSBTableOraclev11g.appendStringWithSpace(buffer, "REFERENCES");
                SSBTableOraclev11g.appendStringWithSpace(buffer, formattedTableLongName);
                SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(fkIndexAssociation.getReferredColumnNames()));
                SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendOnDelete(StringBuffer buffer, FKProxyOracle fk, boolean prettyPrint) {
        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
        String onDelete = fkass.getDeleteRule();
        if (onDelete.equalsIgnoreCase("SET DEFAULT")) {
            onDelete = fkass.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        if (!onDelete.equalsIgnoreCase("RESTRICT") && !onDelete.equalsIgnoreCase("NO ACTION")) {
            SSBTableOraclev11g.appendNewLine(buffer, true, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, "ON");
            SSBTableOraclev11g.appendStringWithSpace(buffer, "DELETE");
            SSBTableOraclev11g.appendStringWithSpace(buffer, onDelete);
            if (onDelete.equalsIgnoreCase("SET NULL")) {
                this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorRefFKOnDeleteSetNull"), prettyPrint);
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            // empty if block
        }
    }

    private void appendConstraintState(StringBuffer buffer, FKProxyOracle fk) {
        if (this.storageDesign.isOpen()) {
            SSBTableOraclev11g.appendNewLine(buffer, true, 1);
            if ("NO".equalsIgnoreCase(fk.getDeferrable())) {
                SSBTableOraclev11g.appendStringWithSpace(buffer, "NOT");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "DEFERRABLE");
            } else {
                SSBTableOraclev11g.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(fk.getInitially())) {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "INITIALLY");
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "INITIALLY");
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(fk.getEnable())) {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(fk.getValidate())) {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(fk.getEnable())) {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(fk.getValidate())) {
                        SSBTableOraclev11g.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(fk.getValidate())) {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            if (fk.getExceptionsTable() != null) {
                SSBTableOraclev11g.appendNewLine(buffer, true, 1);
                buffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedLongNameDDL(fk.getExceptionsTable()));
            }
        }
    }

    @Override
    public void appendPartitionList(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        PartitionListOraclev11g partitionList = (PartitionListOraclev11g)tableProxy.getPartitionList();
        if (partitionList != null) {
            this.tableProxy = tableProxy;
            this.table = (Table)tableProxy.getObject();
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOraclev11g)tableProxy.getStorageDesign();
            }
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "RANGE");
                SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                String intervalExpression = partitionList.getIntervalExpression().trim();
                if (intervalExpression.length() > 0) {
                    SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "INTERVAL");
                    SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev11g.appendStringWithSpace(buffer, intervalExpression);
                    SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                    if (partitionList.getIntervalTablespaces().length() > 0) {
                        SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                        SSBTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                        SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIntervalTablespaces()));
                        SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                }
                this.appendSubPartitionDefinition(buffer, tableProxy, partitionList, prettyPrint);
                boolean composite = !subpartitionType.equalsIgnoreCase("");
                this.appendPartitions(buffer, partitionList, true, composite, prettyPrint);
            } else if (partitionType.startsWith("HASH")) {
                SSBTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "HASH");
                SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendSubPartitionDefinition(buffer, tableProxy, partitionList, prettyPrint);
                if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                    SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "PARTITIONS");
                    SSBTableOraclev11g.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                    if (!"".equals(partitionList.getHashPTableSpaces())) {
                        SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                        SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                        SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                    if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                        SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev11g.appendStringWithSpace(buffer, "OVERFLOW");
                        SSBTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                        SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                        SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                } else {
                    this.appendHashPartitions(buffer, partitionList, prettyPrint);
                }
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                SSBTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "LIST");
                SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendSubPartitionDefinition(buffer, tableProxy, partitionList, prettyPrint);
                this.appendListPartitions(buffer, partitionList, prettyPrint);
            } else if ("REFERENCE".equalsIgnoreCase(partitionType)) {
                FKIndexAssociation fk;
                FKProxyOracle refConstraint = partitionList.getRefConstraint();
                SSBTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "REFERENCE");
                if (tableProxy.getOrganization().equalsIgnoreCase("INDEX")) {
                    this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorRefPartOrgIndex"), prettyPrint);
                }
                SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                FKContainer remoteTable = null;
                boolean validFK = false;
                if (!(refConstraint == null || (remoteTable = (fk = refConstraint.getIndex().getFKAssociation()).getRemoteTable()) == null && fk.getReferredTableLongName().isEmpty())) {
                    validFK = true;
                }
                if (!validFK) {
                    this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorRefConstraintMissing"), prettyPrint);
                } else {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(refConstraint));
                    if (remoteTable != null) {
                        TableProxyOraclev10g remoteTableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(remoteTable.getObjectID());
                        if (remoteTableProxy == tableProxy) {
                            this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorSelfRefFK"), prettyPrint);
                        } else if (remoteTableProxy != null && !remoteTableProxy.getPartitioned().equalsIgnoreCase("YES")) {
                            this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorRefTableNotPartitioned"), prettyPrint);
                        }
                    }
                    if (refConstraint.getEnable().equalsIgnoreCase("NO") || refConstraint.getValidate().equalsIgnoreCase("NO") || refConstraint.getDeferrable().equalsIgnoreCase("YES")) {
                        this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorRefFKStateInvalid"), prettyPrint);
                    }
                    ColumnProxy[] columnProxies = refConstraint.getColumnProxies();
                    for (int i = 0; i < columnProxies.length; ++i) {
                        Column column = columnProxies[i].getColumn();
                        if (column == null || !column.getNullsAllowed()) continue;
                        this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorRefFKColsNull"), prettyPrint);
                        break;
                    }
                }
                SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, false, false, prettyPrint);
            } else if ("SYSTEM".equalsIgnoreCase(partitionType)) {
                int systemPartitions;
                SSBTableOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(buffer, "SYSTEM");
                if (tableProxy.getOrganization().equalsIgnoreCase("INDEX")) {
                    this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorSysPartIndexOrg"), prettyPrint);
                }
                if ((systemPartitions = partitionList.getSystemPartitions()) > 1) {
                    SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "PARTITIONS");
                    SSBTableOraclev11g.appendStringWithSpace(buffer, systemPartitions);
                } else {
                    this.appendPartitions(buffer, partitionList, false, false, prettyPrint);
                }
            }
        }
    }

    private void appendSubPartitionDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, PartitionListOraclev11g partitionList, boolean prettyPrint) {
        String subpartitionType = partitionList.getSubpartitionType();
        if (subpartitionType.equalsIgnoreCase("HASH")) {
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBTableOraclev11g.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev11g.appendStringWithSpace(buffer, "HASH");
            SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
            SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
            if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
                if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                    SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    SSBTableOraclev11g.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                    if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                        SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                        SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "1");
                }
            } else {
                this.appendHashSubPartitionTemplates(buffer, tableProxy, prettyPrint);
            }
        } else if (subpartitionType.equalsIgnoreCase("LIST")) {
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBTableOraclev11g.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev11g.appendStringWithSpace(buffer, "LIST");
            SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
            SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
            this.appendListSubPartitionTemplates(buffer, tableProxy, prettyPrint);
        } else if (subpartitionType.equalsIgnoreCase("RANGE")) {
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBTableOraclev11g.appendStringWithSpace(buffer, "BY");
            SSBTableOraclev11g.appendStringWithSpace(buffer, "RANGE");
            SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
            SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
            SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
            this.appendRangeSubPartitionTemplates(buffer, tableProxy, prettyPrint);
        }
    }

    private void appendRangeSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        StorageObjectCollection templates = tableProxy.getListStorageTemplates();
        if (templates.size() > 0) {
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBTableOraclev11g.appendStringWithSpace(buffer, "TEMPLATE");
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < templates.size(); ++i) {
                PartitionOraclev11g temp = (PartitionOraclev11g)templates.getElement(i);
                if (i > 0) {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, ',');
                }
                SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!temp.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(temp));
                }
                SSBTableOraclev11g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(buffer, temp.getValueList());
                SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, temp, prettyPrint);
            }
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    protected void appendSubPartitions(StringBuffer buffer, AbstractStorageObjectOracle partition, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        if (partitionList.getSubpartitionType().equalsIgnoreCase("HASH")) {
            StorageObjectCollection subpartitions = null;
            int subPartitionsQuantity = 0;
            String subPartitionsTableSpaceIDs = "";
            if (partition instanceof PartitionOraclev11g) {
                PartitionOraclev11g rangePartition = (PartitionOraclev11g)partition;
                subpartitions = rangePartition.getPartitions();
                subPartitionsQuantity = rangePartition.getSubPartitionsQuantity();
                subPartitionsTableSpaceIDs = rangePartition.getSubPartitionsTableSpaces();
            } else if (partition instanceof ListPartitionOraclev11g) {
                ListPartitionOraclev11g listPartition = (ListPartitionOraclev11g)partition;
                subpartitions = listPartition.getHashSubpartitions();
                subPartitionsQuantity = listPartition.getSubPartitionsQuantity();
                subPartitionsTableSpaceIDs = listPartition.getSubPartitionsTableSpaces();
            }
            if (!this.appendHashSubPartitions(buffer, subpartitions, partitionList, prettyPrint) && subPartitionsQuantity > 0) {
                SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                SSBTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                SSBTableOraclev11g.appendStringWithSpace(buffer, subPartitionsQuantity);
                if (!"".equalsIgnoreCase(subPartitionsTableSpaceIDs)) {
                    SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                    SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                    SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionsTableSpaceIDs));
                    SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                }
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("LIST")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendListSubPartitions(buffer, ((PartitionOraclev11g)partition).getListPartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendListSubPartitions(buffer, ((ListPartitionOraclev11g)partition).getListSubpartitions(), prettyPrint);
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("RANGE")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, ((PartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, ((ListPartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            }
        }
    }

    private void appendRangeSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, boolean prettyPrint) {
        if (subpartitions.size() > 0) {
            Object[] subpartitionsList = subpartitions.toArray();
            Arrays.sort(subpartitionsList, new PositionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < subpartitionsList.length; ++i) {
                sortedList.add(subpartitionsList[i]);
            }
            Iterator rangeSubpartitions = sortedList.iterator();
            boolean firstPart = true;
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
            while (rangeSubpartitions.hasNext()) {
                PartitionOraclev11g rangeSubpartition = (PartitionOraclev11g)rangeSubpartitions.next();
                if (!firstPart) {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, ',');
                } else {
                    firstPart = false;
                }
                SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                SSBTableOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!rangeSubpartition.getName().toUpperCase().startsWith("SYS_")) {
                    SSBTableOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(rangeSubpartition));
                }
                SSBTableOraclev11g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                SSBTableOraclev11g.appendStringWithSpace(buffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(buffer, rangeSubpartition.getValueList());
                SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, rangeSubpartition, prettyPrint);
            }
            SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBTableOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    protected SSBIndexOraclev10g getSSBIndex() {
        if (this.ssbIndex == null) {
            this.ssbIndex = new SSBIndexOraclev11g();
            this.ssbIndex.setStorageDesign(this.storageDesign);
        }
        return this.ssbIndex;
    }

    private void appendError(StringBuffer buffer, String errorText, boolean prettyPrint) {
        SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 0);
        SSBTableOraclev11g.appendStringWithSpace(buffer, "--  " + errorText);
        SSBTableOraclev11g.appendNewLine(buffer, prettyPrint, 5);
        DDLFileMaker.incrementErrors();
    }

    static class PositionComparator
    implements Comparator {
        PositionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOracle)one).getPosition() > ((PartitionOracle)two).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)one).getPosition() < ((PartitionOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

