/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v11g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBSnapshotOraclev10g;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSnapshotOraclev11g
extends SSBSnapshotOraclev10g {
    @Override
    protected void appendPartitioning(StringBuffer buffer, SnapshotOraclev10g snapshot, boolean prettyPrint) {
        PartitionListOraclev11g partitionList = (PartitionListOraclev11g)snapshot.getPartitionList();
        if (partitionList != null) {
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "RANGE");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                String intervalExpression = partitionList.getIntervalExpression().trim();
                if (intervalExpression.length() > 0) {
                    SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "INTERVAL");
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, intervalExpression);
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                    if (partitionList.getIntervalTablespaces().length() > 0) {
                        SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIntervalTablespaces()));
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                }
                this.appendSubPartitionDefinition(buffer, snapshot, partitionList, prettyPrint);
                boolean composite = !subpartitionType.equalsIgnoreCase("");
                this.appendPartitions(buffer, partitionList, true, composite, prettyPrint);
            } else if (partitionType.startsWith("HASH")) {
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "HASH");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendSubPartitionDefinition(buffer, snapshot, partitionList, prettyPrint);
                if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                    SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITIONS");
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                    if (!"".equals(partitionList.getHashPTableSpaces())) {
                        SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                    if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                        SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "OVERFLOW");
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                } else {
                    this.appendHashPartitions(buffer, partitionList, prettyPrint);
                }
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "LIST");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendSubPartitionDefinition(buffer, snapshot, partitionList, prettyPrint);
                this.appendListPartitions(buffer, partitionList, prettyPrint);
            } else if ("REFERENCE".equalsIgnoreCase(partitionType)) {
                FKContainer remoteTable;
                FKProxyOracle refConstraint = partitionList.getRefConstraint();
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "REFERENCE");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                FKContainer fKContainer = remoteTable = refConstraint == null ? null : refConstraint.getFKTable();
                if (remoteTable == null) {
                    this.appendError(buffer, Messages.getString("SSBTableOraclev11g.ErrorRefConstraintMissing"), prettyPrint);
                } else {
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(refConstraint));
                }
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, false, false, prettyPrint);
            } else if ("SYSTEM".equalsIgnoreCase(partitionType)) {
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITION");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SYSTEM");
                int systemPartitions = partitionList.getSystemPartitions();
                if (systemPartitions > 1) {
                    SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "PARTITIONS");
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, systemPartitions);
                } else {
                    this.appendPartitions(buffer, partitionList, false, false, prettyPrint);
                }
            }
        }
    }

    private void appendSubPartitionDefinition(StringBuffer buffer, SnapshotOraclev10g snapshot, PartitionListOraclev11g partitionList, boolean prettyPrint) {
        String subpartitionType = partitionList.getSubpartitionType();
        if (subpartitionType.equalsIgnoreCase("HASH")) {
            SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "HASH");
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
            if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
                if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                    SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                    if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "1");
                }
            }
        } else if (subpartitionType.equalsIgnoreCase("LIST")) {
            SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "LIST");
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
        } else if (subpartitionType.equalsIgnoreCase("RANGE")) {
            SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "BY");
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "RANGE");
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    protected void appendSubPartitions(StringBuffer buffer, AbstractStorageObjectOracle partition, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        if (partitionList.getSubpartitionType().equalsIgnoreCase("HASH")) {
            StorageObjectCollection subpartitions = null;
            int subPartitionsQuantity = 0;
            String subPartitionsTableSpaceIDs = "";
            if (partition instanceof PartitionOraclev11g) {
                PartitionOraclev11g rangePartition = (PartitionOraclev11g)partition;
                subpartitions = rangePartition.getPartitions();
                subPartitionsQuantity = rangePartition.getSubPartitionsQuantity();
                subPartitionsTableSpaceIDs = rangePartition.getSubPartitionsTableSpaces();
            } else if (partition instanceof ListPartitionOraclev11g) {
                ListPartitionOraclev11g listPartition = (ListPartitionOraclev11g)partition;
                subpartitions = listPartition.getHashSubpartitions();
                subPartitionsQuantity = listPartition.getSubPartitionsQuantity();
                subPartitionsTableSpaceIDs = listPartition.getSubPartitionsTableSpaces();
            }
            if (!this.appendHashSubPartitions(buffer, subpartitions, partitionList, prettyPrint) && subPartitionsQuantity > 0) {
                SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITIONS");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, subPartitionsQuantity);
                if (!"".equalsIgnoreCase(subPartitionsTableSpaceIDs)) {
                    SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "STORE IN");
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionsTableSpaceIDs));
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                }
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("LIST")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendListSubPartitions(buffer, ((PartitionOraclev11g)partition).getListPartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendListSubPartitions(buffer, ((ListPartitionOraclev11g)partition).getListSubpartitions(), prettyPrint);
            }
        } else if (partitionList.getSubpartitionType().equalsIgnoreCase("RANGE")) {
            if (partition instanceof PartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, ((PartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            } else if (partition instanceof ListPartitionOraclev11g) {
                this.appendRangeSubPartitions(buffer, ((ListPartitionOraclev11g)partition).getRangeSubpartitions(), prettyPrint);
            }
        }
    }

    private void appendRangeSubPartitions(StringBuffer buffer, StorageObjectCollection subpartitions, boolean prettyPrint) {
        if (subpartitions.size() > 0) {
            Object[] subpartitionsList = subpartitions.toArray();
            Arrays.sort(subpartitionsList, new PositionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < subpartitionsList.length; ++i) {
                sortedList.add(subpartitionsList[i]);
            }
            Iterator rangeSubpartitions = sortedList.iterator();
            boolean firstPart = true;
            SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
            while (rangeSubpartitions.hasNext()) {
                PartitionOraclev11g rangeSubpartition = (PartitionOraclev11g)rangeSubpartitions.next();
                if (!firstPart) {
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ',');
                } else {
                    firstPart = false;
                }
                SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 2);
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!rangeSubpartition.getName().toUpperCase().startsWith("SYS_")) {
                    SSBSnapshotOraclev11g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(rangeSubpartition));
                }
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "VALUES LESS THAN");
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, rangeSubpartition.getValueList());
                SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, rangeSubpartition, prettyPrint);
            }
            SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev11g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendError(StringBuffer buffer, String errorText, boolean prettyPrint) {
        SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 0);
        SSBSnapshotOraclev11g.appendStringWithSpace(buffer, "--  " + errorText);
        SSBSnapshotOraclev11g.appendNewLine(buffer, prettyPrint, 5);
        DDLFileMaker.incrementErrors();
    }

    static class PositionComparator
    implements Comparator {
        PositionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOracle)one).getPosition() > ((PartitionOracle)two).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)one).getPosition() < ((PartitionOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

