/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.RollbackSegmentOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBRollbackSegmentOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        RollbackSegmentOraclev10g segment = (RollbackSegmentOraclev10g)object;
        this.storageDesign = segment.getStorageDesign();
        this.appendPrompt(buffer, segment, "ROLLBACK SEGMENT");
        this.appendComment(oldbuffer, segment);
        this.appendCreateSegment(buffer, segment);
        advancedComment = buffer.toString();
        this.appendTablespaces(buffer, segment, prettyPrint);
        this.appendStorage(buffer, segment, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBRollbackSegmentOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        SSBRollbackSegmentOraclev10g.appendLineFinisher(buffer, prettyPrint);
        SSBRollbackSegmentOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateRollbackSegment();
    }

    private void appendCreateSegment(StringBuffer buffer, RollbackSegmentOraclev10g segment) {
        this.appendCreate(buffer);
        if ("YES".equalsIgnoreCase(segment.getPub())) {
            SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "PUBLIC");
        }
        SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "ROLLBACK");
        SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "SEGMENT");
        SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(segment));
    }

    private void appendTablespaces(StringBuffer buffer, RollbackSegmentOraclev10g segment, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            for (int i = 0; i < segment.getTablespaceSet().size(); ++i) {
                TableSpaceOracle ts = (TableSpaceOracle)segment.getStorageDesignOracle().getTableSpaceSet().getById((String)segment.getTablespaceSet().elementAt(i));
                if (ts == null) continue;
                SSBRollbackSegmentOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            }
        }
    }

    private void appendStorage(StringBuffer buffer, RollbackSegmentOraclev10g segment, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBRollbackSegmentOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "STORAGE");
            SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, '(');
            boolean props = false;
            if (segment.getSCInitialExtent() > 0 && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                SSBRollbackSegmentOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, segment.getInitialSizeUnit());
                props = true;
            }
            if (segment.getSCNextExtent() > 0 && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                SSBRollbackSegmentOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "NEXT");
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, segment.getSCNextExtent());
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, segment.getNextSizeUnit());
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                SSBRollbackSegmentOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, segment.getSCMinExtents());
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBRollbackSegmentOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeOptimalInDDL()) {
                SSBRollbackSegmentOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "OPTIMAL");
                if ("".equalsIgnoreCase(segment.getScOptimal().trim())) {
                    SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, "NULL");
                } else {
                    SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, segment.getScOptimal());
                }
                props = true;
            }
            if (props) {
                SSBRollbackSegmentOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBRollbackSegmentOraclev10g.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof RollbackSegmentOraclev10g && ((RollbackSegmentOraclev10g)object).isMarkedGenerate();
    }
}

