/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.RoleOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBRoleOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        RoleOraclev10g role = (RoleOraclev10g)object;
        this.storageDesign = role.getStorageDesign();
        this.appendPrompt(buffer, role, "ROLE");
        this.appendComment(buffer, role);
        SSBRoleOraclev10g.appendStringWithSpace(buffer, "CREATE");
        SSBRoleOraclev10g.appendStringWithSpace(buffer, "ROLE");
        SSBRoleOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role));
        advancedComment = buffer.toString();
        this.appendIdentification(buffer, role, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        SSBRoleOraclev10g.appendLineFinisher(buffer, prettyPrint);
        SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        DDLFileMaker.incrementCreateRole();
        this.appendRolesAndPrivileges(oldbuffer, role, prettyPrint);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof RoleOraclev10g && ((RoleOraclev10g)object).isMarkedGenerate();
    }

    private void appendIdentification(StringBuffer buffer, RoleOraclev10g role, boolean prettyPrint) {
        SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if ("YES".equalsIgnoreCase(role.getIdentified())) {
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "IDENTIFIED");
            if ("BY_PASSWORD".equalsIgnoreCase(role.getAuthType())) {
                SSBRoleOraclev10g.appendStringWithSpace(buffer, "BY");
                SSBRoleOraclev10g.appendStringWithSpace(buffer, role.decodePassword());
            } else if ("USING PACKAGE".equalsIgnoreCase(role.getAuthType())) {
                if (role.getSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                    SSBRoleOraclev10g.appendStringWithSpace(buffer, "USING");
                    SSBRoleOraclev10g.appendStringWithSpace(buffer, role.getSchema());
                    SSBRoleOraclev10g.appendStringWithSpace(buffer, '.');
                    SSBRoleOraclev10g.appendStringWithSpace(buffer, role.getPack());
                } else {
                    SSBRoleOraclev10g.appendStringWithSpace(buffer, "USING");
                    SSBRoleOraclev10g.appendStringWithSpace(buffer, role.getPack());
                }
            } else {
                buffer.append(role.getAuthType());
            }
        } else {
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "NOT");
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "IDENTIFIED");
        }
    }

    private void appendRolesAndPrivileges(StringBuffer oldbuffer, RoleOraclev10g role, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        String roles = role.getRolesNames();
        String rolesAdminOption = role.getRolesWithAdminOptionNames();
        String privileges = role.getPrivileges();
        String privilegesAdminOption = role.getPrivilegesWithAdminOption();
        if (!"".equalsIgnoreCase(roles)) {
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "GRANT");
            SSBRoleOraclev10g.appendStringWithSpace(buffer, roles);
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "TO");
            SSBRoleOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBRoleOraclev10g.appendLineFinisher(buffer, prettyPrint);
            SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(rolesAdminOption)) {
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "GRANT");
            SSBRoleOraclev10g.appendStringWithSpace(buffer, rolesAdminOption);
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "TO");
            SSBRoleOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role));
            buffer.append(" WITH ADMIN OPTION");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBRoleOraclev10g.appendLineFinisher(buffer, prettyPrint);
            SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(privileges)) {
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "GRANT");
            SSBRoleOraclev10g.appendStringWithSpace(buffer, privileges);
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "TO");
            SSBRoleOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBRoleOraclev10g.appendLineFinisher(buffer, prettyPrint);
            SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        if (!"".equalsIgnoreCase(privilegesAdminOption)) {
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "GRANT");
            SSBRoleOraclev10g.appendStringWithSpace(buffer, privilegesAdminOption);
            SSBRoleOraclev10g.appendStringWithSpace(buffer, "TO");
            SSBRoleOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(role));
            buffer.append(" WITH ADMIN OPTION");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBRoleOraclev10g.appendLineFinisher(buffer, prettyPrint);
            SSBRoleOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }
}

