/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataBaseOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UndoTablespaceOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseOraclev10g
extends AbstractSSBOracle {
    public static final String COMMENT = " -- ";
    private StorageDesignOracle storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseOraclev10g && ((DataBaseOraclev10g)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        DataBaseOraclev10g database = (DataBaseOraclev10g)object;
        this.storageDesign = (StorageDesignOracle)database.getStorageDesign();
        this.appendPrompt(buffer, database, "DATABASE");
        this.appendComment(buffer, database);
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "CREATE");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "DATABASE");
        this.appendStringWithSpace(buffer, database);
        this.appendSysPass(buffer, database, prettyPrint);
        this.appendSystemPass(buffer, database, prettyPrint);
        this.appendControlFileReuse(buffer, database);
        this.appendLogFiles(buffer, database);
        this.appendMaxLogFiles(buffer, database);
        this.appendMaxLogMembers(buffer, database);
        this.appendMaxLogHistory(buffer, database);
        this.appendMaxDataFiles(buffer, database);
        this.appendMaxInstances(buffer, database);
        this.appendArchiveLog(buffer, database);
        this.appendForceLogging(buffer, database, prettyPrint);
        this.appendCharacterSet(buffer, database);
        this.appendNationalCharacterSet(buffer, database);
        this.appendDataFiles(buffer, database);
        this.appendExtentManagement(buffer, database, prettyPrint);
        this.appendSysAuxDataFiles(buffer, database);
        this.appendTempTablespace(buffer, database, prettyPrint);
        this.appendUndoTablespace(buffer, database, prettyPrint);
        this.appendTimeZone(buffer, database, prettyPrint);
        SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateDatabase();
    }

    private void appendSysPass(StringBuffer buffer, DataBaseOraclev10g database, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(database.getPassForSYS())) {
            SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "USER");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "SYS");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "IDENTIFIED");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, database.getPassForSYS());
        }
    }

    private void appendSystemPass(StringBuffer buffer, DataBaseOraclev10g database, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(database.getPassForSYSTEM())) {
            SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "USER");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "SYSTEM");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "IDENTIFIED");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "BY");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, database.getPassForSYSTEM());
        }
    }

    private void appendControlFileReuse(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        String controlFileReuse = dataBase.getControlFileReuse();
        if (controlFileReuse.equalsIgnoreCase("YES")) {
            buffer.append(NEWLINE);
            buffer.append(COMMENT).append("    ").append("CONTROLFILE REUSE");
        }
    }

    private void appendLogFiles(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        RedoLogGroupSetOracle rlgsOracle = this.storageDesign.getRedoLogGroupSet();
        Iterator setIt = rlgsOracle.iterator();
        int count = 0;
        boolean b = false;
        while (setIt.hasNext()) {
            RedoLogGroupOracle logFile = (RedoLogGroupOracle)setIt.next();
            if (logFile.getDataBase() == null || !logFile.getDataBase().toString().equalsIgnoreCase(dataBase.toString())) continue;
            ++count;
            if (!b) {
                buffer.append(NEWLINE);
                buffer.append(COMMENT).append("    ").append("LOGFILE");
                b = true;
            } else {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, ',');
            }
            buffer.append(NEWLINE).append(COMMENT).append("    ").append("    ");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "GROUP");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, count);
            if (!"".equalsIgnoreCase(logFile.getFileName())) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, '(');
                SSBDataBaseOraclev10g.appendString(buffer, '\'');
                SSBDataBaseOraclev10g.appendString(buffer, logFile.getFileName());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, '\'');
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, ')');
            }
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "SIZE");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, logFile.getSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, logFile.getMeasureUnit());
            if (!logFile.getReuse().equalsIgnoreCase("YES")) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "REUSE");
        }
    }

    private void appendMaxLogFiles(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        int maxLogFiles = dataBase.getMaxLogFiles();
        buffer.append(NEWLINE);
        buffer.append(COMMENT).append("    ");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MAXLOGFILES");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, maxLogFiles);
    }

    private void appendMaxLogMembers(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        int maxLogMembers = dataBase.getMaxLogMembers();
        buffer.append(NEWLINE);
        buffer.append(COMMENT).append("    ");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MAXLOGMEMBERS");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, maxLogMembers);
    }

    private void appendMaxLogHistory(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        int maxLogHistory = dataBase.getMaxLogHistory();
        buffer.append(NEWLINE);
        buffer.append(COMMENT).append("    ");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MAXLOGHISTORY");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, maxLogHistory);
    }

    private void appendMaxDataFiles(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        int maxDataFiles = dataBase.getMaxDataFiles();
        buffer.append(NEWLINE);
        buffer.append(COMMENT).append("    ");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MAXDATAFILES");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, maxDataFiles);
    }

    private void appendMaxInstances(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        int maxInstances = dataBase.getMaxInstances();
        buffer.append(NEWLINE);
        buffer.append(COMMENT).append("    ");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MAXINSTANCES");
        SSBDataBaseOraclev10g.appendStringWithSpace(buffer, maxInstances);
    }

    private void appendArchiveLog(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        String archiveLog = dataBase.getArchiveLog();
        if (archiveLog != null && archiveLog.equalsIgnoreCase("YES")) {
            buffer.append(NEWLINE);
            buffer.append(COMMENT).append("    ");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "ARCHIVELOG");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            buffer.append(NEWLINE);
            buffer.append(COMMENT).append("    ");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "NOARCHIVELOG");
        }
    }

    private void appendForceLogging(StringBuffer buffer, DataBaseOraclev10g database, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(database.getForceLogging())) {
            SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "FORCE");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "LOGGING");
        }
    }

    private void appendCharacterSet(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        String characterSet = dataBase.getCharacterSet();
        if (!"".equalsIgnoreCase(characterSet)) {
            buffer.append(NEWLINE);
            buffer.append(COMMENT).append("    ").append("CHARACTER SET ").append(characterSet);
        }
    }

    private void appendNationalCharacterSet(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        String nationalCharacterSet = dataBase.getNationalCharacterSet();
        if (!"".equalsIgnoreCase(nationalCharacterSet)) {
            buffer.append(NEWLINE);
            buffer.append(COMMENT).append("    ").append("NATIONAL CHARACTER SET ").append(nationalCharacterSet);
        }
    }

    private void appendDataFiles(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        DataFileSetOracle dataFileSet = this.storageDesign.getDataFileSet();
        Iterator setIt = dataFileSet.iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            DataFileOracle dataFile = (DataFileOracle)setIt.next();
            if (dataFile.getDataBase() == null || !dataFile.getDataBase().toString().equalsIgnoreCase(dataBase.toString())) continue;
            if (!b) {
                buffer.append(NEWLINE);
                buffer.append(COMMENT).append("    ");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "DATAFILE");
                b = true;
            } else {
                buffer.append(',');
            }
            buffer.append(NEWLINE);
            buffer.append(COMMENT).append("    ").append("    ");
            SSBDataBaseOraclev10g.appendString(buffer, '\'');
            SSBDataBaseOraclev10g.appendString(buffer, dataFile.getFileName());
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, '\'');
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "SIZE");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            if (dataFile.getReuse().equalsIgnoreCase("YES")) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "NEXT");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getNextBlockSizeUnit());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    buffer.append("UNLIMITED");
                    continue;
                }
                buffer.append(dataFile.getMaxSize()).append(dataFile.getMaxSizeUnit());
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendSysAuxDataFiles(StringBuffer buffer, DataBaseOraclev10g dataBase) {
        Iterator setIt = dataBase.getSysAuxFiles().iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            DataFileOraclev10g dataFile = (DataFileOraclev10g)setIt.next();
            if (!b) {
                buffer.append(NEWLINE);
                buffer.append(COMMENT).append("    ");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "SYSAUX");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "DATAFILE");
                b = true;
            } else {
                buffer.append(',');
            }
            buffer.append(NEWLINE);
            buffer.append(COMMENT).append("    ").append("    ");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(dataFile));
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "SIZE");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            if (dataFile.getReuse().equalsIgnoreCase("YES")) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "NEXT");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getNextBlockSizeUnit());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "UNLIMITED");
                    continue;
                }
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getMaxSize());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getMaxSizeUnit());
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendDataFiles(StringBuffer buffer, UndoTablespaceOraclev10g tableSpace, boolean prettyPrint) {
        Iterator setIt = tableSpace.getDfiles().iterator();
        boolean b = false;
        while (setIt.hasNext()) {
            DataFileOracle dataFile = (DataFileOracle)setIt.next();
            if (!b) {
                SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "DATAFILE");
                b = true;
            } else {
                buffer.append(',');
            }
            SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
            buffer.append("    ");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, this.addQuotes(dataFile.getFileName(), true));
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "SIZE");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getMeasureUnit());
            if (dataFile.getReuse().equalsIgnoreCase("YES")) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "REUSE");
            }
            if ("ON".equalsIgnoreCase(dataFile.getAutoextend()) || "OFF".equalsIgnoreCase(dataFile.getAutoextend())) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getAutoextend());
                if (!dataFile.getAutoextend().equalsIgnoreCase("ON")) continue;
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "NEXT");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getNextBlockSize());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getNextBlockSizeUnit());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MAXSIZE");
                if (dataFile.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    buffer.append("UNLIMITED");
                    continue;
                }
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getMaxSize());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, dataFile.getMaxSizeUnit());
                continue;
            }
            if (!this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) continue;
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
            if (dataFile.getSize() != 0L) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "OFF");
                continue;
            }
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "ON");
        }
    }

    private void appendExtentManagement(StringBuffer buffer, DataBaseOraclev10g database, boolean prettyPrint) {
        if (database.getExtentManagement().equalsIgnoreCase("LOCAL")) {
            SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "EXTENT");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MANAGEMENT");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "LOCAL");
        }
    }

    private void appendTempTablespace(StringBuffer buffer, DataBaseOraclev10g database, boolean prettyPrint) {
        if (database.getTempTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            TemporaryTablespaceOraclev10g ts = (TemporaryTablespaceOraclev10g)database.getTempTablespace();
            SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "TEMPORARY");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            this.appendTempFile(buffer, ts, prettyPrint);
            this.appendExtent(buffer, ts, prettyPrint);
        }
    }

    private void appendTempFile(StringBuffer buffer, TemporaryTablespaceOraclev10g ts, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(ts.getFilename().trim())) {
            SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "TEMPFILE");
            SSBDataBaseOraclev10g.appendString(buffer, '\'');
            SSBDataBaseOraclev10g.appendString(buffer, ts.getFilename());
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, '\'');
            if (ts.getSize() != 0L) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "SIZE");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, ts.getSize());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, ts.getMeasureUnitSize());
            }
            if ("YES".equalsIgnoreCase(ts.getReuse())) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "REUSE");
            }
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "AUTOEXTEND");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, ts.getAutoextend());
            if (ts.getAutoextend().equalsIgnoreCase("ON")) {
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "NEXT");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, ts.getNextBlockSize());
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "K");
                SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MAXSIZE");
                if (ts.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "UNLIMITED");
                } else {
                    SSBDataBaseOraclev10g.appendStringWithSpace(buffer, ts.getMaxSize());
                    SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "K");
                }
            }
        }
    }

    private void appendExtent(StringBuffer buffer, TemporaryTablespaceOraclev10g ts, boolean prettyPrint) {
        if (ts.getUniformSize() != 0L) {
            SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "EXTENT");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "MANAGEMENT");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "LOCAL");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "UNIFORM");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "SIZE");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, ts.getUniformSize());
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, ts.getMeasureUnitUniformSize());
        }
    }

    private void appendUndoTablespace(StringBuffer buffer, DataBaseOraclev10g database, boolean prettyPrint) {
        if (database.getUndoTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            UndoTablespaceOraclev10g ts = (UndoTablespaceOraclev10g)database.getUndoTablespace();
            SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "UNDO");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            this.appendDataFiles(buffer, ts, prettyPrint);
        }
    }

    private void appendTimeZone(StringBuffer buffer, DataBaseOraclev10g database, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(database.getTimeZone())) {
            SSBDataBaseOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, COMMENT);
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "SET");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, "TIME_ZONE");
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, '=');
            SSBDataBaseOraclev10g.appendString(buffer, '\'');
            SSBDataBaseOraclev10g.appendString(buffer, database.getTimeZone());
            SSBDataBaseOraclev10g.appendStringWithSpace(buffer, '\'');
        }
    }
}

