/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBNoneTransferableFKOracle
extends AbstractSSBOracle {
    StorageDesign storageDesign;

    public SSBNoneTransferableFKOracle(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxy || object instanceof Table;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (((ModelIDObject)object).isMarkedGenerate()) {
            Table table = null;
            TableProxy tableProxy = null;
            if (object instanceof TableProxy) {
                tableProxy = (TableProxy)object;
                table = (Table)tableProxy.getObject();
                this.storageDesign = tableProxy.getStorageDesign();
            } else if (object instanceof Table) {
                table = (Table)object;
                Design design = table.getDesign();
                RDBMSSite site = table.getSelectedRDBMSSite();
                this.storageDesign = this.getStorageDesign();
                tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            }
            if (tableProxy != null && table != null && table.getDesign().getAppView().getSettings().isGenerateFKNoneTransferableTriggers()) {
                String advancedComment;
                StringBuffer buffer = new StringBuffer();
                List columns = SSBNoneTransferableFKOracle.getColumnsInOptionalFK(table);
                if (columns.size() > 0) {
                    advancedComment = "create Non Transferable FK constraint UPDATE trigger for table " + this.storageDesign.getFormatedLongNameDDL(tableProxy);
                    this.appendFKOptionalUpdateTrigger(buffer, tableProxy, columns, true);
                    this.appendBlockDefinitionToBuffer(oldbuffer, buffer, advancedComment, "/");
                    SSBNoneTransferableFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBNoneTransferableFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementCreateTrigger();
                }
                if ((columns = SSBNoneTransferableFKOracle.getColumnsInMandatoryFK(table)).size() > 0) {
                    advancedComment = "create Non Transferable FK constraint UPDATE trigger for table " + this.storageDesign.getFormatedLongNameDDL(tableProxy);
                    this.appendFKMandatoryUpdateTrigger(buffer, tableProxy, columns, true);
                    this.appendBlockDefinitionToBuffer(oldbuffer, buffer, advancedComment, "/");
                    SSBNoneTransferableFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    SSBNoneTransferableFKOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementCreateTrigger();
                }
            }
        }
    }

    private void appendFKOptionalUpdateTrigger(StringBuffer buffer, TableProxy tableProxy, List columns, boolean prettyPrint) {
        String tr_name = "FKNTO_";
        tr_name = this.storageDesign.getFormatedName(tr_name + this.getStringWithMaxLength(tableProxy.getName(), tableProxy.getMaxNameLength() - tr_name.length()));
        if (tableProxy.getUserSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            tr_name = this.storageDesign.getFormatedName(tableProxy.getUserSchema()) + '.' + tr_name;
        }
        String cols = "";
        boolean first = true;
        for (Column column : columns) {
            if (first) {
                cols = this.storageDesign.getFormatedName(column);
                first = false;
                continue;
            }
            cols = cols + ", " + this.storageDesign.getFormatedName(column);
        }
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "CREATE OR REPLACE TRIGGER " + tr_name);
        SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "BEFORE UPDATE OF " + cols);
        SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        String formattedTableName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "ON " + formattedTableName);
        SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "FOR EACH ROW");
        SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "BEGIN");
        SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        for (Column column : columns) {
            String fkName = "";
            FKIndexAssociation fk = column.getFKIndexAssociation();
            if (fk != null && !fk.isTransferable() && !fk.isMandatory()) {
                fkName = fk.getName();
            }
            SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, " IF :old." + this.storageDesign.getFormatedName(column) + " IS NOT NULL THEN");
            SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "  raise_application_error(-20225,'Non Transferable FK constraint " + fkName + " on table " + formattedTableName + " is violated');");
            SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
            SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, " END IF;");
            SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        }
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "END;");
    }

    private void appendFKMandatoryUpdateTrigger(StringBuffer buffer, TableProxy tableProxy, List columns, boolean prettyPrint) {
        String tr_name = "FKNTM_";
        tr_name = this.storageDesign.getFormatedName(tr_name + this.getStringWithMaxLength(tableProxy.getName(), tableProxy.getMaxNameLength() - tr_name.length()));
        if (tableProxy.getUserSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            tr_name = this.storageDesign.getFormatedName(tableProxy.getUserSchema()) + '.' + tr_name;
        }
        String cols = "";
        HashMap<String, FKIndexAssociation> map = new HashMap<String, FKIndexAssociation>();
        String fkName = "";
        boolean first = true;
        for (Column column : columns) {
            Object obj;
            FKIndexAssociation fk;
            if (first) {
                cols = this.storageDesign.getFormatedName(column);
                first = false;
            } else {
                cols = cols + ", " + this.storageDesign.getFormatedName(column);
            }
            if ((fk = column.getFKIndexAssociation()) == null || fk.isTransferable() || fk.isMandatory() || (obj = map.get(fk.getObjectID())) != null) continue;
            map.put(fk.getObjectID(), fk);
            if (map.size() > 1) {
                fkName = fkName + " ," + fk.getName();
                continue;
            }
            fkName = fk.getName();
        }
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "CREATE OR REPLACE TRIGGER " + tr_name);
        SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "BEFORE UPDATE OF " + cols);
        SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        String formattedTableName = this.storageDesign.getFormatedLongNameDDL(tableProxy);
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "ON " + formattedTableName);
        SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "BEGIN");
        SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "  raise_application_error(-20225,'Non Transferable FK constraint " + fkName + " on table " + formattedTableName + " is violated');");
        SSBNoneTransferableFKOracle.appendNewLine(buffer, prettyPrint, 0);
        SSBNoneTransferableFKOracle.appendStringWithSpace(buffer, "END;");
    }

    public static List getColumnsInOptionalFK(Table table) {
        ArrayList<Column> list = new ArrayList<Column>();
        FKIndexAssociation[] fkeys = table.getFKAssociations();
        for (int i = 0; i < fkeys.length; ++i) {
            FKIndexAssociation fk = fkeys[i];
            if (fk.isMandatory() || fk.isTransferable()) continue;
            for (Column column : fk.getLocalFKIndex().getElementsCollection()) {
                if (list.contains(column)) continue;
                list.add(column);
            }
        }
        return list;
    }

    public static List getColumnsInMandatoryFK(Table table) {
        ArrayList<Column> list = new ArrayList<Column>();
        FKIndexAssociation[] fkeys = table.getFKAssociations();
        for (int i = 0; i < fkeys.length; ++i) {
            FKIndexAssociation fk = fkeys[i];
            if (!fk.isMandatory() || fk.isTransferable()) continue;
            for (Column column : fk.getLocalFKIndex().getElementsCollection()) {
                if (list.contains(column)) continue;
                list.add(column);
            }
        }
        return list;
    }
}

