/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHPKOidColumns
extends ExportHandler {
    public EHPKOidColumns(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("ColumnID").append(",");
        sb.append("Num_ColumnID").append(",");
        sb.append("Table_ID").append(",");
        sb.append("Num_Table_ID").append(",");
        sb.append("Table_Name").append(",");
        sb.append("Column_Name");
        lines.add(sb.toString());
        for (RelationalDesign phDesign : this.getDesign().getRelationalDesigns()) {
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator tit = phDesign.getTableSet().iterator();
            while (tit.hasNext()) {
                Table table = (Table)tit.next();
                for (ContainedObject column : table.getOidPKColumns()) {
                    sb = new StringBuffer();
                    sb.append(column.getObjectID()).append(",");
                    sb.append(column.getNumID()).append(",");
                    sb.append(table.getObjectID()).append(",");
                    sb.append(table.getNumID()).append(",");
                    sb.append(this.replaceAndQuoteString(table.getName())).append(",");
                    sb.append(this.replaceAndQuoteString(column.getName())).append(",");
                    lines.add(sb.toString());
                }
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_PK_OID_Columns.csv";
    }
}

