/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.constraint.AVT;

public class EHDomainValueRanges
extends ExportHandler {
    public EHDomainValueRanges(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Domain_ID").append(",");
        sb.append("Num_Domain_ID").append(",");
        sb.append("Sequence").append(",");
        sb.append("Begin_Value").append(",");
        sb.append("End_Value").append(",");
        sb.append("Short_Description").append(",");
        sb.append("Domain_Name");
        lines.add(sb.toString());
        Iterator it = this.getDesign().getDomainSet().iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            Iterator avtit = domain.getAVTs().iterator();
            int seq = 0;
            while (avtit.hasNext()) {
                ++seq;
                AVT avt = (AVT)avtit.next();
                sb = new StringBuffer();
                sb.append(domain.getObjectID()).append(",");
                sb.append(domain.getNumID()).append(",");
                sb.append(seq).append(",");
                sb.append(this.quotedIfHasSpatias(avt.getBeginValue())).append(",");
                sb.append(this.quotedIfHasSpatias(avt.getEndValue())).append(",");
                sb.append(this.replaceAndQuoteString(avt.getDescription())).append(",");
                sb.append(this.replaceAndQuoteString(domain.getName())).append(",");
                lines.add(sb.toString());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Domain_Value_Ranges.csv";
    }
}

