/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockAttemptResult;
import com.sleepycat.je.txn.LockConflict;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.LockUpgrade;
import com.sleepycat.je.txn.Locker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockImpl
implements Lock {
    private static final int REMOVE_LOCKINFO_OVERHEAD = 0 - MemoryBudget.LOCKINFO_OVERHEAD;
    private LockInfo firstOwner;
    private Set<LockInfo> ownerSet;
    private LockInfo firstWaiter;
    private List<LockInfo> waiterList;

    public LockImpl() {
    }

    LockImpl(LockInfo firstOwner) {
        this.firstOwner = firstOwner;
    }

    private void addWaiterToEndOfList(LockInfo waiter, MemoryBudget mb, int lockTableIndex) {
        if (this.waiterList == null) {
            if (this.firstWaiter == null) {
                this.firstWaiter = waiter;
            } else {
                this.waiterList = new ArrayList<LockInfo>();
                this.waiterList.add(waiter);
            }
        } else {
            this.waiterList.add(waiter);
        }
        mb.updateLockMemoryUsage(MemoryBudget.LOCKINFO_OVERHEAD, lockTableIndex);
    }

    private void addWaiterToHeadOfList(LockInfo waiter, MemoryBudget mb, int lockTableIndex) {
        if (this.firstWaiter != null) {
            if (this.waiterList == null) {
                this.waiterList = new ArrayList<LockInfo>();
            }
            this.waiterList.add(0, this.firstWaiter);
        }
        this.firstWaiter = waiter;
        mb.updateLockMemoryUsage(MemoryBudget.LOCKINFO_OVERHEAD, lockTableIndex);
    }

    @Override
    public List<LockInfo> getWaitersListClone() {
        ArrayList<LockInfo> dumpWaiters = new ArrayList<LockInfo>();
        if (this.firstWaiter != null) {
            dumpWaiters.add(this.firstWaiter);
        }
        if (this.waiterList != null) {
            dumpWaiters.addAll(this.waiterList);
        }
        return dumpWaiters;
    }

    @Override
    public void flushWaiter(Locker locker, MemoryBudget mb, int lockTableIndex) {
        if (this.firstWaiter != null && this.firstWaiter.getLocker() == locker) {
            this.firstWaiter = null;
            mb.updateLockMemoryUsage(REMOVE_LOCKINFO_OVERHEAD, lockTableIndex);
        } else if (this.waiterList != null) {
            Iterator<LockInfo> iter = this.waiterList.iterator();
            while (iter.hasNext()) {
                LockInfo info = iter.next();
                if (info.getLocker() != locker) continue;
                iter.remove();
                mb.updateLockMemoryUsage(REMOVE_LOCKINFO_OVERHEAD, lockTableIndex);
                return;
            }
        }
    }

    private void addOwner(LockInfo newLock, MemoryBudget mb, int lockTableIndex) {
        if (this.firstOwner == null) {
            this.firstOwner = newLock;
        } else {
            if (this.ownerSet == null) {
                this.ownerSet = new HashSet<LockInfo>();
            }
            this.ownerSet.add(newLock);
        }
        mb.updateLockMemoryUsage(MemoryBudget.LOCKINFO_OVERHEAD, lockTableIndex);
    }

    @Override
    public Set<LockInfo> getOwnersClone() {
        HashSet<LockInfo> owners = this.ownerSet != null ? new HashSet<LockInfo>(this.ownerSet) : new HashSet();
        if (this.firstOwner != null) {
            owners.add(this.firstOwner);
        }
        return owners;
    }

    private boolean flushOwner(LockInfo oldOwner, MemoryBudget mb, int lockTableIndex) {
        boolean removed = false;
        if (oldOwner != null) {
            if (this.firstOwner == oldOwner) {
                this.firstOwner = null;
                removed = true;
            } else if (this.ownerSet != null) {
                removed = this.ownerSet.remove(oldOwner);
            }
        }
        if (removed) {
            mb.updateLockMemoryUsage(REMOVE_LOCKINFO_OVERHEAD, lockTableIndex);
        }
        return removed;
    }

    private LockInfo flushOwner(Locker locker, MemoryBudget mb, int lockTableIndex) {
        LockInfo flushedInfo = null;
        if (this.firstOwner != null && this.firstOwner.getLocker() == locker) {
            flushedInfo = this.firstOwner;
            this.firstOwner = null;
        } else if (this.ownerSet != null) {
            Iterator<LockInfo> iter = this.ownerSet.iterator();
            while (iter.hasNext()) {
                LockInfo o = iter.next();
                if (o.getLocker() != locker) continue;
                iter.remove();
                flushedInfo = o;
            }
        }
        if (flushedInfo != null) {
            mb.updateLockMemoryUsage(REMOVE_LOCKINFO_OVERHEAD, lockTableIndex);
        }
        return flushedInfo;
    }

    private LockInfo getOwnerLockInfo(Locker locker) {
        if (this.firstOwner != null && this.firstOwner.getLocker() == locker) {
            return this.firstOwner;
        }
        if (this.ownerSet != null) {
            for (LockInfo o : this.ownerSet) {
                if (o.getLocker() != locker) continue;
                return o;
            }
        }
        return null;
    }

    @Override
    public boolean isOwner(Locker locker, LockType lockType) {
        LockInfo o = this.getOwnerLockInfo(locker);
        if (o != null) {
            LockType ownedLockType = o.getLockType();
            if (lockType == ownedLockType) {
                return true;
            }
            LockUpgrade upgrade = ownedLockType.getUpgrade(lockType);
            if (!upgrade.getPromotion()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOwnedWriteLock(Locker locker) {
        LockInfo o = this.getOwnerLockInfo(locker);
        return o != null && o.getLockType().isWriteLock();
    }

    @Override
    public boolean isWaiter(Locker locker) {
        if (this.firstWaiter != null && this.firstWaiter.getLocker() == locker) {
            return true;
        }
        if (this.waiterList != null) {
            for (LockInfo info : this.waiterList) {
                if (info.getLocker() != locker) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int nWaiters() {
        int count = 0;
        if (this.firstWaiter != null) {
            ++count;
        }
        if (this.waiterList != null) {
            count += this.waiterList.size();
        }
        return count;
    }

    @Override
    public int nOwners() {
        int count = 0;
        if (this.firstOwner != null) {
            ++count;
        }
        if (this.ownerSet != null) {
            count += this.ownerSet.size();
        }
        return count;
    }

    @Override
    public LockAttemptResult lock(LockType requestType, Locker locker, boolean nonBlockingRequest, MemoryBudget mb, int lockTableIndex) {
        assert (this.validateRequest(locker));
        LockInfo newLock = new LockInfo(locker, requestType);
        LockGrantType grant = this.tryLock(newLock, this.nWaiters() == 0, mb, lockTableIndex);
        if (grant == LockGrantType.WAIT_NEW || grant == LockGrantType.WAIT_PROMOTION || grant == LockGrantType.WAIT_RESTART) {
            if (requestType.getCausesRestart() && grant != LockGrantType.WAIT_RESTART) {
                LockInfo waiter = null;
                Iterator<LockInfo> iter = null;
                if (this.waiterList != null) {
                    iter = this.waiterList.iterator();
                }
                if (this.firstWaiter != null) {
                    waiter = this.firstWaiter;
                } else if (iter != null && iter.hasNext()) {
                    waiter = iter.next();
                }
                while (waiter != null) {
                    LockConflict conflict;
                    Locker waiterLocker = waiter.getLocker();
                    LockType waiterType = waiter.getLockType();
                    if (waiterType != LockType.RESTART && locker != waiterLocker && !locker.sharesLocksWith(waiterLocker) && (conflict = waiterType.getConflict(requestType)).getRestart()) {
                        grant = LockGrantType.WAIT_RESTART;
                        break;
                    }
                    if (iter != null && iter.hasNext()) {
                        waiter = iter.next();
                        continue;
                    }
                    waiter = null;
                }
            }
            if (nonBlockingRequest) {
                grant = LockGrantType.DENIED;
            } else if (grant == LockGrantType.WAIT_PROMOTION) {
                this.addWaiterToHeadOfList(newLock, mb, lockTableIndex);
            } else {
                assert (grant == LockGrantType.WAIT_NEW || grant == LockGrantType.WAIT_RESTART);
                if (grant == LockGrantType.WAIT_RESTART) {
                    newLock.setLockType(LockType.RESTART);
                }
                this.addWaiterToEndOfList(newLock, mb, lockTableIndex);
            }
        }
        return new LockAttemptResult(this, grant, false);
    }

    @Override
    public Set<Locker> release(Locker locker, MemoryBudget mb, int lockTableIndex) {
        LockInfo removedLock = this.flushOwner(locker, mb, lockTableIndex);
        if (removedLock == null) {
            return null;
        }
        Set<Locker> lockersToNotify = Collections.emptySet();
        if (this.nWaiters() == 0) {
            return lockersToNotify;
        }
        LockInfo waiter = null;
        Iterator<LockInfo> iter = null;
        boolean isFirstWaiter = false;
        if (this.waiterList != null) {
            iter = this.waiterList.iterator();
        }
        if (this.firstWaiter != null) {
            waiter = this.firstWaiter;
            isFirstWaiter = true;
        } else if (iter != null && iter.hasNext()) {
            waiter = iter.next();
        }
        while (waiter != null) {
            LockType waiterType = waiter.getLockType();
            Locker waiterLocker = waiter.getLocker();
            LockGrantType grant = waiterType == LockType.RESTART ? (this.rangeInsertConflict(waiterLocker) ? LockGrantType.WAIT_NEW : LockGrantType.NEW) : this.tryLock(waiter, true, mb, lockTableIndex);
            if (grant == LockGrantType.NEW || grant == LockGrantType.EXISTING || grant == LockGrantType.PROMOTION) {
                if (isFirstWaiter) {
                    this.firstWaiter = null;
                } else {
                    iter.remove();
                }
                if (lockersToNotify == Collections.EMPTY_SET) {
                    lockersToNotify = new HashSet<Locker>();
                }
            } else {
                assert (grant == LockGrantType.WAIT_NEW || grant == LockGrantType.WAIT_PROMOTION || grant == LockGrantType.WAIT_RESTART);
                break;
            }
            lockersToNotify.add(waiterLocker);
            mb.updateLockMemoryUsage(REMOVE_LOCKINFO_OVERHEAD, lockTableIndex);
            if (iter != null && iter.hasNext()) {
                waiter = iter.next();
                isFirstWaiter = false;
                continue;
            }
            waiter = null;
        }
        return lockersToNotify;
    }

    private LockGrantType tryLock(LockInfo newLock, boolean firstWaiterInLine, MemoryBudget mb, int lockTableIndex) {
        if (this.nOwners() == 0) {
            this.addOwner(newLock, mb, lockTableIndex);
            return LockGrantType.NEW;
        }
        Locker locker = newLock.getLocker();
        LockType requestType = newLock.getLockType();
        LockUpgrade upgrade = null;
        LockInfo lockToUpgrade = null;
        boolean ownerExists = false;
        boolean ownerConflicts = false;
        LockInfo owner = null;
        Iterator<LockInfo> iter = null;
        if (this.ownerSet != null) {
            iter = this.ownerSet.iterator();
        }
        if (this.firstOwner != null) {
            owner = this.firstOwner;
        } else if (iter != null && iter.hasNext()) {
            owner = iter.next();
        }
        while (owner != null) {
            Locker ownerLocker = owner.getLocker();
            LockType ownerType = owner.getLockType();
            if (locker == ownerLocker) {
                assert (upgrade == null);
                upgrade = ownerType.getUpgrade(requestType);
                if (upgrade.getUpgrade() == null) {
                    return LockGrantType.EXISTING;
                }
                lockToUpgrade = owner;
            } else if (!locker.sharesLocksWith(ownerLocker)) {
                LockConflict conflict = ownerType.getConflict(requestType);
                if (conflict.getRestart()) {
                    return LockGrantType.WAIT_RESTART;
                }
                if (!conflict.getAllowed()) {
                    ownerConflicts = true;
                }
                ownerExists = true;
            }
            if (iter != null && iter.hasNext()) {
                owner = iter.next();
                continue;
            }
            owner = null;
        }
        if (upgrade != null) {
            LockType upgradeType = upgrade.getUpgrade();
            assert (upgradeType != null);
            if (!ownerConflicts) {
                lockToUpgrade.setLockType(upgradeType);
                return upgrade.getPromotion() ? LockGrantType.PROMOTION : LockGrantType.EXISTING;
            }
            return LockGrantType.WAIT_PROMOTION;
        }
        if (!(ownerConflicts || ownerExists && !firstWaiterInLine)) {
            this.addOwner(newLock, mb, lockTableIndex);
            return LockGrantType.NEW;
        }
        return LockGrantType.WAIT_NEW;
    }

    private boolean rangeInsertConflict(Locker waiterLocker) {
        LockInfo owner = null;
        Iterator<LockInfo> iter = null;
        if (this.ownerSet != null) {
            iter = this.ownerSet.iterator();
        }
        if (this.firstOwner != null) {
            owner = this.firstOwner;
        } else if (iter != null && iter.hasNext()) {
            owner = iter.next();
        }
        while (owner != null) {
            Locker ownerLocker = owner.getLocker();
            if (ownerLocker != waiterLocker && !ownerLocker.sharesLocksWith(waiterLocker) && owner.getLockType() == LockType.RANGE_INSERT) {
                return true;
            }
            if (iter != null && iter.hasNext()) {
                owner = iter.next();
                continue;
            }
            owner = null;
        }
        return false;
    }

    @Override
    public void demote(Locker locker) {
        LockType type;
        LockInfo owner = this.getOwnerLockInfo(locker);
        if (owner != null && (type = owner.getLockType()).isWriteLock()) {
            owner.setLockType(type == LockType.RANGE_WRITE ? LockType.RANGE_READ : LockType.READ);
        }
    }

    @Override
    public Lock transfer(Long nodeId, Locker currentLocker, Locker destLocker, MemoryBudget mb, int lockTableIndex) throws DatabaseException {
        Iterator<LockInfo> iter;
        int numRemovedLockInfos = 0;
        if (this.firstOwner != null) {
            if (this.firstOwner.getLocker() == destLocker) {
                this.firstOwner = null;
                ++numRemovedLockInfos;
            } else if (this.firstOwner.getLocker() == currentLocker) {
                this.setNewLocker(nodeId, this.firstOwner, destLocker);
            }
        }
        if (this.ownerSet != null) {
            iter = this.ownerSet.iterator();
            while (iter.hasNext()) {
                LockInfo owner = iter.next();
                if (owner.getLocker() == destLocker) {
                    iter.remove();
                    ++numRemovedLockInfos;
                    continue;
                }
                if (owner.getLocker() != currentLocker) continue;
                this.setNewLocker(nodeId, owner, destLocker);
            }
        }
        if (this.firstWaiter != null && this.firstWaiter.getLocker() == destLocker) {
            this.firstWaiter = null;
            ++numRemovedLockInfos;
        }
        if (this.waiterList != null) {
            iter = this.waiterList.iterator();
            while (iter.hasNext()) {
                LockInfo info = iter.next();
                if (info.getLocker() != destLocker) continue;
                iter.remove();
                ++numRemovedLockInfos;
            }
        }
        mb.updateLockMemoryUsage(0 - numRemovedLockInfos * MemoryBudget.LOCKINFO_OVERHEAD, lockTableIndex);
        return this;
    }

    private void setNewLocker(Long nodeId, LockInfo owner, Locker destLocker) throws DatabaseException {
        owner.setLocker(destLocker);
        destLocker.addLock(nodeId, owner.getLockType(), LockGrantType.NEW);
    }

    @Override
    public Lock transferMultiple(Long nodeId, Locker currentLocker, Locker[] destLockers, MemoryBudget mb, int lockTableIndex) throws DatabaseException {
        int i;
        LockInfo o;
        int i2;
        LockInfo oldOwner = null;
        if (destLockers.length == 1) {
            return this.transfer(nodeId, currentLocker, destLockers[0], mb, lockTableIndex);
        }
        if (this.firstOwner != null) {
            for (i2 = 0; i2 < destLockers.length; ++i2) {
                if (this.firstOwner.getLocker() != destLockers[i2]) continue;
                this.firstOwner = null;
                break;
            }
        }
        if (this.ownerSet != null) {
            Iterator<LockInfo> ownersIter = this.ownerSet.iterator();
            block1: while (ownersIter.hasNext()) {
                o = ownersIter.next();
                for (i = 0; i < destLockers.length; ++i) {
                    if (o.getLocker() != destLockers[i]) continue;
                    ownersIter.remove();
                    continue block1;
                }
            }
        }
        if (this.firstOwner != null) {
            oldOwner = this.cloneLockInfo(nodeId, this.firstOwner, currentLocker, destLockers, mb, lockTableIndex);
        }
        if (this.ownerSet != null && oldOwner == null) {
            Iterator<LockInfo> ownersIter = this.ownerSet.iterator();
            while (ownersIter.hasNext() && (oldOwner = this.cloneLockInfo(nodeId, o = ownersIter.next(), currentLocker, destLockers, mb, lockTableIndex)) == null) {
            }
        }
        if (this.firstWaiter != null) {
            for (i2 = 0; i2 < destLockers.length; ++i2) {
                if (this.firstWaiter.getLocker() != destLockers[i2]) continue;
                this.firstWaiter = null;
                break;
            }
        }
        if (this.waiterList != null) {
            Iterator<LockInfo> iter = this.waiterList.iterator();
            block5: while (iter.hasNext()) {
                o = iter.next();
                for (i = 0; i < destLockers.length; ++i) {
                    if (o.getLocker() != destLockers[i]) continue;
                    iter.remove();
                    continue block5;
                }
            }
        }
        boolean removed = this.flushOwner(oldOwner, mb, lockTableIndex);
        assert (removed);
        return this;
    }

    private LockInfo cloneLockInfo(Long nodeId, LockInfo oldOwner, Locker currentLocker, Locker[] destLockers, MemoryBudget mb, int lockTableIndex) throws DatabaseException {
        if (oldOwner.getLocker() == currentLocker) {
            try {
                LockType lockType = oldOwner.getLockType();
                for (int i = 0; i < destLockers.length; ++i) {
                    LockInfo clonedLockInfo = (LockInfo)oldOwner.clone();
                    clonedLockInfo.setLocker(destLockers[i]);
                    destLockers[i].addLock(nodeId, lockType, LockGrantType.NEW);
                    this.addOwner(clonedLockInfo, mb, lockTableIndex);
                }
                return oldOwner;
            }
            catch (CloneNotSupportedException e) {
                throw new DatabaseException(e);
            }
        }
        return null;
    }

    @Override
    public Locker getWriteOwnerLocker() {
        LockInfo owner = null;
        Iterator<LockInfo> iter = null;
        if (this.ownerSet != null) {
            iter = this.ownerSet.iterator();
        }
        if (this.firstOwner != null) {
            owner = this.firstOwner;
        } else if (iter != null && iter.hasNext()) {
            owner = iter.next();
        }
        while (owner != null) {
            if (owner.getLockType().isWriteLock()) {
                return owner.getLocker();
            }
            if (iter != null && iter.hasNext()) {
                owner = iter.next();
                continue;
            }
            owner = null;
        }
        return null;
    }

    private boolean validateRequest(Locker locker) {
        if (this.firstWaiter != null && this.firstWaiter.getLocker() == locker) assert (false) : "locker " + locker + " is already on waiters list.";
        if (this.waiterList != null) {
            for (LockInfo o : this.waiterList) {
                if (o.getLocker() == locker) assert (false) : "locker " + locker + " is already on waiters list.";
            }
        }
        return true;
    }

    @Override
    public boolean isThin() {
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" LockAddr:").append(System.identityHashCode(this));
        sb.append(" Owners:");
        if (this.nOwners() == 0) {
            sb.append(" (none)");
        } else {
            if (this.firstOwner != null) {
                sb.append(this.firstOwner);
            }
            if (this.ownerSet != null) {
                for (LockInfo info : this.ownerSet) {
                    sb.append(info);
                }
            }
        }
        sb.append(" Waiters:");
        if (this.nWaiters() == 0) {
            sb.append(" (none)");
        } else {
            sb.append(this.getWaitersListClone());
        }
        return sb.toString();
    }
}

