/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INLogContext;
import com.sleepycat.je.tree.INLogItem;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.Locker;
import java.nio.ByteBuffer;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DIN
extends IN {
    private static final String BEGIN_TAG = "<din>";
    private static final String END_TAG = "</din>";
    private byte[] dupKey;
    private ChildReference dupCountLNRef;

    public DIN() {
        this.dupCountLNRef = new ChildReference();
        this.init(null, Key.EMPTY_KEY, 0, 0);
    }

    public DIN(DatabaseImpl db, byte[] identifierKey, int capacity, byte[] dupKey, ChildReference dupCountLNRef, int level) {
        super(db, identifierKey, capacity, level);
        this.dupKey = dupKey;
        this.dupCountLNRef = dupCountLNRef;
        this.initMemorySize();
    }

    @Override
    protected int generateLevel(DatabaseId dbId, int newLevel) {
        return newLevel;
    }

    @Override
    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new DIN(this.getDatabase(), identifierKey, maxEntries, this.dupKey, this.dupCountLNRef, level);
    }

    @Override
    boolean isAlwaysLatchedExclusively() {
        return true;
    }

    @Override
    public byte[] getDupKey() {
        return this.dupKey;
    }

    @Override
    public byte[] getChildKey(IN child) throws DatabaseException {
        return child.getIdentifierKey();
    }

    @Override
    public byte[] selectKey(byte[] mainTreeKey, byte[] dupTreeKey) {
        return dupTreeKey;
    }

    @Override
    public byte[] getDupTreeKey() {
        return this.getIdentifierKey();
    }

    @Override
    public byte[] getMainTreeKey() {
        return this.dupKey;
    }

    public ChildReference getDupCountLNRef() {
        return this.dupCountLNRef;
    }

    public DupCountLN getDupCountLN() throws DatabaseException {
        return (DupCountLN)this.dupCountLNRef.fetchTarget(this.getDatabase(), this);
    }

    void setDupCountLN(ChildReference dupCountLNRef) {
        this.updateMemorySize(this.dupCountLNRef, dupCountLNRef);
        this.dupCountLNRef = dupCountLNRef;
    }

    public void updateDupCountLN(Node target) {
        long oldSize = this.getEntryInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        this.dupCountLNRef.setTarget(target);
        long newSize = this.getEntryInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        this.updateMemorySize(oldSize, newSize);
    }

    public void updateDupCountLNRefAndNullTarget(long newLsn) {
        this.setDirty(true);
        long oldSize = this.getEntryInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        this.dupCountLNRef.setTarget(null);
        if (this.notOverwritingDeferredWriteEntry(newLsn)) {
            this.dupCountLNRef.setLsn(newLsn);
        }
        long newSize = this.getEntryInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        this.updateMemorySize(oldSize, newSize);
    }

    public void updateDupCountLNRef(long newLsn) {
        this.setDirty(true);
        if (this.notOverwritingDeferredWriteEntry(newLsn)) {
            this.dupCountLNRef.setLsn(newLsn);
        }
    }

    @Override
    public boolean containsDuplicates() {
        return true;
    }

    @Override
    public boolean isDbRoot() {
        return false;
    }

    @Override
    public final Comparator<byte[]> getKeyComparator() {
        return this.getDatabase().getDuplicateComparator();
    }

    public void incrementDuplicateCount(LockResult lockResult, byte[] key, Locker locker, boolean increment) throws DatabaseException {
        long oldLsn = this.dupCountLNRef.getLsn();
        lockResult.setAbortLsn(oldLsn, this.dupCountLNRef.isKnownDeleted());
        DupCountLN dupCountLN = this.getDupCountLN();
        if (increment) {
            dupCountLN.incDupCount();
        } else {
            dupCountLN.decDupCount();
            assert (dupCountLN.getDupCount() >= 0);
        }
        DatabaseImpl db = this.getDatabase();
        long newCountLSN = dupCountLN.optionalLog(db.getDbEnvironment(), db, key, oldLsn, locker, ReplicationContext.NO_REPLICATE);
        this.updateDupCountLNRef(newCountLSN);
    }

    @Override
    protected long computeMemorySize() {
        long size = super.computeMemorySize();
        if (this.dupCountLNRef != null) {
            size += this.getEntryInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        }
        return size;
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        return (long)MemoryBudget.DIN_FIXED_OVERHEAD + IN.computeArraysOverhead(configManager);
    }

    @Override
    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getDINOverhead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean matchLNByNodeId(TreeLocation location, long nodeId, CacheMode cacheMode) throws DatabaseException {
        this.latch();
        try {
            for (int i = 0; i < this.getNEntries(); ++i) {
                boolean ret;
                Node n = this.fetchTarget(i);
                if (n == null || !(ret = n.matchLNByNodeId(location, nodeId, cacheMode))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseLatch();
        }
    }

    @Override
    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processDIN(this, this.getNodeId(), this.getLevel());
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_DIN;
    }

    @Override
    public void beforeLog(LogManager logManager, INLogItem item, INLogContext context) throws DatabaseException {
        if (this.dupCountLNRef != null) {
            EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
            DupCountLN dupCntLN = (DupCountLN)this.dupCountLNRef.getTarget();
            if (dupCntLN != null && dupCntLN.isDirty()) {
                long newLsn = dupCntLN.log(envImpl, this.getDatabase(), this.dupKey, this.dupCountLNRef.getLsn(), null, context.backgroundIO, ReplicationContext.NO_REPLICATE);
                this.updateDupCountLNRef(newLsn);
            } else {
                envImpl.getCleaner().lazyMigrateDupCountLN(this, this.dupCountLNRef, context.proactiveMigration);
            }
        }
        super.beforeLog(logManager, item, context);
    }

    @Override
    public int getLogSize() {
        int size = super.getLogSize();
        size += LogUtils.getByteArrayLogSize(this.dupKey);
        ++size;
        if (this.dupCountLNRef != null) {
            size += this.dupCountLNRef.getLogSize();
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        LogUtils.writeByteArray(logBuffer, this.dupKey);
        boolean dupCountLNRefExists = this.dupCountLNRef != null;
        byte booleans = (byte)(dupCountLNRefExists ? 1 : 0);
        logBuffer.put(booleans);
        if (dupCountLNRefExists) {
            this.dupCountLNRef.writeToLog(logBuffer);
        }
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        boolean unpacked = entryVersion < 6;
        super.readFromLog(itemBuffer, entryVersion);
        this.dupKey = LogUtils.readByteArray(itemBuffer, unpacked);
        boolean dupCountLNRefExists = false;
        byte booleans = itemBuffer.get();
        boolean bl = dupCountLNRefExists = (booleans & 1) != 0;
        if (dupCountLNRefExists) {
            this.dupCountLNRef.readFromLog(itemBuffer, entryVersion);
        } else {
            this.dupCountLNRef = null;
        }
    }

    @Override
    protected void dumpLogAdditional(StringBuffer sb) {
        super.dumpLogAdditional(sb);
        sb.append(Key.dumpString(this.dupKey, 0));
        if (this.dupCountLNRef != null) {
            this.dupCountLNRef.dumpLog(sb, true);
        }
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dupkey>");
        sb.append(this.dupKey == null ? "" : Key.dumpString(this.dupKey, 0));
        sb.append("</dupkey>");
        sb.append('\n');
        if (this.dupCountLNRef == null) {
            sb.append(TreeUtils.indent(nSpaces + 2));
            sb.append("<dupCountLN/>");
        } else {
            sb.append(this.dupCountLNRef.dumpString(nSpaces + 4, true));
        }
        sb.append('\n');
        sb.append(super.dumpString(nSpaces, false));
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.dumpString(0, true);
    }

    @Override
    public String shortClassName() {
        return "DIN";
    }
}

