/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import javax.swing.tree.TreePath;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerMonitorsWindowOptions;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.MonitorDataItem;
import oracle.jdevimpl.runner.debug.MonitorsController;
import oracle.jdevimpl.runner.debug.MonitorsThreadsPanel;
import oracle.jdevimpl.runner.debug.MonitorsWindow;
import oracle.jdevimpl.runner.debug.MonitorsWindowSettings;
import oracle.jdevimpl.runner.debug.MultiViewPanel;
import oracle.jdevimpl.runner.debug.VersionedDataItem;

final class MonitorsPanel
extends MultiViewPanel {
    private MonitorsThreadsPanel owningThreadPanel;
    private MonitorsThreadsPanel waitingThreadsPanel;
    private MonitorsThreadsPanel blockedThreadsPanel;
    private DebuggerMonitorsWindowOptions windowOptions;

    MonitorsPanel(MonitorsWindow monitorsWindow, MonitorsThreadsPanel owningThreadPanel, MonitorsThreadsPanel waitingThreadsPanel, MonitorsThreadsPanel blockedThreadsPanel, MonitorsWindowSettings monitorsWindowSettings) {
        super(monitorsWindow, monitorsWindowSettings.getDataPanelSettings());
        this.selectFirstRowIfNoPreviousSelection = true;
        this.owningThreadPanel = owningThreadPanel;
        this.waitingThreadsPanel = waitingThreadsPanel;
        this.blockedThreadsPanel = blockedThreadsPanel;
    }

    protected void setNewVm(DebugVirtualMachine newVm, DebuggerMonitorsWindowOptions options) {
        if (options == null) {
            return;
        }
        this.windowOptions = options;
        super.setNewVm(newVm, this.windowOptions.getMainWindowOptions());
        this.owningThreadPanel.setNewVm(newVm, this.windowOptions.getOwningThreadPanelOptions());
        this.waitingThreadsPanel.setNewVm(newVm, this.windowOptions.getWaitingThreadsPanelOptions());
        this.blockedThreadsPanel.setNewVm(newVm, this.windowOptions.getBlockedThreadsPanelOptions());
    }

    @Override
    void selectionChanged() {
        super.selectionChanged();
        this.updateOtherPanels();
    }

    @Override
    public void clearData() {
        super.clearData();
        this.updateOtherPanels();
    }

    @Override
    void processFinished(DebuggingProcess debuggingProcess) {
        super.processFinished(debuggingProcess);
        this.owningThreadPanel.processFinished(debuggingProcess);
        this.waitingThreadsPanel.processFinished(debuggingProcess);
        this.blockedThreadsPanel.processFinished(debuggingProcess);
    }

    private DebugMonitorInfo getSelectedMonitorInfo() {
        TreePath treePath = this.getDataTable().getSelectionPath();
        if (treePath != null) {
            Object[] path = treePath.getPath();
            for (int i = path.length - 1; i >= 0; --i) {
                Object info;
                Object pathObject = path[i];
                MonitorDataItem monitorDataItem = null;
                if (pathObject instanceof MonitorDataItem) {
                    monitorDataItem = (MonitorDataItem)pathObject;
                } else if (pathObject instanceof VersionedDataItem) {
                    monitorDataItem = ((VersionedDataItem)pathObject).getMonitorDataItem();
                }
                if (monitorDataItem == null || !((info = monitorDataItem.getInfo()) instanceof DebugMonitorInfo)) continue;
                return (DebugMonitorInfo)info;
            }
        }
        return null;
    }

    private void updateOtherPanels() {
        if (this.getDataTable() != null && this.getDataTable().getTable().isEnabled()) {
            DebugVirtualMachine vm = this.getController().getVm();
            if (this.getDebuggingProcess() != null && vm != null) {
                DebugMonitorInfo monitor = this.getSelectedMonitorInfo();
                if (monitor != null) {
                    try {
                        this.owningThreadPanel.setThread(monitor.getOwnerThread());
                        this.waitingThreadsPanel.setThreads(monitor.listWaitingThreads());
                        this.blockedThreadsPanel.setThreads(monitor.listBlockedThreads());
                    }
                    catch (DataExpiredException dataExpiredException) {}
                } else {
                    this.owningThreadPanel.setThreads(null);
                    this.waitingThreadsPanel.setThreads(null);
                    this.blockedThreadsPanel.setThreads(null);
                }
                this.owningThreadPanel.updateThreads(this.getDebuggingProcess(), vm, null, this.windowOptions == null ? null : this.windowOptions.getOwningThreadPanelOptions());
                this.waitingThreadsPanel.updateThreads(this.getDebuggingProcess(), vm, null, this.windowOptions == null ? null : this.windowOptions.getWaitingThreadsPanelOptions());
                this.blockedThreadsPanel.updateThreads(this.getDebuggingProcess(), vm, null, this.windowOptions == null ? null : this.windowOptions.getBlockedThreadsPanelOptions());
            } else {
                this.owningThreadPanel.updateThreads(null, null, null, this.windowOptions == null ? null : this.windowOptions.getOwningThreadPanelOptions());
                this.waitingThreadsPanel.updateThreads(null, null, null, this.windowOptions == null ? null : this.windowOptions.getWaitingThreadsPanelOptions());
                this.blockedThreadsPanel.updateThreads(null, null, null, this.windowOptions == null ? null : this.windowOptions.getBlockedThreadsPanelOptions());
            }
        } else {
            this.owningThreadPanel.clearThreads();
            this.waitingThreadsPanel.clearThreads();
            this.blockedThreadsPanel.clearThreads();
        }
    }

    @Override
    protected DataController createController(DataPanelSettings dataPanelSettings) {
        return new MonitorsController(dataPanelSettings, this);
    }

    @Override
    String getWindowId() {
        return "Debugger.MonitorsWindow";
    }

    @Override
    public DebuggerWindowOptions.WindowId getWindowIdEnum() {
        return DebuggerWindowOptions.WindowId.MonitorsWindow;
    }
}

