/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.List;
import oracle.javatools.editor.TextRange;
import oracle.javatools.parser.java.v2.model.SourceElement;

public class MethodRange
implements Comparable {
    private String mi_text;
    private int mi_startOffset;
    private int mi_endOffset;
    private int mi_hash;
    private int mi_nameStartOffset;
    private int mi_nameEndOffset;
    private String mi_methodName;
    private TextRange textRange;
    private List<SourceElement> ancestorNodes;
    private boolean visited = false;
    private int bytecodeOffset;

    public MethodRange(String text, int hashCode, int startOffset, int endOffset, String methodName, int nameStartOffset, int nameEndOffset) {
        this.mi_text = text;
        this.mi_hash = hashCode;
        this.mi_startOffset = startOffset;
        this.mi_endOffset = endOffset;
        this.mi_methodName = methodName;
        this.mi_nameStartOffset = nameStartOffset;
        this.mi_nameEndOffset = nameEndOffset;
    }

    void addTextRange(TextRange range) {
        this.textRange = range;
    }

    int getMethodInvocationStart() {
        return this.mi_startOffset;
    }

    int getMethodInvocationEnd() {
        return this.mi_endOffset;
    }

    boolean matchesTextRange(TextRange r) {
        return this.textRange == r;
    }

    String getMethodName() {
        return this.mi_methodName;
    }

    int getMethodNameStartOffset() {
        return this.mi_nameStartOffset;
    }

    int getMethodNameEndOffset() {
        return this.mi_nameEndOffset;
    }

    public void markVisited() {
        this.visited = true;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setBytecodeOffset(int offset) {
        this.bytecodeOffset = offset;
    }

    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    public String toString() {
        return this.mi_text + " full range:" + this.mi_startOffset + "-" + this.mi_endOffset + " name range: " + this.getMethodNameStartOffset() + "-" + this.getMethodNameEndOffset() + " bytecode offset " + this.bytecodeOffset;
    }

    public int hashCode() {
        return this.mi_hash;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MethodRange)) {
            return false;
        }
        MethodRange otherRange = (MethodRange)other;
        return otherRange.mi_text.equals(this.mi_text) && otherRange.getMethodInvocationStart() == this.getMethodInvocationStart();
    }

    TextRange getTextRange() {
        return this.textRange;
    }

    public int compareTo(Object o) {
        if (o instanceof MethodRange) {
            int thisEnd;
            MethodRange other = (MethodRange)o;
            int otherStart = other.getMethodNameStartOffset();
            if (otherStart < (thisEnd = this.getMethodInvocationEnd())) {
                return 1;
            }
            if (otherStart > thisEnd) {
                return -1;
            }
            return 0;
        }
        throw new IllegalArgumentException("Expected MethodRange");
    }

    public boolean validateUnitTestRange(String text, String name) {
        String trimmed = this.mi_text.trim().replaceAll("\\n", "").replaceAll(" +", " ");
        if (text == null || !text.equals(trimmed)) {
            return false;
        }
        return name != null && name.equals(this.mi_methodName);
    }

    public boolean nameCoversOffset(int offsetFromEditor) {
        return this.getMethodNameStartOffset() <= offsetFromEditor && this.getMethodNameEndOffset() >= offsetFromEditor;
    }
}

