/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.RunLogPage;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.breakpoint.CoreBreakpoint;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerHeapWindowOptions;
import oracle.jdevimpl.debugger.support.DebuggerInspectorWindowOptions;
import oracle.jdevimpl.debugger.support.DebuggerLocalsWindowOptions;
import oracle.jdevimpl.debugger.support.DebuggerMonitorsWindowOptions;
import oracle.jdevimpl.debugger.support.DebuggerSmartWindowOptions;
import oracle.jdevimpl.debugger.support.DebuggerWatchWindowOptions;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.debug.BreakpointRuntimeSupport;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelSaveHelper;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataPopulationWorker;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;
import oracle.jdevimpl.runner.debug.MultiViewPanel;
import oracle.jdevimpl.runner.debug.ObjectPreferences;
import oracle.jdevimpl.runner.debug.ObjectPreferencesPanel;
import oracle.jdevimpl.runner.debug.VersionedDataItem;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

public abstract class DataController
implements oracle.ide.controller.Controller {
    protected String title;
    protected DataTreeTableModel model;
    private DataPanel dataPanel;
    protected DebugVirtualMachine vm;
    protected DebugThreadInfo thread;
    protected DebugStackFrameInfo frame;
    protected boolean useFilters;
    private ObjectPreferences objectPreferences;
    private static final String BREAKPOINT_INSTANCE_FILTER_CMD_PREFIX = "DebugDataInstanceFilter";
    private Map breakpointInstanceFilterActions;
    protected boolean selectFirstRowIfNoPreviousSelection = false;
    protected DataPanelSettings dataPanelSettings;
    protected int preferredVisibleRowCount = 6;
    protected Font ancestorDepthZeroFont = null;
    protected Font heapAncestorOutsideHeapFont = null;
    protected DebuggerDataWindowOptions windowOptions = null;
    protected IdeAction _actionViewWhole;
    protected IdeAction _actionViewAnnotations;
    protected IdeAction _actionViewAnnotationsForClass;
    protected IdeAction _actionAdjustRange;
    protected IdeAction _actionToggleValue;
    protected IdeAction _actionModifyValue;
    protected IdeAction _actionDiagram;
    protected IdeAction _actionWatch;
    protected IdeAction _actionInspect;
    protected IdeAction _actionWatchClassLoader;
    protected IdeAction _actionInspectClassLoader;
    protected IdeAction _actionGoto;
    protected IdeAction _actionGotoDeclared;
    protected IdeAction _actionGotoField;
    protected IdeAction _actionUseFilters;
    protected IdeAction _actionObjectPreferences;
    protected IdeAction _actionCollapseAll;
    protected IdeAction _actionSave;
    protected IdeAction _actionSettings;
    protected IdeAction _actionUseToString;
    protected JMenuItem _menuitemViewWhole;
    protected JMenuItem _menuitemViewAnnotations;
    protected JMenuItem _menuitemViewAnnotationsForClass;
    protected JMenuItem _menuitemAdjustRange;
    protected JMenuItem _menuitemToggleValue;
    protected JMenuItem _menuitemModifyValue;
    protected JMenuItem _menuitemDiagram;
    protected JMenuItem _menuitemWatch;
    protected JMenuItem _menuitemInspect;
    protected JMenuItem _menuitemWatchClassLoader;
    protected JMenuItem _menuitemInspectClassLoader;
    protected JMenuItem _menuitemGoto;
    protected JMenuItem _menuitemGotoDeclared;
    protected JMenuItem _menuitemGotoField;
    protected JMenuItem _menuitemUseFilters;
    protected JMenuItem _menuitemObjectPreferences;
    protected JMenuItem _menuitemCollapseAll;
    protected JMenuItem _menuitemSave;
    protected JMenuItem menuitemUseToString;
    protected int _VIEW_WHOLE_CMD_ID;
    protected int _VIEW_ANNOTATIONS_CMD_ID;
    protected int _VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    protected int _ADJUST_RANGE_CMD_ID;
    protected int _TOGGLE_VALUE_CMD_ID;
    protected int _MODIFY_VALUE_CMD_ID;
    protected int _WATCH_CMD_ID;
    protected int _INSPECT_CMD_ID;
    protected int _WATCH_CLASSLOADER_CMD_ID;
    protected int _INSPECT_CLASSLOADER_CMD_ID;
    public int _GOTO_CMD_ID;
    public int _GOTO_DECLARED_CMD_ID;
    public int _GOTO_FIELD_CMD_ID;
    protected int _USE_FILTERS_CMD_ID;
    protected int _OBJECT_PREFERENCES_CMD_ID;
    protected int _COLLAPSE_ALL_CMD_ID;
    protected int _SAVE_CMD_ID;
    protected int _SETTINGS_CMD_ID;
    protected int _USE_TO_STRING_CMD_ID = Ide.findOrCreateCmdID((String)"DebugUseToString");

    protected DataController(DataPanelSettings dataPanelSettings, DataPanel dataPanel) {
        this.dataPanelSettings = dataPanelSettings;
        this.dataPanel = dataPanel;
        ArrayList rootList = new ArrayList();
        List<DataItem> modelRoot = Collections.synchronizedList(rootList);
        this.model = new DataTreeTableModel(modelRoot);
        JDebugger jdebugger = JDebugger.getInstance();
        this.objectPreferences = jdebugger.getObjectPreferences();
        this.breakpointInstanceFilterActions = new HashMap(10);
        this.makeActions();
    }

    @Deprecated
    protected void setActionToggleState() {
        if (this._actionUseFilters != null) {
            this._actionUseFilters.setEnabled(this.useFilters);
        }
    }

    protected abstract void addDataItems();

    protected void debugContextChanged() {
    }

    protected List<DataItem> getRoot() {
        return this.model.getRoot();
    }

    void everythingChanged() {
        this.everythingChanged(false);
    }

    void everythingChanged(boolean offThread) {
        if (this.dataPanel.isShowing() && this.model != null) {
            this.dataPanel.saveSelection();
            DataPopulationWorker worker = new DataPopulationWorker(this.getDataPanel());
            if (offThread) {
                WorkerThreadFactory.UPDATE_SCHEDULER.submit(worker);
            } else {
                worker.run();
            }
        }
    }

    DebuggingProcess getDebuggingProcess() {
        return this.getModel().getDebuggingProcess();
    }

    DataTreeTableModel getModel() {
        return this.model;
    }

    Context getContext() {
        return this.getContext(null);
    }

    Context getContext(EventObject event) {
        Object info;
        DebugDataInfo dataInfo;
        DataItem dataItem = this.getSelectedDataItem();
        JDIInformationProvider jdiInformationProvider = null;
        if (dataItem != null && (dataInfo = dataItem.getDataInfo()) instanceof JDIInformationProvider) {
            jdiInformationProvider = (JDIInformationProvider)((Object)dataInfo);
        }
        Context context = ContextBuilder.buildContext((Element)dataItem, (View)this.getDataPanel().getDockableWindow(), event, this.getDebuggingProcess(), jdiInformationProvider);
        if (this.frame instanceof JDIInformationProvider) {
            ContextBuilder.addJDIInformation(context, (JDIInformationProvider)((Object)this.frame));
        }
        if (dataItem != null && (info = dataItem.getInfo()) instanceof JDIInformationProvider) {
            ContextBuilder.addJDIInformation(context, (JDIInformationProvider)info);
        }
        return context;
    }

    protected void makeActions() {
        this._actionUseToString = IdeAction.findOrCreate((int)this._USE_TO_STRING_CMD_ID, null, (String)DbgArb.getString(853), null, (Integer)DbgArb.getInteger(854), null, null, (boolean)false);
        this._actionUseToString.putValue("Check", (Object)Boolean.TRUE);
        this._actionUseToString.setState(false);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        DebuggingProcess debuggingProcess = this.getDebuggingProcess();
        if (cmdId == this._VIEW_WHOLE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.viewWhole();
            }
            return true;
        }
        if (cmdId == this._USE_TO_STRING_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.toggleUseToString();
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.viewAnnotations(debuggingProcess, this.vm, this.thread, this.frame);
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.viewAnnotationsForClass(debuggingProcess, this.vm, this.thread, this.frame);
            }
            return true;
        }
        if (cmdId == this._ADJUST_RANGE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.adjustRange(treePath);
            }
            return true;
        }
        if (cmdId == this._TOGGLE_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.toggleValue();
            }
            return true;
        }
        if (cmdId == this._MODIFY_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                String dataItemTypeName = null;
                try {
                    dataItemTypeName = dataItem.getFullyQualifiedActualType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ("java.lang.StackTraceElement".equals(dataItemTypeName)) {
                    Debugger debugger = Debugger.getDebugger();
                    if (debugger != null) {
                        String stackTraceLine = "at " + dataItem.getValue();
                        Workspace workspace = this.dataPanel.getDebuggingProcess().getWorkspace();
                        Project project = this.dataPanel.getDebuggingProcess().getProject();
                        URL urlForNonJavaStackTraceLines = RunLogPage.getURLFromStackTraceLine((String)stackTraceLine);
                        if (urlForNonJavaStackTraceLines != null) {
                            debugger.showSourceFileForStackTraceLine(workspace, project, urlForNonJavaStackTraceLines);
                        } else {
                            debugger.showSourceFileForStackTraceLine(workspace, project, stackTraceLine);
                        }
                    }
                } else {
                    dataItem.modifyValue(this.vm);
                }
            }
            return true;
        }
        if (cmdId == this._WATCH_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.watch(treePath);
            }
            return true;
        }
        if (cmdId == this._INSPECT_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.inspect(treePath);
            }
            return true;
        }
        if (cmdId == this._WATCH_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.watchClassLoader(debuggingProcess);
            }
            return true;
        }
        if (cmdId == this._INSPECT_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.inspectClassLoader(debuggingProcess);
            }
            return true;
        }
        if (cmdId == this._GOTO_CMD_ID || cmdId == this._GOTO_DECLARED_CMD_ID || cmdId == this._GOTO_FIELD_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.showSource(cmdId, debuggingProcess);
            }
            return true;
        }
        if (cmdId == this._USE_FILTERS_CMD_ID) {
            this.useFilters = action.getState();
            this._actionUseFilters.setEnabled(this.useFilters);
            JDebugger.getInstance().setUseFilters(action.getState());
            return true;
        }
        if (cmdId == this._OBJECT_PREFERENCES_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && dataItem.data instanceof DebugDataObjectInfo && dataItem.actualClassInfo != null) {
                ObjectPreferencesPanel.showObjectPreferencesDialog(dataItem.actualClassInfo, this.dataPanelSettings.isSortFieldsByName(this.vm.getID()));
                this.useFilters = ObjectPreferencesPanel.getUseFilters();
                this._actionUseFilters.setEnabled(this.useFilters);
                if (dataItem instanceof VersionedDataItem) {
                    ObjectPreferences.getLogger().trace("DataController handleEvent expiring VersionedDataItem for " + this.getDataPanel().getTitle());
                    ((VersionedDataItem)dataItem).expire();
                }
                this.everythingChanged();
            }
            return true;
        }
        if (cmdId == this._COLLAPSE_ALL_CMD_ID) {
            this.collapseAll();
            return true;
        }
        if (cmdId == this._SAVE_CMD_ID) {
            DataPanelSaveHelper.saveToFile(this.dataPanel.getDataTable(), this.model, this.title, this.getContext());
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (column = this.dataPanel.getDataTable().getTable().getSelectedColumn()) != -1 && (o = dataItem.getValueOfColumn(column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        DebugBreakpoint dbp = (DebugBreakpoint)this.breakpointInstanceFilterActions.get(action);
        if (dbp != null) {
            DebugDataInfo ddi;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (ddi = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
                DebugDataObjectInfo data = (DebugDataObjectInfo)ddi;
                Boolean isInstanceFilterSet = (Boolean)action.getValue("UserData");
                if (isInstanceFilterSet.booleanValue()) {
                    dbp.removeInstanceFilter(data);
                } else {
                    dbp.addInstanceFilter(data);
                }
                JDebugger.getInstance().updateBreakpointsWindowInstanceFilters();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        DataItem dataItem;
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            JTable table = this.dataPanel.getDataTable().getTable();
            if (table == null || !this.isParentVisible(table)) {
                action.setEnabled(false);
                return true;
            }
            if (!table.isEnabled() || this.getDebuggingProcess() == null || this.vm == null) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == this._VIEW_WHOLE_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canViewWhole());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._USE_TO_STRING_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                int result = dataItem.canUseToStringForValue();
                if (result < 0) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                    action.setState(result > 0);
                }
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                String name = dataItem.canViewAnnotations();
                if (name != null) {
                    action.setEnabled(true);
                    action.putValue("Name", (Object)name);
                } else {
                    action.setEnabled(false);
                    action.putValue("Name", action.getValue("NoCtxName"));
                }
            } else {
                action.setEnabled(false);
                action.putValue("Name", action.getValue("NoCtxName"));
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canViewAnnotationsForClass());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._ADJUST_RANGE_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canAdjustRange());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._TOGGLE_VALUE_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canToggleValue());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._MODIFY_VALUE_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canModifyValue());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._WATCH_CMD_ID || cmdId == this._INSPECT_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                action.setEnabled(dataItem.canWatchAndInspect(treePath));
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._WATCH_CLASSLOADER_CMD_ID || cmdId == this._INSPECT_CLASSLOADER_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canWatchInspectClassLoader());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._GOTO_CMD_ID || cmdId == this._GOTO_DECLARED_CMD_ID || cmdId == this._GOTO_FIELD_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                String name = dataItem.canShowSource(cmdId);
                if (name != null) {
                    action.setEnabled(true);
                    action.putValue("Name", (Object)name);
                } else {
                    action.setEnabled(false);
                    action.putValue("Name", action.getValue("NoCtxName"));
                }
            } else {
                action.setEnabled(false);
                action.putValue("Name", action.getValue("NoCtxName"));
            }
            return true;
        }
        if (cmdId == this._USE_FILTERS_CMD_ID) {
            action.setState(this.useFilters);
            action.setEnabled(!this.objectPreferences.isHiddenFieldsEmpty());
            return true;
        }
        if (cmdId == this._OBJECT_PREFERENCES_CMD_ID) {
            dataItem = this.getSelectedDataItem();
            if (dataItem != null && dataItem.data instanceof DebugDataObjectInfo && dataItem.actualClassInfo != null) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._COLLAPSE_ALL_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == this._SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            dataItem = this.getSelectedDataItem();
            int column = this.dataPanel.getDataTable().getTable().getSelectedColumn();
            action.setEnabled(dataItem != null && column != -1);
            return true;
        }
        DebugBreakpoint dbp = (DebugBreakpoint)this.breakpointInstanceFilterActions.get(action);
        if (dbp != null) {
            DebugDataInfo ddi;
            DataItem dataItem2 = this.getSelectedDataItem();
            if (dataItem2 != null && (ddi = dataItem2.getDataInfo()) instanceof DebugDataObjectInfo) {
                action.setEnabled(true);
            }
            return true;
        }
        return false;
    }

    private boolean isParentVisible(JTable table) {
        if (this.getDataPanel().getDockableWindow() != null) {
            return this.getDataPanel().getDockableWindow().isVisible();
        }
        return table != null && table.getParent() != null;
    }

    static void showAnnotationsDialog(String title, DataPanelSettings dataPanelSettings, DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame, final DebugAnnotationInfo[] annotations) {
        TreePath treePath;
        if (dataPanelSettings == null) {
            dataPanelSettings = LocalsWindowSettings.getInstance().getDataPanelSettings();
        }
        DataPanel dataPanel = new DataPanel(title, dataPanelSettings){

            @Override
            protected DataController createController(DataPanelSettings dataPanelSettings) {
                return new Controller(dataPanelSettings, this);
            }

            class Controller
            extends DataController {
                Controller(DataPanelSettings dataPanelSettings, DataPanel dataPanel) {
                    super(dataPanelSettings, dataPanel);
                }

                @Override
                protected void addDataItems() {
                    List<DataItem> root = this.getRoot();
                    int i = 0;
                    for (DebugAnnotationInfo annotation : annotations) {
                        DebugClassInfo annotationType = annotation.getClassInfo();
                        String displayName = "@" + DataItem.makeType(null, annotationType, false);
                        root.add(new DataItem(this.getDataPanel(), annotation, displayName, null));
                        ++i;
                    }
                }
            }
        };
        Component dataPanelGUI = dataPanel.getGUI();
        dataPanel.debugWindowSettingsChanged(DebugWindowSettings.getInstance());
        dataPanel.dataPanelSettingsChanged();
        dataPanel.updateData(debuggingProcess, vm, thread, frame);
        if (annotations.length == 1 && dataPanel.getDataTable().getTable().getRowCount() > 0 && (treePath = dataPanel.getDataTable().getPathForRow(0)) != null) {
            dataPanel.getDataTable().expandPath(treePath);
        }
        OnePageWizardDialogFactory.runDialog((Component)dataPanelGUI, (Component)dataPanel.getDataTable().getTable(), (String)title, (int)1);
    }

    protected final void addPopupItem(ContextMenu popup, Context context, IdeAction action, JMenuItem menuItem, float sectionId) {
        if (action == null) {
            return;
        }
        this.update(action, context);
        if (action.isEnabled()) {
            if (menuItem == null) {
                menuItem = popup.createMenuItem((ToggleAction)action);
            }
            popup.add((Component)menuItem, sectionId);
        }
    }

    protected void addPopupMenuItemsForNew(ContextMenu popup, Context context) {
    }

    protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, this._actionViewWhole, this._menuitemViewWhole, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionUseToString, this.menuitemUseToString, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionViewAnnotations, this._menuitemViewAnnotations, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionViewAnnotationsForClass, this._menuitemViewAnnotationsForClass, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionAdjustRange, this._menuitemAdjustRange, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionToggleValue, this._menuitemToggleValue, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionModifyValue, this._menuitemModifyValue, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionDiagram, this._menuitemDiagram, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionWatch, this._menuitemWatch, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionInspect, this._menuitemInspect, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionWatchClassLoader, this._menuitemWatchClassLoader, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionInspectClassLoader, this._menuitemInspectClassLoader, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionGoto, this._menuitemGoto, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionGotoDeclared, this._menuitemGotoDeclared, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionGotoField, this._menuitemGotoField, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        this.addPopupItem(popup, context, IdeActions.getEditCopyAction(), null, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_EDIT_CTXT_MENU);
        this.addBreakpointInstanceFilterActions(popup, context);
    }

    private void addBreakpointInstanceFilterActions(ContextMenu popup, Context context) {
        DebugDataInfo data;
        this.breakpointInstanceFilterActions.clear();
        DataItem dataItem = this.getSelectedDataItem();
        if (dataItem != null && (data = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
            Boolean isInstanceFilterSet;
            DebugDataObjectInfo dataObject = (DebugDataObjectInfo)data;
            HashSet classNames = new HashSet();
            HashMap<CoreBreakpoint, Boolean> appropriate = new HashMap<CoreBreakpoint, Boolean>();
            List[] breakpoints = CoreBreakpoint.getBreakpoints((Workspace)context.getWorkspace(), (Project)context.getProject());
            int length = breakpoints.length;
            for (int i = 0; i < length; ++i) {
                for (CoreBreakpoint bp : breakpoints[i]) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(bp, this.getDebuggingProcess());
                    if (dbp == null || !dbp.isInstanceFilterAppropriate(dataObject, classNames)) continue;
                    isInstanceFilterSet = dbp.isInstanceFilterSet(dataObject) ? Boolean.TRUE : Boolean.FALSE;
                    appropriate.put(bp, isInstanceFilterSet);
                }
            }
            if (!appropriate.isEmpty()) {
                JMenu subMenu = popup.createSubMenu(DbgArb.getString(292), DbgArb.getInteger(293));
                int count = 0;
                for (CoreBreakpoint bp : appropriate.keySet()) {
                    isInstanceFilterSet = (Boolean)appropriate.get(bp);
                    String label = DbgArb.format(294, bp.getTypeString(), bp.getDescription());
                    int cmdId = Ide.findOrCreateCmdID((String)(BREAKPOINT_INSTANCE_FILTER_CMD_PREFIX + count++));
                    IdeAction action = IdeAction.findOrCreate((int)cmdId, null, (String)label, null, null, null, (Object)isInstanceFilterSet, (boolean)true);
                    action.putValue("Name", (Object)label);
                    action.putValue("UserData", (Object)isInstanceFilterSet);
                    action.putValue("Check", (Object)Boolean.TRUE);
                    action.setState(isInstanceFilterSet.booleanValue());
                    action.addController((oracle.ide.controller.Controller)this);
                    this.breakpointInstanceFilterActions.put(action, BreakpointRuntimeSupport.getDebugBreakpoint(bp, this.getDebuggingProcess()));
                    JMenuItem menuitem = popup.createMenuItem((ToggleAction)action);
                    subMenu.add(menuitem);
                }
                popup.add((Component)subMenu, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_ITEM_CTXT_MENU);
            }
        }
    }

    protected void addPopupMenuItemsForData(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, this._actionUseFilters, this._menuitemUseFilters, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_SPECIFIC_CTXT_MENU);
        this.addPopupItem(popup, context, this._actionObjectPreferences, this._menuitemObjectPreferences, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_SPECIFIC_CTXT_MENU);
    }

    protected void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, this._actionCollapseAll, this._menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_TREE_CTXT_MENU);
    }

    protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.addPopupItem(popup, context, this._actionSave, this._menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGGER_VIEW_COMMON_CTXT_MENU);
    }

    void showObjectPreferences(ActionEvent e) {
        Context context = this.getContext(e);
        this.update(this._actionObjectPreferences, context);
        if (this._actionObjectPreferences.isEnabled()) {
            this.handleEvent(this._actionObjectPreferences, context);
        }
    }

    boolean handleDoubleClickOrEnter(EventObject e, int column) {
        IdeAction action = null;
        switch (column) {
            case 0: {
                action = this._actionGotoField;
                break;
            }
            case 2: {
                action = this._actionGoto;
                break;
            }
            case 3: {
                action = this._actionGotoDeclared;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                action = this._actionModifyValue;
            }
        }
        if (action != null) {
            Context context = this.getContext(e);
            this.update(action, context);
            if (action.isEnabled()) {
                this.handleEvent(action, context);
                return true;
            }
        }
        return false;
    }

    protected final DataPanel getDataPanel() {
        return this.dataPanel;
    }

    protected final DebuggerDataWindowOptions getDebuggerWindowOptions() {
        if (this.windowOptions == null) {
            DebuggingProcess dp;
            DebugVirtualMachine vm = this.vm;
            if (vm == null && (dp = JDebugger.getInstance().getActiveDebuggingProcess()) != null) {
                vm = dp.getVM();
            }
            if (vm != null) {
                DebuggerWindowOptions.WindowId windowId = this.getDataPanel().getWindowIdEnum();
                if (windowId == null) {
                    return null;
                }
                DebuggerWindowOptions options = vm.getDebuggerWindowOptions(windowId);
                if (options == null) {
                    return null;
                }
                if (options == DebuggerWindowOptions.DEFAULT) {
                    switch (windowId) {
                        case LocalsWindow: {
                            this.windowOptions = new DebuggerLocalsWindowOptions(this.dataPanelSettings);
                            break;
                        }
                        case SmartWindow: {
                            this.windowOptions = new DebuggerSmartWindowOptions(this.dataPanelSettings);
                            break;
                        }
                        case WatchWindow: {
                            this.windowOptions = new DebuggerWatchWindowOptions(this.dataPanelSettings);
                            break;
                        }
                        case InspectorWindow: {
                            this.windowOptions = new DebuggerInspectorWindowOptions(this.dataPanelSettings);
                            break;
                        }
                        case HeapWindow: {
                            this.windowOptions = new DebuggerHeapWindowOptions(this.dataPanelSettings);
                            break;
                        }
                        case MonitorsWindow: {
                            this.windowOptions = new DebuggerMonitorsWindowOptions(this.dataPanelSettings).getMainWindowOptions();
                            break;
                        }
                        default: {
                            System.out.println("DataController.getDebuggerWindowOptions: Unknown window type " + (Object)((Object)windowId));
                            break;
                        }
                    }
                } else {
                    this.windowOptions = (DebuggerDataWindowOptions)options;
                }
            }
        }
        return this.windowOptions;
    }

    protected final DataItem getSelectedDataItem() {
        return this.dataPanel.getSelectedDataItem();
    }

    protected final TreePath getSelectedTreePath() {
        return this.dataPanel.getSelectedTreePath();
    }

    private void collapseAll() {
        this.dataPanel.collapseAll();
    }

    void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        this.debugContextChanged();
        this.model.setDebuggingProcess(debuggingProcess);
        this.thread = thread;
        this.frame = frame;
        if (vm == null && debuggingProcess != null && debuggingProcess.getVM() != null) {
            vm = debuggingProcess.getVM();
        }
        if (this.vm != vm) {
            this.setVm(vm);
        }
        this.updateInstanceCounts(vm);
    }

    public void updateInstanceCounts(final DebugVirtualMachine vm) {
        if (vm == null) {
            return;
        }
        String windowID = this.getDataPanel() instanceof MultiViewPanel ? ((MultiViewPanel)this.getDataPanel()).getWindowId() : null;
        HashStructure hash = this.dataPanelSettings.getHash();
        String vmName = vm.getID();
        if (windowID != null) {
            if (WindowSettingsColumnManager.getActiveDataView(hash, vmName, windowID) == "TREE_TABLE" && !WindowSettingsColumnManager.getColumnVisible(hash, vmName, 7)) {
                return;
            }
            if (WindowSettingsColumnManager.getActiveDataView(hash, vmName, windowID) == "TABLE_TABLE" && !WindowSettingsColumnManager.getColumnBreadcrumbVisible(hash, vmName, 7)) {
                return;
            }
        }
        if (vm.getCapabilities().canCountObjectsOfClass()) {
            Runnable instanceCounter = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList<DataItem> copy;
                    ArrayList visibleItems = new ArrayList();
                    HashMap classCounts = new HashMap();
                    ArrayList classesToCount = new ArrayList();
                    List<DataItem> root = DataController.this.getRoot();
                    List<DataItem> list = root;
                    synchronized (list) {
                        copy = new ArrayList<DataItem>(root);
                    }
                    for (DataItem item : copy) {
                        DataController.this.addItemAndChildrenToList(item, visibleItems, classesToCount);
                    }
                    if (classesToCount.size() == 0) {
                        return;
                    }
                    DebugClassInfo[] debugClassInfos = classesToCount.toArray(new DebugClassInfo[classesToCount.size()]);
                    long[] counts = vm.countObjectsOfClasses(debugClassInfos);
                    if (counts == null || counts.length == 0) {
                        return;
                    }
                    for (int i = 0; i < counts.length; ++i) {
                        classCounts.put(classesToCount.get(i), counts[i]);
                    }
                    for (DataItem countedItem : visibleItems) {
                        Long count;
                        if (countedItem.actualClassInfo == null || (count = (Long)classCounts.get(countedItem.actualClassInfo)) == null) continue;
                        countedItem.setInstanceCount(count);
                    }
                }
            };
            instanceCounter.run();
        }
    }

    private void addItemAndChildrenToList(DataItem item, List<DataItem> list, List<DebugClassInfo> classInfos) {
        if (item.actualClassInfo != null && !item.actualClassInfo.isPrimitive()) {
            list.add(item);
            classInfos.add(item.actualClassInfo);
        }
        boolean skipExpandedCheck = false;
        for (DataItem subitem : item.getChildNodes(skipExpandedCheck)) {
            this.addItemAndChildrenToList(subitem, list, classInfos);
        }
    }

    public void clearData() {
        TreePath treePath = new TreePath(this.getModel().getRoot());
        this.clearAll(treePath);
        this.thread = null;
        this.frame = null;
        this.setVm(null);
        this.debugContextChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAll(TreePath treePath) {
        Object node = treePath.getLastPathComponent();
        if (node instanceof DataItem) {
            ((DataItem)node).clearDataForItem();
        }
        Object object = this.getModel().getRoot();
        synchronized (object) {
            Iterator<DataItem> children = this.getModel().getLazyChildren(node);
            while (children.hasNext()) {
                DataItem child = children.next();
                if (child == null) continue;
                this.clearAll(treePath.pathByAddingChild(child));
            }
        }
    }

    boolean isRunning() {
        return this.getDebuggingProcess() != null && this.vm != null;
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        this.getDataPanel().processFinished(debuggingProcess);
        if (this.model != null) {
            this.model.processFinished(debuggingProcess);
        }
        if (this.getDebuggingProcess() == debuggingProcess) {
            this.model.setDebuggingProcess(null);
            this.thread = null;
            this.frame = null;
            this.setVm(null);
        }
    }

    public final DebugVirtualMachine getVm() {
        return this.vm;
    }

    public final DebugThreadInfo getThread() {
        return this.thread;
    }

    public final DebugStackFrameInfo getFrame() {
        return this.frame;
    }

    public final void setFrame(DebugStackFrameInfo frame) {
        this.frame = frame;
    }

    public void setVm(DebugVirtualMachine vm) {
        if (this.vm != vm) {
            DataTable table;
            DebuggerDataWindowOptions options = null;
            this.vm = vm;
            if (vm != null) {
                options = this.getDebuggerWindowOptions();
                if (options == null) {
                    return;
                }
                this.model.setWindowOptions(options);
                this.model.setDataPanelSettings(this.dataPanelSettings);
            }
            if (this.getDataPanel() instanceof MultiViewPanel) {
                ((MultiViewPanel)this.getDataPanel()).setNewVm(vm, options);
            }
            if ((table = this.getDataPanel().getDataTable()) != null) {
                table.setNewVm(vm, this.getDataPanel(), options);
            }
        }
    }

    public final void setThread(DebugThreadInfo thread) {
        this.thread = thread;
    }

    private static class WorkerThreadFactory
    implements ThreadFactory {
        private static final ExecutorService UPDATE_SCHEDULER = Executors.newSingleThreadExecutor(new WorkerThreadFactory());

        private WorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "DataPopulation Thread");
            t.setDaemon(true);
            return t;
        }
    }
}

