/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.runner.SourceFinder;
import oracle.jdeveloper.runner.SourceFinderManager;

public final class SourceHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension/jdev-runner", "source-hook");
    private static final String RULE_LITERAL = "rule";
    private static HashStructureHook hook;
    private static Map<String, ToolDescription<SourceFinder>> _sourceFinders;
    private static Map<String, ToolDescription<SourceFinderManager>> _sourceFinderManagers;
    private static Set<String> _emittedErrors;

    public static synchronized boolean addSourceFinder(SourceFinder sourceFinder) {
        if (sourceFinder == null) {
            assert (sourceFinder != null);
            return false;
        }
        SourceHook.primeHook();
        return SourceHook.addTool(sourceFinder, _sourceFinders, Category.SOURCE_FINDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SourceFinder> getSourceFinders(Workspace workspace, Project project) {
        Class<SourceHook> clazz = SourceHook.class;
        synchronized (SourceHook.class) {
            SourceHook.primeHook();
            ArrayList copy = new ArrayList(_sourceFinders.values());
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return SourceHook.getTools(copy, workspace, project);
        }
    }

    public static synchronized boolean removeSourceFinder(SourceFinder sourceFinder) {
        if (sourceFinder == null) {
            assert (sourceFinder != null);
            return false;
        }
        if (_sourceFinders != null) {
            return SourceHook.removeTool(sourceFinder, _sourceFinders);
        }
        return false;
    }

    public static synchronized boolean addSourceFinderManager(SourceFinderManager sourceFinderManager) {
        if (sourceFinderManager == null) {
            assert (sourceFinderManager != null);
            return false;
        }
        SourceHook.primeHook();
        return SourceHook.addTool(sourceFinderManager, _sourceFinderManagers, Category.SOURCE_FINDER_MANAGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SourceFinderManager> getSourceFinderManagers(Workspace workspace, Project project) {
        Class<SourceHook> clazz = SourceHook.class;
        synchronized (SourceHook.class) {
            SourceHook.primeHook();
            ArrayList copy = new ArrayList(_sourceFinderManagers.values());
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return SourceHook.getTools(copy, workspace, project);
        }
    }

    public static synchronized boolean removeSourceFinderManager(SourceFinderManager sourceFinderManager) {
        if (sourceFinderManager == null) {
            assert (sourceFinderManager != null);
            return false;
        }
        if (_sourceFinderManagers != null) {
            return SourceHook.removeTool(sourceFinderManager, _sourceFinderManagers);
        }
        return false;
    }

    private static <T> Map<String, ToolDescription<T>> primeTools(Map<String, ToolDescription<T>> tools) {
        if (tools == null) {
            return new LinkedHashMap<String, ToolDescription<T>>();
        }
        return tools;
    }

    private static <T> List<T> getTools(List<ToolDescription<T>> copy, Workspace workspace, Project project) {
        ArrayList<Object> tools = new ArrayList<Object>(copy.size());
        for (ToolDescription<T> desc : copy) {
            Object tool;
            if (!desc.rulesApply(workspace, project) || (tool = ((ToolDescription)desc).getTool()) == null) continue;
            tools.add(tool);
        }
        return tools;
    }

    private static synchronized void primeHook() {
        if (hook == null) {
            _sourceFinders = SourceHook.primeTools(_sourceFinders);
            _sourceFinderManagers = SourceHook.primeTools(_sourceFinderManagers);
            hook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
            if (hook == null) {
                return;
            }
            hook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    this.addItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    this.addItemsFromHook(e.getCombinedHashStructure());
                }

                private void addItemsFromHook(HashStructure hashStructure) {
                    SourceHook.updateToolsFromHook(hashStructure, Category.SOURCE_FINDER, _sourceFinders);
                    SourceHook.updateToolsFromHook(hashStructure, Category.SOURCE_FINDER_MANAGER, _sourceFinderManagers);
                }
            });
        }
    }

    private static synchronized <T> void updateToolsFromHook(HashStructure hashStructure, Category toolCategory, Map<String, ToolDescription<T>> knownTools) {
        List definitions = hashStructure.getAsList(toolCategory.toString());
        if (definitions != null && definitions.size() > 0) {
            for (Object definition : definitions) {
                String className;
                ToolDescription desc;
                String extensionId;
                block6: {
                    HashStructure hash = (HashStructure)definition;
                    extensionId = HashStructureHook.getExtensionId((HashStructure)hash);
                    desc = new ToolDescription(extensionId, hash, toolCategory);
                    className = desc.getClassName();
                    if (className == null) continue;
                    try {
                        String rule = hash.getString(RULE_LITERAL);
                        if (!SourceHook.isMissingRule(rule, className, toolCategory.name(), extensionId) && !SourceHook.isValidRule(rule, className, toolCategory.name(), extensionId)) {
                        }
                        break block6;
                    }
                    catch (ClassCastException cce) {
                        SourceHook.logError("SourceHook.updateToolsFromHook failed to get rule for " + className + " due to ClassCastException; will treat as always-enabled rule", toolCategory.name(), extensionId);
                    }
                    continue;
                }
                if (!knownTools.containsKey(className)) {
                    knownTools.put(className, desc);
                    continue;
                }
                SourceHook.logDuplicateError(className, toolCategory, extensionId);
            }
        }
    }

    private static boolean isMissingRule(String rule, String className, String category, String extensionId) {
        if (rule == null || rule.trim().length() == 0) {
            SourceHook.ruleError("Missing", className, category, extensionId);
            return true;
        }
        return false;
    }

    private static boolean isValidRule(String rule, String className, String category, String extensionId) {
        RuleEngine engine = RuleEngine.getInstance();
        Rule engineRule = engine.getRule(rule);
        HashSet<String> acceptedRules = new HashSet<String>(3);
        acceptedRules.add("project-has-techscope");
        acceptedRules.add("always-enabled");
        acceptedRules.add("project-content-has-contents");
        if (engineRule == null || !engineRule.matchesType(acceptedRules)) {
            SourceHook.ruleError("Invalid", className, category, extensionId);
            return false;
        }
        return true;
    }

    private static void ruleError(String prefix, String className, String category, String extensionId) {
        SourceHook.logError(prefix + " rule attribute in " + className + " registration", category, extensionId);
    }

    private static <T> boolean addTool(T tool, Map<String, ToolDescription<T>> knownTools, Category category) {
        String className = tool.getClass().getName();
        String id = Integer.toString(System.identityHashCode(tool));
        if (knownTools.containsKey(id)) {
            SourceHook.logError("Duplicate class, name: " + className + ", id: " + id, category.toString(), null);
            return false;
        }
        knownTools.put(id, new ToolDescription(className, tool, category));
        return true;
    }

    private static <T> boolean removeTool(T tool, Map<String, ToolDescription<T>> knownTools) {
        String id = Integer.toString(System.identityHashCode(tool));
        return knownTools.remove(id) != null;
    }

    private static void logDuplicateError(String className, Category category, String extensionId) {
        SourceHook.logError("Duplicate class name: " + className, category.toString(), extensionId);
    }

    private static synchronized void logError(String msg, String category, String extensionId) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" in ");
        buf.append(category);
        if (extensionId != null) {
            buf.append(" in extension ");
            buf.append(extensionId);
        }
        if (_emittedErrors == null) {
            _emittedErrors = new HashSet<String>();
        }
        if (!_emittedErrors.contains(buf.toString())) {
            _emittedErrors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    private static class ToolDescription<T> {
        private HashStructure hash;
        private String className;
        private T tool;
        private String extensionId;
        private Category category;

        private ToolDescription(String extensionId, HashStructure hash, Category category) {
            this.extensionId = extensionId;
            this.hash = hash;
            this.category = category;
        }

        private ToolDescription(String className, T tool, Category category) {
            this.className = className;
            this.tool = tool;
            this.category = category;
        }

        private String getClassName() {
            if (this.className == null) {
                this.className = this.hash.getString("class");
                if (this.className == null) {
                    SourceHook.logError("Missing 'class' attribute", this.category.toString(), this.extensionId);
                }
            }
            return this.className;
        }

        private synchronized T getTool() {
            if (this.tool == null) {
                ClassLoader classLoader = this.getClassLoader();
                MetaClass metaClass = new MetaClass(classLoader, this.getClassName());
                try {
                    this.tool = metaClass.newInstance();
                }
                catch (Exception ex) {
                    SourceHook.logError("Failed to create instance from class " + this.getClassName(), this.category.toString(), this.extensionId);
                }
            }
            return this.tool;
        }

        private ClassLoader getClassLoader() {
            ClassLoader loader = null;
            if (this.extensionId != null) {
                loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(this.extensionId);
            }
            if (loader == null) {
                loader = SourceHook.class.getClass().getClassLoader();
            }
            return loader;
        }

        public boolean rulesApply(Workspace workspace, Project project) {
            String rule;
            String string = rule = this.hash != null ? this.hash.getString(SourceHook.RULE_LITERAL) : null;
            if (rule != null && rule.trim().length() > 0) {
                RuleEngine engine = RuleEngine.getInstance();
                if (engine.getRule(rule) != null) {
                    Context context = new Context(workspace, project);
                    return engine.evaluateRule(rule, context);
                }
                return false;
            }
            return true;
        }
    }

    private static enum Category {
        SOURCE_FINDER{

            public String toString() {
                return "source-finder";
            }
        }
        ,
        SOURCE_FINDER_MANAGER{

            public String toString() {
                return "source-finder-manager";
            }
        };

    }
}

