/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import oracle.javatools.util.Log;

public class TargetMethod {
    private String methodName;
    private String callerPackage;
    private String callerFile;
    private int callerLineMin;
    private int callerLineMax;
    private int callerBytecodeIndex;
    private static final Log SIOLogger = new Log("SIOLogger");

    public TargetMethod(String methodName, String callerPackage, String callerFile, int callerBytecodeIndex, int callerLineMin, int callerLineMax) {
        this.methodName = methodName;
        this.callerPackage = callerPackage;
        this.callerFile = callerFile;
        this.callerLineMin = callerLineMin;
        this.callerLineMax = callerLineMax;
        this.callerBytecodeIndex = callerBytecodeIndex;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getCallerPackage() {
        return this.callerPackage;
    }

    public String getCallerFile() {
        return this.callerFile;
    }

    public String getCallerFileMinusExtension() {
        return this.callerFile.replaceAll(".java", "");
    }

    public int getCallerLineMin() {
        return this.callerLineMin;
    }

    public int getCallerLineMax() {
        return this.callerLineMax;
    }

    public int getCallerBytecodeIndex() {
        return this.callerBytecodeIndex;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TargetMethod)) {
            return false;
        }
        TargetMethod om = (TargetMethod)other;
        return om.methodName.equals(this.methodName) && om.callerPackage.equals(this.callerPackage) && om.callerFile.equals(this.callerFile) && om.callerBytecodeIndex == this.callerBytecodeIndex && om.callerLineMin == this.callerLineMin && om.callerLineMax == this.callerLineMax;
    }

    public int hashCode() {
        return this.callerFile.hashCode() + this.methodName.hashCode() + this.callerLineMin;
    }

    public String toString() {
        return this.callerPackage + "." + this.callerFile + "." + this.methodName + " bytcode offset " + this.callerBytecodeIndex + " line range : " + this.callerLineMin + "-" + this.callerLineMax + " ";
    }

    public static class VisitationTrackingInfo {
        private int occurrencesOnLine = 1;
        private int occurrencesExecuted = 0;
        private int occurrenceToStopAt = -1;

        public VisitationTrackingInfo(boolean stop) {
            if (stop) {
                this.occurrenceToStopAt = 0;
            }
        }

        public int getNumberOfOccurrences() {
            return this.occurrencesOnLine;
        }

        public void incrementOccurrences() {
            ++this.occurrencesOnLine;
        }

        public int getStopAtOccurrence() {
            return this.occurrenceToStopAt;
        }

        public void setStopAtOccurence(int occurrenceToStopAt) {
            this.occurrenceToStopAt = occurrenceToStopAt;
        }

        @Deprecated
        public int getVisitationCount() {
            return this.occurrencesExecuted;
        }

        @Deprecated
        public void incrementVisitationCount() {
            ++this.occurrencesExecuted;
            SIOLogger.trace("TM$VTI.incrementVisitationCount to " + this.occurrencesExecuted);
        }

        public String toString() {
            return "\tOccurrences: " + this.occurrencesOnLine + " Executed so far: " + this.occurrencesExecuted + " StopAt: " + this.occurrenceToStopAt + "\n";
        }
    }
}

