/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.extender.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.debugger.extender.evaluator.DebuggerExtenderData;
import oracle.ide.debugger.extender.evaluator.DebuggerExtenderEvaluator;
import oracle.ide.debugger.extender.evaluator.DebuggerExtenderThread;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;
import oracle.ide.runner.DebuggerThread;
import oracle.jdevimpl.debugger.DebugObjectFactory;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.extender.evaluator.CustomDataProvider;
import oracle.jdevimpl.debugger.extender.evaluator.DebuggeeDataInfo;
import oracle.jdevimpl.debugger.extender.evaluator.ExtenderEvaluatorContext;
import oracle.jdevimpl.debugger.extender.evaluator.ThreadHandle;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;

public class EvaluatorHandle {
    private boolean expired;
    private EvaluatorProxy evaluator;
    private DebuggingProcess debuggingProcess;
    private CustomDataProvider customDataProvider;
    private ExtenderEvaluatorContext context;

    public EvaluatorHandle(EvaluatorProxy evaluator, DebuggingProcess debuggingProcess, CustomDataProvider customDataProvider) {
        this.evaluator = evaluator;
        this.debuggingProcess = debuggingProcess;
        this.customDataProvider = customDataProvider;
        debuggingProcess.registerEvaluatorHandle(this);
    }

    public synchronized void expire() {
        this.expired = true;
        this.debuggingProcess = null;
        this.evaluator = null;
        this.context = null;
        this.customDataProvider = null;
    }

    public synchronized boolean hasExpired() {
        return this.expired;
    }

    public synchronized Context getContext() {
        if (!this.expired) {
            return this.debuggingProcess.getContext();
        }
        return null;
    }

    public synchronized int getStackFrame() {
        if (!this.expired && this.evaluator.getEvaluatorContext().getFrame() != null) {
            return this.evaluator.getEvaluatorContext().getFrame().getFrameNumber();
        }
        return -1;
    }

    public synchronized int getStackFrameCount() {
        int size;
        if (!this.expired && (size = this.getDebugStackFrameInfos().size()) > 0) {
            return size;
        }
        return -1;
    }

    public synchronized ExtenderEvaluatorContext getEvaluatorContext() {
        if (!this.expired) {
            if (this.context == null) {
                this.context = new ExtenderEvaluatorContext(this.evaluator.getEvaluatorContext());
            }
            return this.context;
        }
        return null;
    }

    private DebugThreadInfo[] getDebugThreadInfos() {
        EvaluatorProxy currentEvaluator;
        if (!this.expired && (currentEvaluator = this.evaluator) != null && currentEvaluator.getEvaluatorContext().getVM() != null) {
            return currentEvaluator.getEvaluatorContext().getVM().listThreads();
        }
        return new DebugThreadInfo[0];
    }

    private CustomDataProvider getCustomDataProvider() {
        return this.customDataProvider;
    }

    private List<DebugStackFrameInfo> getDebugStackFrameInfos() {
        DebugThreadInfo thread;
        EvaluatorProxy currentEvaluator;
        if (!this.expired && (currentEvaluator = this.evaluator) != null && currentEvaluator.getEvaluatorContext().getVM() != null && (thread = currentEvaluator.getEvaluatorContext().getVM().getCurrentThread()) != null) {
            int count = thread.getStackFrameCount();
            ArrayList<DebugStackFrameInfo> frameList = new ArrayList<DebugStackFrameInfo>(count);
            for (int i = 0; i < count; ++i) {
                frameList.add(thread.getStackFrame(i));
            }
            return frameList;
        }
        return Collections.emptyList();
    }

    public class EvaluatorHandleVersion12
    extends EvaluatorHandle
    implements DebuggerEvaluator {
        public EvaluatorHandleVersion12() {
            super(EvaluatorHandle.this.evaluator, EvaluatorHandle.this.debuggingProcess, EvaluatorHandle.this.customDataProvider);
        }

        public synchronized DebuggerThread getThread() {
            if (!EvaluatorHandle.this.expired && EvaluatorHandle.this.evaluator.getEvaluatorContext().getThread() != null) {
                return (DebuggerThread)new ThreadHandle(EvaluatorHandle.this.evaluator.getEvaluatorContext().getThread().getName());
            }
            return null;
        }

        public synchronized DebuggeeData evaluate(String expression, DebuggeeData context) {
            ArrayList<String> expressions = new ArrayList<String>(1);
            expressions.add(expression);
            List<DebuggeeData> result = this.evaluate(expressions, context);
            return result == null ? null : result.get(0);
        }

        public synchronized List<DebuggeeData> evaluate(List<String> expressions, DebuggeeData context) {
            CustomDataProvider customDataProvider = EvaluatorHandle.this.getCustomDataProvider();
            if (customDataProvider == null) {
                System.out.println("null custom data provider - debug this.");
                return null;
            }
            if (!EvaluatorHandle.this.expired) {
                Object info;
                if (JDebugger.logger.isEnabled()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Strings to evaluate:\n");
                    for (String expression : expressions) {
                        buf.append(expression);
                        buf.append('\n');
                    }
                    JDebugger.logger.trace(buf.toString());
                }
                long milliTime = System.currentTimeMillis();
                DebugThreadInfo thread = EvaluatorHandle.this.evaluator.getEvaluatorContext().getThread();
                DebugStackFrameInfo frame = EvaluatorHandle.this.evaluator.getEvaluatorContext().getFrame();
                DebuggeeDataInfo.DebuggeeDataInfoVersion12 parent = null;
                boolean restoreContext = false;
                if (context instanceof DebuggeeDataInfo.DebuggeeDataInfoVersion12 && (info = ((DebuggeeDataInfo)context).getDataInfo()) instanceof DebugDataObjectInfo) {
                    EvaluatorHandle.this.evaluator.setDebugContext((DebugDataObjectInfo)info);
                    restoreContext = true;
                    parent = (DebuggeeDataInfo.DebuggeeDataInfoVersion12)context;
                }
                ArrayList<DebuggeeData> results = new ArrayList<DebuggeeData>();
                for (String expression : expressions) {
                    Object value = EvaluatorHandle.this.evaluator.evaluate(expression);
                    if (value != null) {
                        String expressionOverride = parent == null ? expression : "." + expression;
                        DataItem dataItem = customDataProvider.makeDataItem(value, expressionOverride);
                        results.add((DebuggeeData)new DebuggeeDataInfo(parent, dataItem, this, customDataProvider).new DebuggeeDataInfo.DebuggeeDataInfoVersion12());
                        continue;
                    }
                    results.add(null);
                }
                if (restoreContext) {
                    EvaluatorHandle.this.evaluator.setDebugContext(EvaluatorHandle.this.evaluator.getEvaluatorContext().getVM(), thread, frame);
                }
                if (JDebugger.logger.isEnabled()) {
                    long totalTime = System.currentTimeMillis() - milliTime;
                    StringBuilder buf = new StringBuilder();
                    buf.append("Debugger Extender Evaluation in ");
                    buf.append(totalTime);
                    buf.append(" msecs\n");
                    JDebugger.logger.trace(buf.toString());
                }
                return results;
            }
            return null;
        }

        public synchronized DebuggerEvaluator getEvaluator(int stackFrame) {
            List stackFrames;
            if (!EvaluatorHandle.this.expired && stackFrame < (stackFrames = EvaluatorHandle.this.getDebugStackFrameInfos()).size()) {
                EvaluatorProxy newEvaluator = DebugObjectFactory.create(EvaluatorProxy.class);
                newEvaluator.setAllowMethodInvocation(true);
                newEvaluator.setDebugContext(EvaluatorHandle.this.evaluator.getEvaluatorContext().getVM(), EvaluatorHandle.this.evaluator.getEvaluatorContext().getThread(), (DebugStackFrameInfo)stackFrames.get(stackFrame));
                return new EvaluatorHandle(newEvaluator, EvaluatorHandle.this.debuggingProcess, EvaluatorHandle.this.customDataProvider).new EvaluatorHandleVersion12();
            }
            return null;
        }

        public synchronized DebuggerEvaluator getEvaluator(DebuggerThread thread) {
            if (!EvaluatorHandle.this.expired) {
                DebugThreadInfo[] currentThreads = EvaluatorHandle.this.getDebugThreadInfos();
                DebugThreadInfo found = null;
                for (DebugThreadInfo currentThread : currentThreads) {
                    if (!thread.getName().equals(currentThread.getName())) continue;
                    found = currentThread;
                    break;
                }
                if (found != null) {
                    EvaluatorProxy newEvaluator = DebugObjectFactory.create(EvaluatorProxy.class);
                    newEvaluator.setAllowMethodInvocation(true);
                    newEvaluator.setDebugContext(EvaluatorHandle.this.evaluator.getEvaluatorContext().getVM(), found, EvaluatorHandle.this.evaluator.getEvaluatorContext().getFrame());
                    return new EvaluatorHandle(newEvaluator, EvaluatorHandle.this.debuggingProcess, EvaluatorHandle.this.customDataProvider).new EvaluatorHandleVersion12();
                }
            }
            return null;
        }

        public synchronized List<DebuggerThread> getAllThreads() {
            if (!EvaluatorHandle.this.expired && EvaluatorHandle.this.evaluator.getEvaluatorContext().getVM() != null) {
                DebugThreadInfo[] threads = EvaluatorHandle.this.evaluator.getEvaluatorContext().getVM().listThreads();
                ArrayList<DebuggerThread> threadList = new ArrayList<DebuggerThread>(threads.length);
                for (DebugThreadInfo thread : threads) {
                    String name = thread.getName();
                    if (name.length() <= 0) continue;
                    threadList.add((DebuggerThread)new ThreadHandle(name));
                }
                return threadList;
            }
            return null;
        }
    }

    public class EvaluatorHandleVersion13
    extends EvaluatorHandle
    implements DebuggerExtenderEvaluator {
        public EvaluatorHandleVersion13() {
            super(EvaluatorHandle.this.evaluator, EvaluatorHandle.this.debuggingProcess, EvaluatorHandle.this.customDataProvider);
        }

        public synchronized DebuggerExtenderThread getThread() {
            if (!EvaluatorHandle.this.expired && EvaluatorHandle.this.evaluator.getEvaluatorContext().getThread() != null) {
                return (DebuggerExtenderThread)new ThreadHandle(EvaluatorHandle.this.evaluator.getEvaluatorContext().getThread().getName());
            }
            return null;
        }

        public synchronized DebuggerExtenderData evaluate(String expression, DebuggerExtenderData context) {
            ArrayList<String> expressions = new ArrayList<String>(1);
            expressions.add(expression);
            List<DebuggerExtenderData> result = this.evaluate(expressions, context);
            return result == null ? null : result.get(0);
        }

        public synchronized List<DebuggerExtenderData> evaluate(List<String> expressions, DebuggerExtenderData context) {
            CustomDataProvider customDataProvider = EvaluatorHandle.this.getCustomDataProvider();
            if (!EvaluatorHandle.this.expired) {
                Object info;
                if (JDebugger.logger.isEnabled()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Strings to evaluate:\n");
                    for (String expression : expressions) {
                        buf.append(expression);
                        buf.append('\n');
                    }
                    JDebugger.logger.trace(buf.toString());
                }
                long milliTime = System.currentTimeMillis();
                DebugThreadInfo thread = EvaluatorHandle.this.evaluator.getEvaluatorContext().getThread();
                DebugStackFrameInfo frame = EvaluatorHandle.this.evaluator.getEvaluatorContext().getFrame();
                DebuggeeDataInfo.DebuggeeDataInfoVersion13 parent = null;
                boolean restoreContext = false;
                if (context instanceof DebuggeeDataInfo.DebuggeeDataInfoVersion13 && (info = ((DebuggeeDataInfo)context).getDataInfo()) instanceof DebugDataObjectInfo) {
                    EvaluatorHandle.this.evaluator.setDebugContext((DebugDataObjectInfo)info);
                    restoreContext = true;
                    parent = (DebuggeeDataInfo.DebuggeeDataInfoVersion13)context;
                }
                ArrayList<DebuggerExtenderData> results = new ArrayList<DebuggerExtenderData>();
                for (String expression : expressions) {
                    Object value = EvaluatorHandle.this.evaluator.evaluate(expression);
                    if (value != null) {
                        String expressionOverride = parent == null ? expression : "." + expression;
                        DataItem dataItem = customDataProvider.makeDataItem(value, expressionOverride);
                        results.add(new DebuggeeDataInfo(parent, dataItem, this, customDataProvider).new DebuggeeDataInfo.DebuggeeDataInfoVersion13());
                        continue;
                    }
                    results.add(null);
                }
                if (restoreContext) {
                    EvaluatorHandle.this.evaluator.setDebugContext(EvaluatorHandle.this.evaluator.getEvaluatorContext().getVM(), thread, frame);
                }
                if (JDebugger.logger.isEnabled()) {
                    long totalTime = System.currentTimeMillis() - milliTime;
                    StringBuilder buf = new StringBuilder();
                    buf.append("Debugger Extender Evaluation in ");
                    buf.append(totalTime);
                    buf.append(" msecs\n");
                    JDebugger.logger.trace(buf.toString());
                }
                return results;
            }
            return null;
        }

        public synchronized DebuggerExtenderEvaluator getEvaluator(int stackFrame) {
            List stackFrames;
            if (!EvaluatorHandle.this.expired && stackFrame < (stackFrames = EvaluatorHandle.this.getDebugStackFrameInfos()).size()) {
                EvaluatorProxy newEvaluator = DebugObjectFactory.create(EvaluatorProxy.class);
                newEvaluator.setAllowMethodInvocation(true);
                newEvaluator.setDebugContext(EvaluatorHandle.this.evaluator.getEvaluatorContext().getVM(), EvaluatorHandle.this.evaluator.getEvaluatorContext().getThread(), (DebugStackFrameInfo)stackFrames.get(stackFrame));
                return new EvaluatorHandle(newEvaluator, EvaluatorHandle.this.debuggingProcess, EvaluatorHandle.this.customDataProvider).new EvaluatorHandleVersion13();
            }
            return null;
        }

        public synchronized DebuggerExtenderEvaluator getEvaluator(DebuggerExtenderThread thread) {
            if (!EvaluatorHandle.this.expired) {
                DebugThreadInfo[] currentThreads = EvaluatorHandle.this.getDebugThreadInfos();
                DebugThreadInfo found = null;
                for (DebugThreadInfo currentThread : currentThreads) {
                    if (!thread.getName().equals(currentThread.getName())) continue;
                    found = currentThread;
                    break;
                }
                if (found != null) {
                    EvaluatorProxy newEvaluator = DebugObjectFactory.create(EvaluatorProxy.class);
                    newEvaluator.setAllowMethodInvocation(true);
                    newEvaluator.setDebugContext(EvaluatorHandle.this.evaluator.getEvaluatorContext().getVM(), found, EvaluatorHandle.this.evaluator.getEvaluatorContext().getFrame());
                    return new EvaluatorHandle(newEvaluator, EvaluatorHandle.this.debuggingProcess, EvaluatorHandle.this.customDataProvider).new EvaluatorHandleVersion13();
                }
            }
            return null;
        }

        public synchronized List<DebuggerExtenderThread> getAllThreads() {
            if (!EvaluatorHandle.this.expired && EvaluatorHandle.this.evaluator.getEvaluatorContext().getVM() != null) {
                DebugThreadInfo[] threads = EvaluatorHandle.this.evaluator.getEvaluatorContext().getVM().listThreads();
                ArrayList<DebuggerExtenderThread> threadList = new ArrayList<DebuggerExtenderThread>(threads.length);
                for (DebugThreadInfo thread : threads) {
                    String name = thread.getName();
                    if (name.length() <= 0) continue;
                    threadList.add((DebuggerExtenderThread)new ThreadHandle(name));
                }
                return threadList;
            }
            return null;
        }
    }
}

