/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.debugger;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.PackagedSourceNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.Beta;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.plugin.CommonHelperFunctions;
import oracle.jdevimpl.debugger.res.DebugProcessArb;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.xml.JDevXmlIntegrationUtils;

@Beta
public abstract class JDebugProcess
extends JRunProcess {
    protected String localPort;
    protected int localDebuggingFactory = -1;
    protected boolean xsltDebugging = false;

    public JDebugProcess(Context context) {
        super(context);
    }

    public JDebugProcess() {
    }

    public String getProcessLabelPrefix() {
        return this.labelPrefixOverride != null ? this.labelPrefixOverride : DebugProcessArb.getString(0);
    }

    public String getLocalPort() {
        if (this.localPort == null) {
            DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
            if (dbgSettings.isLocalPortRange()) {
                int min = dbgSettings.getLocalPortRangeMin();
                int max = dbgSettings.getLocalPortRangeMax();
                this.localPort = Integer.toString(CommonHelperFunctions.getLocalPort(min, max));
            } else {
                this.localPort = Integer.toString(CommonHelperFunctions.getLocalPort());
            }
        }
        return this.localPort;
    }

    public boolean setLocalDebuggingProtocol(String protocol) {
        int cookie = DebugFactory.getDebugConnectorCookie(protocol);
        if (cookie >= 0) {
            this.localDebuggingFactory = cookie;
            return true;
        }
        return false;
    }

    protected String[] packageAndFileOfNode(Node node) {
        try {
            String pkg = null;
            String file = null;
            if (JDevXmlIntegrationUtils.getInstance().isXmlSource(node)) {
                URL url = node.getURL();
                if (this.xsltDebugging) {
                    pkg = CommonHelperFunctions.getXSLTPackage(url);
                    file = URLFileSystem.getFileName((URL)url);
                }
            } else if (node instanceof PackagedSourceNode) {
                pkg = Source.getPackageFromNode(node, this.getJProject());
                file = Source.getFilenameFromNode(node);
            }
            if (pkg != null && file != null && file.length() > 0) {
                String[] packageAndFile = new String[]{pkg, file};
                return packageAndFile;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

