/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import oracle.ide.osgi.Platform;
import oracle.ide.osgi.extension.BundleRegistry;
import org.osgi.framework.Bundle;

public class Diagnostics {
    private Diagnostics() {
    }

    private static Map<Bundle, ArrayList<Bundle>> requireBundleMap() {
        HashMap<Bundle, ArrayList<Bundle>> requireBundleMap = new HashMap<Bundle, ArrayList<Bundle>>();
        BundleRegistry registry = Platform.getBundleRegistry();
        for (Bundle nextBundle : registry.getBundles()) {
            String[] rqBndls;
            String reqBundles = (String)nextBundle.getHeaders().get("Require-Bundle");
            if (reqBundles == null) continue;
            if (!requireBundleMap.containsKey(nextBundle)) {
                requireBundleMap.put(nextBundle, new ArrayList());
            }
            for (String rqBndlName : rqBndls = reqBundles.split(",")) {
                Bundle rqBndl = registry.findBundle(rqBndlName);
                if (rqBndl == null) continue;
                ((ArrayList)requireBundleMap.get(nextBundle)).add(rqBndl);
            }
        }
        return requireBundleMap;
    }

    private static Map<Bundle, Collection<File>> bundleClassPathMap() {
        HashMap<Bundle, Collection<File>> bundle2Jars = new HashMap<Bundle, Collection<File>>();
        BundleRegistry registry = Platform.getBundleRegistry();
        for (Bundle bundle : registry.getBundles()) {
            String[] bcps;
            String bundleClassPath = (String)bundle.getHeaders().get("Bundle-ClassPath");
            if (bundleClassPath == null || !bundleClassPath.contains("external:$")) continue;
            for (String bcp : bcps = bundleClassPath.split(",")) {
                if (".".equals(bcp) || !bcp.startsWith("external:$")) continue;
                int lastDollarSignIndex = bcp.lastIndexOf("$");
                String sysProp = bcp.substring("external:$".length(), lastDollarSignIndex);
                String propValue = System.getProperty(sysProp);
                if (propValue == null) continue;
                File expandedBCP = new File(bcp.replace("external:$" + sysProp + "$", propValue));
                if (!bundle2Jars.containsKey(bundle)) {
                    bundle2Jars.put(bundle, new ArrayList());
                }
                ((Collection)bundle2Jars.get(bundle)).add(expandedBCP);
            }
        }
        return bundle2Jars;
    }

    public static List<Violation> verifyClassSpace(Bundle bundle) {
        ArrayList<Violation> violators = new ArrayList<Violation>();
        Map<Bundle, ArrayList<Bundle>> requireBundleMap = Diagnostics.requireBundleMap();
        Map<Bundle, Collection<File>> bundleClasspathMap = Diagnostics.bundleClassPathMap();
        HashMap jar2PathsToReachIt = new HashMap();
        Stack<BundleAndPathPair> stack = new Stack<BundleAndPathPair>();
        stack.push(new BundleAndPathPair(bundle, Collections.singletonList(bundle)));
        HashSet<Bundle> visited = new HashSet<Bundle>();
        while (!stack.isEmpty()) {
            BundleAndPathPair nextPair = (BundleAndPathPair)stack.pop();
            if (bundleClasspathMap.containsKey(nextPair.bundle)) {
                for (File file : bundleClasspathMap.get(nextPair.bundle)) {
                    if (!jar2PathsToReachIt.containsKey(file)) {
                        jar2PathsToReachIt.put(file, new ArrayList());
                        ((List)jar2PathsToReachIt.get(file)).add(nextPair.path);
                        continue;
                    }
                    boolean isContainedAlready = false;
                    ArrayList copyArrList = new ArrayList((Collection)jar2PathsToReachIt.get(file));
                    for (List path : copyArrList) {
                        Bundle lastBundle = (Bundle)path.get(path.size() - 1);
                        if (lastBundle.equals(nextPair.bundle)) {
                            isContainedAlready = true;
                            break;
                        }
                        if (requireBundleMap.get(lastBundle) != null && requireBundleMap.get(lastBundle).contains(nextPair.bundle)) {
                            ((List)jar2PathsToReachIt.get(file)).remove(path);
                            ((List)jar2PathsToReachIt.get(file)).add(nextPair.path);
                            isContainedAlready = true;
                            break;
                        }
                        if (requireBundleMap.get(nextPair.bundle) == null || !requireBundleMap.get(nextPair.bundle).contains(lastBundle)) continue;
                        isContainedAlready = true;
                        break;
                    }
                    if (isContainedAlready) continue;
                    ((List)jar2PathsToReachIt.get(file)).add(nextPair.path);
                }
            }
            visited.add(nextPair.bundle);
            if (!requireBundleMap.containsKey(nextPair.bundle)) continue;
            visited.add(nextPair.bundle);
            for (Bundle rqBundle : requireBundleMap.get(nextPair.bundle)) {
                if (visited.contains(rqBundle)) continue;
                ArrayList<Bundle> path = new ArrayList<Bundle>(nextPair.path);
                path.add(rqBundle);
                stack.push(new BundleAndPathPair(rqBundle, path));
            }
        }
        for (File file : jar2PathsToReachIt.keySet()) {
            List paths = (List)jar2PathsToReachIt.get(file);
            if (paths.size() <= 1) continue;
            violators.add(new ClassSpacePathViolation(bundle, file, (List)jar2PathsToReachIt.get(file)));
        }
        return violators;
    }

    public static Collection<BundleInfo> allBundlesThatContain(String path) {
        ArrayList<BundleInfo> bundleInfos = new ArrayList<BundleInfo>();
        HashMap<File, Collection<Bundle>> jar2BundlesSupplyingIt = new HashMap<File, Collection<Bundle>>();
        Diagnostics.computeBundle2JarMaps(jar2BundlesSupplyingIt, new HashMap<String, Collection<File>>(), new ArrayList<Violation>());
        int[] bucketIndexTable = Diagnostics.computeBucketIndexTable(jar2BundlesSupplyingIt);
        for (File file : jar2BundlesSupplyingIt.keySet()) {
            if (!file.getAbsolutePath().endsWith(path)) continue;
            ArrayList<BundleInfo> subBundleInfos = new ArrayList<BundleInfo>();
            for (Bundle bundle : (Collection)jar2BundlesSupplyingIt.get(file)) {
                if (subBundleInfos.size() == 0) {
                    subBundleInfos.add(new BundleInfo(bundle, bucketIndexTable[(int)bundle.getBundleId()], file));
                    continue;
                }
                boolean isDependedOn = false;
                ArrayList<BundleInfo> biToRemove = new ArrayList<BundleInfo>();
                for (BundleInfo bi : subBundleInfos) {
                    if (Diagnostics.isDependentOn(bundle, bi.bundle)) {
                        isDependedOn = true;
                        continue;
                    }
                    if (!Diagnostics.isDependentOn(bi.bundle, bundle)) continue;
                    biToRemove.add(bi);
                }
                subBundleInfos.removeAll(biToRemove);
                if (isDependedOn) continue;
                subBundleInfos.add(new BundleInfo(bundle, bucketIndexTable[(int)bundle.getBundleId()], file));
            }
            bundleInfos.addAll(subBundleInfos);
        }
        return bundleInfos;
    }

    private static int[] computeBucketIndexTable(Map<File, Collection<Bundle>> jar2BundlesSupplyingIt) {
        int[] bucketIndices = new int[Platform.getBundleRegistry().getBundles().size()];
        for (File file : jar2BundlesSupplyingIt.keySet()) {
            Collection<Bundle> bundles = jar2BundlesSupplyingIt.get(file);
            if (bundles.size() == 1) continue;
            for (Bundle b : bundles) {
                int n = (int)b.getBundleId();
                bucketIndices[n] = bucketIndices[n] + 1;
            }
        }
        return bucketIndices;
    }

    private static void computeBundle2JarMaps(Map<File, Collection<Bundle>> jar2BundlesSupplyingIt, Map<String, Collection<File>> bundleName2Jars, Collection<Violation> violations) {
        BundleRegistry registry = Platform.getBundleRegistry();
        for (Bundle bundle : registry.getBundles()) {
            String[] bcps;
            String bundleClassPath = (String)bundle.getHeaders().get("Bundle-ClassPath");
            if (bundleClassPath == null || !bundleClassPath.contains("external:$")) continue;
            for (String bcp : bcps = bundleClassPath.split(",")) {
                if (".".equals(bcp) || !bcp.startsWith("external:$")) continue;
                int lastDollarSignIndex = bcp.lastIndexOf("$");
                String sysProp = bcp.substring("external:$".length(), lastDollarSignIndex);
                String propValue = System.getProperty(sysProp);
                if (propValue == null) continue;
                File expandedBCP = new File(bcp.replace("external:$" + sysProp + "$", propValue));
                if (!expandedBCP.exists()) {
                    violations.add(new JarMissingViolation(expandedBCP, bundle));
                }
                if (!jar2BundlesSupplyingIt.containsKey(expandedBCP)) {
                    jar2BundlesSupplyingIt.put(expandedBCP, new ArrayList());
                }
                if (!jar2BundlesSupplyingIt.get(expandedBCP).contains(bundle)) {
                    jar2BundlesSupplyingIt.get(expandedBCP).add(bundle);
                } else {
                    violations.add(new RedundancyViolation(expandedBCP, bundle));
                }
                if (!bundleName2Jars.containsKey(bundle.getSymbolicName())) {
                    bundleName2Jars.put(bundle.getSymbolicName(), new ArrayList());
                }
                bundleName2Jars.get(bundle.getSymbolicName()).add(expandedBCP);
            }
        }
    }

    public static Collection<Violation> verifyClassPath() {
        HashMap<File, Collection<Bundle>> jar2BundlesSupplyingIt = new HashMap<File, Collection<Bundle>>();
        HashMap<String, Collection<File>> bundleName2Jars = new HashMap<String, Collection<File>>();
        ArrayList<Violation> violations = new ArrayList<Violation>();
        Diagnostics.computeBundle2JarMaps(jar2BundlesSupplyingIt, bundleName2Jars, violations);
        for (Object file : jar2BundlesSupplyingIt.keySet()) {
            Collection bundles = (Collection)jar2BundlesSupplyingIt.get(file);
            if (bundles.size() == 1) continue;
            for (Object subsetBundle : bundles) {
                Object nextFile2;
                Collection allJarsOfSubsetBundle = (Collection)bundleName2Jars.get(subsetBundle.getSymbolicName());
                ArrayList<Bundle> potentialSupersetBundles = new ArrayList<Bundle>((Collection)jar2BundlesSupplyingIt.get(file));
                potentialSupersetBundles.remove(subsetBundle);
                for (Object nextFile2 : allJarsOfSubsetBundle) {
                    if (!((File)nextFile2).equals(file)) {
                        ArrayList bundlesSupplyingTheNextFile = new ArrayList((Collection)jar2BundlesSupplyingIt.get(nextFile2));
                        for (Bundle b : (Collection)jar2BundlesSupplyingIt.get(file)) {
                            if (bundlesSupplyingTheNextFile.contains(b)) continue;
                            potentialSupersetBundles.remove(b);
                            if (potentialSupersetBundles.size() != 0) continue;
                            break;
                        }
                    }
                    if (potentialSupersetBundles.size() != 0) continue;
                    break;
                }
                if (potentialSupersetBundles.size() <= 0) continue;
                boolean isViolation = true;
                nextFile2 = potentialSupersetBundles.iterator();
                while (nextFile2.hasNext()) {
                    Bundle potentialSupersetBundle = (Bundle)nextFile2.next();
                    if (!Diagnostics.isDependentOn(potentialSupersetBundle, (Bundle)subsetBundle)) continue;
                    isViolation = false;
                    break;
                }
                if (!isViolation) continue;
                boolean isAlreadyIn = false;
                for (Violation violator : violations) {
                    if (!(violator instanceof SupersetViolation) || !((SupersetViolation)violator).getSubsetBundle().equals(subsetBundle)) continue;
                    isAlreadyIn = true;
                    break;
                }
                if (isAlreadyIn) continue;
                violations.add(new SupersetViolation((Collection)bundleName2Jars.get(subsetBundle.getSymbolicName()), (Bundle)subsetBundle, potentialSupersetBundles));
            }
        }
        int[] bucketIndices = new int[Platform.getBundleRegistry().getBundles().size()];
        for (File file : jar2BundlesSupplyingIt.keySet()) {
            Collection bundles = (Collection)jar2BundlesSupplyingIt.get(file);
            if (bundles.size() == 1) continue;
            for (Bundle b : bundles) {
                int n = (int)b.getBundleId();
                bucketIndices[n] = bucketIndices[n] + 1;
            }
        }
        Map<Bundle, ArrayList<Bundle>> requiredBundleMap = Diagnostics.requireBundleMap();
        ArrayList<IntersectingBCPViolation> intersectingViolations = new ArrayList<IntersectingBCPViolation>();
        for (File file : jar2BundlesSupplyingIt.keySet()) {
            Collection bundles = (Collection)jar2BundlesSupplyingIt.get(file);
            if (bundles.size() == 1) continue;
            ArrayList copyOfBundles = new ArrayList((Collection)jar2BundlesSupplyingIt.get(file));
            block9: for (int i = 0; i < copyOfBundles.size(); ++i) {
                Bundle bundleI = (Bundle)copyOfBundles.get(i);
                Collection filesI = (Collection)bundleName2Jars.get(bundleI.getSymbolicName());
                for (int j = i + 1; j < copyOfBundles.size(); ++j) {
                    Bundle bundleJ = (Bundle)copyOfBundles.get(j);
                    Collection filesJ = (Collection)bundleName2Jars.get(bundleJ.getSymbolicName());
                    if (Diagnostics.isDependentOn(bundleI, bundleJ) || Diagnostics.isDependentOn(bundleJ, bundleI)) continue;
                    boolean isAlreadyIncluded = false;
                    for (IntersectingBCPViolation iv : intersectingViolations) {
                        if ((!iv.bundleA.equals(bundleI) || !iv.bundleB.equals(bundleJ)) && (!iv.bundleB.equals(bundleI) || !iv.bundleA.equals(bundleJ))) continue;
                        isAlreadyIncluded = true;
                        break;
                    }
                    if (isAlreadyIncluded) continue block9;
                    ArrayList<File> duplicatedJars = new ArrayList<File>();
                    if (!Diagnostics.commonDependencyProvidesFile(file, requiredBundleMap.get(bundleI), requiredBundleMap.get(bundleJ), bundleName2Jars)) {
                        duplicatedJars.add(file);
                        for (File iFile : filesI) {
                            if (!filesJ.contains(iFile) || duplicatedJars.contains(iFile) || Diagnostics.commonDependencyProvidesFile(iFile, requiredBundleMap.get(bundleI), requiredBundleMap.get(bundleJ), bundleName2Jars)) continue;
                            duplicatedJars.add(iFile);
                        }
                    }
                    if (duplicatedJars.size() <= 0) continue;
                    intersectingViolations.add(new IntersectingBCPViolation(duplicatedJars, bundleI, bundleJ, bucketIndices[(int)bundleI.getBundleId()], bucketIndices[(int)bundleJ.getBundleId()]));
                }
            }
        }
        violations.addAll(intersectingViolations);
        return violations;
    }

    private static boolean commonDependencyProvidesFile(File file, ArrayList<Bundle> reqBundlesOfI, ArrayList<Bundle> reqBundlesOfJ, Map<String, Collection<File>> bundleName2Jars) {
        if (reqBundlesOfI != null && reqBundlesOfJ != null) {
            for (Bundle rbI : reqBundlesOfI) {
                if (bundleName2Jars.get(rbI.getSymbolicName()) == null || !bundleName2Jars.get(rbI.getSymbolicName()).contains(file) || !reqBundlesOfJ.contains(rbI)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isDependentOn(Bundle bundle, Bundle subsetBundle) {
        String deps = (String)bundle.getHeaders().get("Require-Bundle");
        if (deps != null) {
            List<String> dependencies = Arrays.asList(deps.split(","));
            return dependencies.contains(subsetBundle.getSymbolicName());
        }
        return false;
    }

    public static class BundleInfo {
        private final Bundle bundle;
        private final int bucketIndex;
        private final File file;

        BundleInfo(Bundle bundle, int bucketIndex, File file) {
            this.bundle = bundle;
            this.bucketIndex = bucketIndex;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public int getBucketIndex() {
            return this.bucketIndex;
        }

        public String toString() {
            return this.file + " contained in bundle " + this.bundle + " , which has a bucket index of " + this.bucketIndex;
        }
    }

    private static class BundleAndPathPair {
        private final Bundle bundle;
        private final List<Bundle> path;

        BundleAndPathPair(Bundle bundle, List<Bundle> path) {
            this.bundle = bundle;
            this.path = path;
        }
    }

    public static class IntersectingBCPViolation
    implements Violation {
        private final Collection<File> duplicatedFiles;
        private final Bundle bundleA;
        private final Bundle bundleB;
        private final int indexA;
        private final int indexB;

        IntersectingBCPViolation(Collection<File> duplicatedFiles, Bundle bundleA, Bundle bundleB, int indexA, int indexB) {
            this.duplicatedFiles = duplicatedFiles;
            this.bundleA = bundleA;
            this.bundleB = bundleB;
            this.indexA = indexA;
            this.indexB = indexB;
        }

        public String toString() {
            return this.displayString();
        }

        @Override
        public String displayString() {
            return "Bundle classpath of " + this.bundleA + " with bucket index " + this.indexA + " and " + this.bundleB + " with bucket index " + this.indexB + " contained jar" + (this.duplicatedFiles.size() > 1 ? "s" : "") + " : " + this.duplicatedFiles + ". These jars will be loaded twice on the classpath. High bucket index means lower module coupling within " + "the bundle, so one option is to make the module with the higher BI depend on the one with the lower BI" + (this.indexA != this.indexB ? ": " + (this.indexA > this.indexB ? this.bundleA + " > " + this.bundleB : this.bundleB + " > " + this.bundleA) + "" : "") + ". If the bucket indices are about equal or neither of the two is more modular than the other, consider splitting" + " the intersection out into its own bundle.";
        }
    }

    public static class SupersetViolation
    implements Violation {
        private final Collection<File> duplicatedFiles;
        private final Bundle subsetBundle;
        private final Collection<Bundle> supersetBundles;

        SupersetViolation(Collection<File> duplicatedFiles, Bundle subsetBundle, Collection<Bundle> supersetBundles) {
            this.duplicatedFiles = duplicatedFiles;
            this.subsetBundle = subsetBundle;
            this.supersetBundles = supersetBundles;
        }

        public Collection<File> getDuplicatedFiles() {
            return this.duplicatedFiles;
        }

        public Bundle getSubsetBundle() {
            return this.subsetBundle;
        }

        public Collection<Bundle> getSupersetBundles() {
            return this.supersetBundles;
        }

        public String toString() {
            return this.displayString();
        }

        @Override
        public String displayString() {
            return "Bundle classpath of " + this.subsetBundle + " contained jar" + (this.duplicatedFiles.size() > 1 ? "s" : "") + " : " + this.duplicatedFiles + ". The following bundles contained these jars also on the bundle classpath, " + this.supersetBundles + ", except they contained other jars too. These latter bundles should depend on " + this.subsetBundle + " instead, and optionaly remove the jars from their own bundle classpath, so the jar " + "gets classloaded just once, by the smaller, 'subset' bundle.";
        }
    }

    public static class RedundancyViolation
    implements Violation {
        private final File duplicatedFile;
        private final Bundle bundle;

        RedundancyViolation(File duplicatedFile, Bundle bundle) {
            this.duplicatedFile = duplicatedFile;
            this.bundle = bundle;
        }

        public String toString() {
            return this.displayString();
        }

        @Override
        public String displayString() {
            return "Jars " + this.duplicatedFile.toString() + " is listed in bundle " + this.bundle + " more than once.";
        }
    }

    public static class JarMissingViolation
    implements Violation {
        private final File missingFile;
        private final Bundle bundle;

        public JarMissingViolation(File missingFile, Bundle bundle) {
            this.missingFile = missingFile;
            this.bundle = bundle;
        }

        @Override
        public String displayString() {
            return "Bundle " + this.bundle + " referenced a file that was missing on disk: " + this.missingFile + " ";
        }

        public File getMissingFile() {
            return this.missingFile;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public String toString() {
            return this.displayString();
        }
    }

    public static class ClassSpacePathViolation
    implements Violation {
        private final File dupedFile;
        private final Bundle bundle;
        private final List<List<Bundle>> paths;

        ClassSpacePathViolation(Bundle bundle, File dupedFile, List<List<Bundle>> paths) {
            this.bundle = bundle;
            this.dupedFile = dupedFile;
            this.paths = paths;
        }

        @Override
        public String displayString() {
            StringBuilder result = new StringBuilder();
            result.append("Bundle " + this.bundle + " can load jar " + this.dupedFile + " in its class space potentially more than once: \n");
            for (int i = 0; i < this.paths.size(); ++i) {
                result.append("Path ").append(i + 1).append(": ");
                List<Bundle> path = this.paths.get(i);
                for (Bundle b : path) {
                    result.append(b).append(" > ");
                }
                result.append(this.dupedFile).append("\n");
            }
            return result.toString();
        }
    }

    public static interface Violation {
        public String displayString();
    }

    static enum VerifyType {
        duplicatedJars,
        consistentClassSpace;

    }
}

