/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.io.StringReader;
import java.util.List;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.syntax.BinaryOperatorCondition;
import oracle.olapi.syntax.BinaryOperatorExpression;
import oracle.olapi.syntax.NotCondition;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxOperatorPrecedence;
import oracle.olapi.syntax.UnaryOperatorExpression;
import oracle.olapi.syntax.parser.ExpParserTokenManager;
import oracle.olapi.syntax.parser.Identifier;
import oracle.olapi.syntax.parser.IdentifierResolver;
import oracle.olapi.syntax.parser.Token;

public final class SyntaxPrintingContext {
    static final int UNCHANGED_PRECEDENCE = -1;
    static final int DEFAULT_PRECEDENCE = 0;
    static final int OR_PRECEDENCE = 1;
    static final int AND_PRECEDENCE = 2;
    static final int PLUS_PRECEDENCE = 3;
    static final int TIMES_PRECEDENCE = 4;
    static final int UNARY_PRECEDENCE = 5;
    static final int POWER_PRECEDENCE = 6;
    private StringBuffer m_Buffer = new StringBuffer();
    private int m_Indent = 0;
    private SyntaxOperatorPrecedence m_CurrPrecedence = null;
    private List<Query> m_Queries = null;
    private String m_Owner = null;
    private ExpParserTokenManager m_scanner = null;
    private boolean m_SuppressNamespace = false;
    private MetadataToXMLConverter m_XMLWriter = null;

    private StringBuffer getBuffer() {
        return this.m_Buffer;
    }

    private int getIndent() {
        return this.m_Indent;
    }

    private SyntaxOperatorPrecedence getPrecedence() {
        return this.m_CurrPrecedence;
    }

    private void setPrecedence(SyntaxOperatorPrecedence syntaxOperatorPrecedence) {
        this.m_CurrPrecedence = syntaxOperatorPrecedence;
    }

    SyntaxOperatorPrecedence getObjectPrecedence(SyntaxObject syntaxObject) {
        Object object;
        int n = 0;
        boolean bl = true;
        if (syntaxObject instanceof BinaryOperatorExpression) {
            object = ((BinaryOperatorExpression)syntaxObject).getOperator();
            if ("-" == object || "/" == object) {
                bl = false;
            }
            if ("*" == object || "/" == object) {
                n = 4;
            } else {
                if ("-" != object && "+" != object && "||" != object) {
                    throw new SyntaxException("BadBinaryOperator", (String)object);
                }
                n = 3;
            }
        } else if (syntaxObject instanceof UnaryOperatorExpression) {
            n = 5;
        } else if (syntaxObject instanceof BinaryOperatorCondition) {
            object = ((BinaryOperatorCondition)syntaxObject).getOperator();
            if ("AND" == object) {
                n = 2;
            } else {
                if ("OR" != object) {
                    throw new SyntaxException("BadBinaryOperator", (String)object);
                }
                n = 1;
            }
        } else if (syntaxObject instanceof NotCondition) {
            n = 5;
        }
        object = new SyntaxOperatorPrecedence(n, bl);
        return object;
    }

    SyntaxPrintingContext(StringBuffer stringBuffer, String string, List<Query> list) {
        this.m_Buffer = stringBuffer;
        this.m_Owner = string;
        this.m_Queries = list;
    }

    boolean suppressNamespace() {
        return this.m_SuppressNamespace;
    }

    void suppressNamespace(boolean bl) {
        this.m_SuppressNamespace = bl;
    }

    MetadataToXMLConverter getXMLWriter() {
        return this.m_XMLWriter;
    }

    void setXMLWriter(MetadataToXMLConverter metadataToXMLConverter) {
        this.m_XMLWriter = metadataToXMLConverter;
    }

    void append(String string) {
        this.getBuffer().append(string);
    }

    void appendQuotedString(String string) {
        char c = '\'';
        this.append(c);
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                this.append(c2);
            }
            this.append(c2);
        }
        this.append(c);
    }

    void append(Number number) {
        this.getBuffer().append(number);
    }

    void append(char c) {
        this.getBuffer().append(c);
    }

    void append(int n) {
        this.getBuffer().append(n);
    }

    private boolean isValidUnquotedIdentifierChar(char c, boolean bl) {
        return c >= 'A' && c <= 'Z' || c == '_' || c == '$' || c == '#' || !bl && c >= '0' && c <= '9';
    }

    void appendIdentifier(String string) {
        Identifier identifier = Identifier.parseID(string);
        Identifier identifier2 = null;
        if (null != this.getXMLWriter()) {
            identifier2 = this.getXMLWriter().getRenamedIDFromXMLID(identifier);
        }
        if (null != identifier2) {
            identifier = identifier2;
        }
        boolean bl = null == this.getOwner();
        int n = identifier.getNumComponents();
        String string2 = "..";
        int n2 = 0;
        if (identifier.hasNamespace()) {
            ++n2;
            if (!this.suppressNamespace()) {
                this.appendIdentifierComponent(identifier.getNamespace(), false, false, true);
                this.append(string2);
            }
        }
        boolean bl2 = true;
        int n3 = -1;
        while (n2 < n) {
            String string3 = identifier.getComponent(n2);
            if (++n3 != 0 || bl || !string3.equalsIgnoreCase(this.getOwner())) {
                boolean bl3 = false;
                for (int i = 0; i < string3.length(); ++i) {
                    boolean bl4;
                    char c = string3.charAt(i);
                    boolean bl5 = bl4 = i == 0;
                    if (this.isValidUnquotedIdentifierChar(c, bl4)) continue;
                    bl3 = true;
                    break;
                }
                this.appendIdentifierComponent(string3, !bl2, bl3, true);
                bl2 = false;
            }
            ++n2;
        }
    }

    void appendIdentifierComponent(String string, boolean bl) {
        this.appendIdentifierComponent(string, false, false, bl);
    }

    private void appendIdentifierComponent(String string, boolean bl, boolean bl2, boolean bl3) {
        char c = '\"';
        if (bl) {
            this.append(".");
        }
        if (!bl2 && bl3 && this.isKeyword(string)) {
            bl2 = true;
        }
        if (string.length() >= 2 && c == string.charAt(0) && c == string.charAt(string.length() - 1)) {
            bl2 = false;
        }
        if (bl2) {
            this.append(c);
        }
        this.append(string);
        if (bl2) {
            this.append(c);
        }
    }

    boolean isKeyword(String string) {
        Object object;
        boolean bl = false;
        if (string.length() == 0) {
            return false;
        }
        if (null == this.m_scanner) {
            object = new IdentifierResolver(this.getOwner(), null, null, null);
            this.m_scanner = new ExpParserTokenManager(new StringReader(string), (IdentifierResolver)object, false);
        } else {
            this.m_scanner.ReInit(new StringReader(string));
        }
        object = this.m_scanner.getNextToken();
        if (((Token)object).kind != 191) {
            bl = true;
        }
        return bl;
    }

    void newLineAndIndent() {
        this.append("\n");
        for (int i = 0; i < this.getIndent(); ++i) {
            this.append("  ");
        }
    }

    void incrementIndent() {
        ++this.m_Indent;
    }

    void decrementIndent() {
        --this.m_Indent;
    }

    void print(SyntaxObject syntaxObject) {
        SyntaxOperatorPrecedence syntaxOperatorPrecedence = this.getPrecedence();
        SyntaxOperatorPrecedence syntaxOperatorPrecedence2 = this.getObjectPrecedence(syntaxObject);
        boolean bl = false;
        if (syntaxOperatorPrecedence2.gt(SyntaxOperatorPrecedence.getDefaultPrecedence()) && null != syntaxOperatorPrecedence && (syntaxOperatorPrecedence.gt(syntaxOperatorPrecedence2) || syntaxOperatorPrecedence.eq(syntaxOperatorPrecedence2) && !syntaxOperatorPrecedence.isAssociative() && syntaxOperatorPrecedence.getCurrentOperandCount() > 0)) {
            bl = true;
        }
        if (bl) {
            this.append("(");
        }
        if (!syntaxOperatorPrecedence2.isUnchangedPrecedence()) {
            this.setPrecedence(syntaxOperatorPrecedence2);
        }
        this.incrementIndent();
        syntaxObject.toSyntax(this);
        if (bl) {
            this.append(")");
        }
        this.decrementIndent();
        if (!syntaxOperatorPrecedence2.isUnchangedPrecedence()) {
            if (null != syntaxOperatorPrecedence) {
                syntaxOperatorPrecedence.incrementOperands();
            }
            this.setPrecedence(syntaxOperatorPrecedence);
        }
    }

    List<Query> getQueries() {
        return this.m_Queries;
    }

    String getOwner() {
        return this.m_Owner;
    }

    boolean isMetadataXMLVersionSameOrLaterThan(String string) {
        if (null == this.getXMLWriter()) {
            return true;
        }
        return this.getXMLWriter().isMetadataXMLVersionSameOrLaterThan(string);
    }
}

