/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.ComparisonCondition;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class ListComparisonCondition
extends ComparisonCondition {
    public static final String ALL = "ALL";
    public static final String SOME = "SOME";
    public static final String ANY = "ANY";
    private TypedExpression[] m_List;
    private String m_Qualifier;
    private static final String[] ALL_QUALIFIERS = new String[]{"ALL", "SOME", "ANY"};

    private TypedExpression[] getListInternal() {
        return this.m_List;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.print(this.getLhsArgument());
        if (this.getOperator() == "=" && this.getQualifier() == ANY) {
            syntaxPrintingContext.append(" IN");
        } else if (this.getOperator() == "!=" && this.getQualifier() == ALL) {
            syntaxPrintingContext.append(" NOT IN");
        } else {
            syntaxPrintingContext.append(this.getOperator());
            syntaxPrintingContext.append(" ");
            syntaxPrintingContext.append(this.getQualifier());
        }
        syntaxPrintingContext.append(" (");
        for (int i = 0; i < this.getListInternal().length; ++i) {
            if (0 != i) {
                syntaxPrintingContext.append(", ");
            }
            syntaxPrintingContext.print(this.getListInternal()[i]);
        }
        syntaxPrintingContext.append(")");
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        validationContext.validateComponents(this, this.getListInternal());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return super.checkIfDefinitionIsComplete() && this.areComponentsComplete(this.getListInternal());
    }

    public ListComparisonCondition(TypedExpression typedExpression, String string, String string2, TypedExpression[] typedExpressionArray) {
        super(typedExpression, string);
        ListComparisonCondition.validateValues(typedExpressionArray, 1);
        this.m_Qualifier = ListComparisonCondition.validateEnum(string2, ALL_QUALIFIERS);
        this.m_List = (TypedExpression[])typedExpressionArray.clone();
        this.initialize();
    }

    public ListComparisonCondition(TypedExpression typedExpression, String string, String string2, List<TypedExpression> list) {
        super(typedExpression, string);
        ListComparisonCondition.validateValues(list, 1);
        this.m_Qualifier = ListComparisonCondition.validateEnum(string2, ALL_QUALIFIERS);
        this.m_List = new TypedExpression[list.size()];
        list.toArray(this.m_List);
        this.initialize();
    }

    public ListComparisonCondition(TypedExpression typedExpression, String string, TypedExpression[] typedExpressionArray) {
        this(typedExpression, string, "!=" == ListComparisonCondition.validateEnum(string, ALL_OPERATORS, DEFAULT_ALL_OPERATORS) ? ALL : ANY, typedExpressionArray);
    }

    public ListComparisonCondition(TypedExpression typedExpression, TypedExpression[] typedExpressionArray) {
        this(typedExpression, "=", ANY, typedExpressionArray);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitListComparisonCondition(this, object);
    }

    public TypedExpression[] getList() {
        return (TypedExpression[])this.m_List.clone();
    }

    public String getQualifier() {
        return this.m_Qualifier;
    }
}

