/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.AggregationCase;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.ConsistentSolveCommand;
import oracle.olapi.syntax.ConsistentSolveSpecification;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.ModelCommand;
import oracle.olapi.syntax.SolveStepCommand;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class AggregationCommand
extends SolveStepCommand
implements ConsistentSolveCommand {
    public static final boolean IGNORE_NULLS_DEFAULT = true;
    public static final boolean ALLOW_OVERFLOW_DEFAULT = true;
    public static final boolean ALLOW_DIVISION_BY_ZERO_DEFAULT = true;
    public static final boolean MAINTAIN_COUNT_DEFAULT = false;
    private BaseMetadataObjectReference m_PrimaryDimension;
    private BaseMetadataObjectReference m_AggregationSwitch;
    private BaseMetadataObjectReference[] m_Hierarchies;
    private AggregationCase[] m_AggregationCases;
    private boolean m_IgnoreNulls = false;
    private boolean m_AllowOverflow = false;
    private boolean m_AllowDivisionByZero = false;
    private boolean m_MaintainCount = false;
    private Condition m_MembersCondition;

    private BaseMetadataObjectReference[] getHierarchiesInternal() {
        return this.m_Hierarchies;
    }

    private AggregationCase[] getAggregationCasesInternal() {
        return this.m_AggregationCases;
    }

    private BaseMetadataObjectReference getPrimaryDimensionReference() {
        return this.m_PrimaryDimension;
    }

    private BaseMetadataObjectReference getAggregationSwitchReference() {
        return this.m_AggregationSwitch;
    }

    private AggregationCommand(String string, FunctionArgument[] functionArgumentArray, AggregationCase[] aggregationCaseArray, MdmPrimaryDimension mdmPrimaryDimension, MdmHierarchy[] mdmHierarchyArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Condition condition, MdmObject mdmObject, boolean bl5) {
        super(string, functionArgumentArray, bl5);
        this.m_PrimaryDimension = null != mdmPrimaryDimension ? new MetadataObjectReference(mdmPrimaryDimension, MdmPrimaryDimension.class) : null;
        this.m_AllowDivisionByZero = bl3;
        this.m_AllowOverflow = bl2;
        this.m_MaintainCount = bl4;
        this.m_IgnoreNulls = bl;
        this.m_MembersCondition = null;
        if (mdmObject instanceof MdmPrimaryDimension) {
            this.m_AggregationSwitch = new MetadataObjectReference(mdmObject, MdmPrimaryDimension.class);
        } else if (mdmObject instanceof MdmBaseAttribute) {
            this.m_AggregationSwitch = new MetadataObjectReference(mdmObject, MdmBaseAttribute.class);
        } else {
            if (null != mdmObject) {
                throw new SyntaxException("SyntaxTypeMismatch2", MdmPrimaryDimension.class.getName(), MdmBaseAttribute.class.getName(), mdmObject.getClass().getName());
            }
            this.m_AggregationSwitch = null;
        }
        if (null != mdmHierarchyArray) {
            AggregationCommand.validateValues(mdmHierarchyArray, 0);
            AggregationCommand.validateValue(mdmPrimaryDimension);
            this.m_Hierarchies = new BaseMetadataObjectReference[mdmHierarchyArray.length];
            for (int i = 0; i < mdmHierarchyArray.length; ++i) {
                this.m_Hierarchies[i] = new MetadataObjectReference(mdmHierarchyArray[i], MdmHierarchy.class);
            }
        }
        if (null != aggregationCaseArray) {
            AggregationCommand.validateValues(aggregationCaseArray, 0);
            this.m_AggregationCases = bl5 ? (AggregationCase[])aggregationCaseArray.clone() : aggregationCaseArray;
        }
        if (null != condition) {
            AggregationCommand.validateValue(condition);
            this.m_MembersCondition = condition;
        }
        this.initialize();
    }

    private AggregationCommand(ExpParser expParser, String string, FunctionArgument[] functionArgumentArray, AggregationCase[] aggregationCaseArray, BaseMetadataObjectReference baseMetadataObjectReference, BaseMetadataObjectReference[] baseMetadataObjectReferenceArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Condition condition, BaseMetadataObjectReference baseMetadataObjectReference2, boolean bl5) {
        super(string, functionArgumentArray, bl5);
        this.m_PrimaryDimension = baseMetadataObjectReference;
        this.m_AllowDivisionByZero = bl3;
        this.m_AllowOverflow = bl2;
        this.m_MaintainCount = bl4;
        this.m_IgnoreNulls = bl;
        this.m_MembersCondition = null;
        this.m_AggregationSwitch = baseMetadataObjectReference2;
        if (null != baseMetadataObjectReferenceArray) {
            AggregationCommand.validateValue(baseMetadataObjectReference);
            AggregationCommand.validateValues(baseMetadataObjectReferenceArray, 0);
            this.m_Hierarchies = bl5 ? (BaseMetadataObjectReference[])baseMetadataObjectReferenceArray.clone() : baseMetadataObjectReferenceArray;
        }
        if (null != aggregationCaseArray) {
            AggregationCommand.validateValues(aggregationCaseArray, 0);
            this.m_AggregationCases = bl5 ? (AggregationCase[])aggregationCaseArray.clone() : aggregationCaseArray;
        }
        if (null != condition) {
            AggregationCommand.validateValue(condition);
            this.m_MembersCondition = condition;
        }
        this.initialize();
    }

    private static MdmHierarchy[] createMdmHierarchyArray(List<MdmHierarchy> list) {
        if (null == list) {
            return null;
        }
        MdmHierarchy[] mdmHierarchyArray = new MdmHierarchy[list.size()];
        list.toArray(mdmHierarchyArray);
        return mdmHierarchyArray;
    }

    private static BaseMetadataObjectReference[] createMdmHierarchyArray(ExpParser expParser, List<BaseMetadataObjectReference> list) {
        if (null == list) {
            return null;
        }
        BaseMetadataObjectReference[] baseMetadataObjectReferenceArray = new BaseMetadataObjectReference[list.size()];
        list.toArray(baseMetadataObjectReferenceArray);
        return baseMetadataObjectReferenceArray;
    }

    private static AggregationCase[] createAggregationCaseArray(List<AggregationCase> list) {
        if (null == list) {
            return null;
        }
        AggregationCase[] aggregationCaseArray = new AggregationCase[list.size()];
        list.toArray(aggregationCaseArray);
        return aggregationCaseArray;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (null != this.m_MembersCondition && !this.m_MembersCondition.isDefinitionComplete()) {
            return false;
        }
        if (null != this.getPrimaryDimensionReference() && !this.getPrimaryDimensionReference().isDefinitionComplete()) {
            return false;
        }
        if (null != this.getAggregationSwitchReference() && !this.getAggregationSwitchReference().isDefinitionComplete()) {
            return false;
        }
        if (null != this.getHierarchiesInternal()) {
            for (int i = 0; i < this.getHierarchiesInternal().length; ++i) {
                if (this.getHierarchiesInternal()[i].isDefinitionComplete()) continue;
                return false;
            }
        }
        return super.checkIfDefinitionIsComplete();
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        this.validate(16, validationContext);
        if (null != this.m_MembersCondition) {
            validationContext.validateCond(this.m_MembersCondition);
        }
        if (null != this.m_AggregationCases) {
            validationContext.validateComponents(this, this.m_AggregationCases);
        }
        if (null != this.m_PrimaryDimension) {
            this.m_PrimaryDimension = (BaseMetadataObjectReference)validationContext.validate(this.m_PrimaryDimension);
        }
        if (null != this.m_AggregationSwitch) {
            this.m_AggregationSwitch = (BaseMetadataObjectReference)validationContext.validate(this.m_AggregationSwitch);
        }
        if (null != this.getHierarchiesInternal()) {
            for (int i = 0; i < this.getHierarchiesInternal().length; ++i) {
                this.getHierarchiesInternal()[i] = (BaseMetadataObjectReference)validationContext.validate(this.getHierarchiesInternal()[i]);
            }
        }
        return this;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        boolean bl = false;
        boolean bl2 = false;
        if (null != this.getAggregationCasesInternal() && 0 < this.getAggregationCasesInternal().length) {
            syntaxPrintingContext.append("AGGREGATE USING ");
            AggregationCase aggregationCase = this.getAggregationCasesInternal()[0];
            if (null != aggregationCase.getMeasureID()) {
                syntaxPrintingContext.append("MEASURE ");
                bl2 = true;
            } else if (null != this.getAggregationSwitchReference() && syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("2.0")) {
                if (this.getAggregationSwitchReference().getObjectType() == MdmBaseAttribute.class) {
                    syntaxPrintingContext.append("ATTRIBUTE ");
                } else {
                    syntaxPrintingContext.append("DIMENSION ");
                }
                this.getAggregationSwitchReference().toSyntax(syntaxPrintingContext);
                bl2 = true;
            }
            for (int i = 0; i < this.getAggregationCasesInternal().length; ++i) {
                syntaxPrintingContext.newLineAndIndent();
                syntaxPrintingContext.print(this.getAggregationCasesInternal()[i]);
            }
            if (bl2) {
                syntaxPrintingContext.newLineAndIndent();
                syntaxPrintingContext.append("ELSE ");
            }
            bl = true;
        }
        if (this.getFunctionName().equalsIgnoreCase("NO AGGREGATE") && !syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("2.0")) {
            syntaxPrintingContext.append("SUM");
        } else {
            super.toSyntax(syntaxPrintingContext);
        }
        if (this.getMaintainCount()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("MAINTAIN COUNT");
            bl = true;
        }
        if (!this.getAllowOverflow()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("DISALLOW OVERFLOW");
            bl = true;
        }
        if (!this.getAllowDivisionByZero()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("DISALLOW DIVISION BY ZERO");
            bl = true;
        }
        if (!this.getIgnoreNulls()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("CONSIDER NULLS");
            bl = true;
        }
        if (bl) {
            syntaxPrintingContext.newLineAndIndent();
        }
        syntaxPrintingContext.append(" OVER ");
        if (null == this.getPrimaryDimensionReference()) {
            syntaxPrintingContext.append("ALL");
        } else {
            this.getPrimaryDimensionReference().toSyntax(syntaxPrintingContext);
            if (null != this.getHierarchiesInternal()) {
                syntaxPrintingContext.append(" HIERARCHIES (");
                for (int i = 0; i < this.getHierarchiesInternal().length; ++i) {
                    if (0 != i) {
                        syntaxPrintingContext.append(", ");
                    }
                    syntaxPrintingContext.appendIdentifierComponent(this.getHierarchiesInternal()[i].getName(), true);
                }
                syntaxPrintingContext.append(")");
            }
        }
        if (null != this.getMembersCondition() && syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("1.2")) {
            syntaxPrintingContext.append(" FROM MEMBERS WHERE ");
            syntaxPrintingContext.print(this.getMembersCondition());
        }
    }

    @Override
    boolean isCommandValidForXMLVersion(ConsistentSolveSpecification consistentSolveSpecification, SyntaxPrintingContext syntaxPrintingContext) {
        if (syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("2.0")) {
            return true;
        }
        if (!this.getFunctionName().equalsIgnoreCase("NO AGGREGATE")) {
            return true;
        }
        int n = consistentSolveSpecification.getCommands().length;
        for (int i = 0; i < n; ++i) {
            AggregationCommand aggregationCommand;
            ConsistentSolveCommand consistentSolveCommand = consistentSolveSpecification.getCommands()[i];
            if (!(consistentSolveCommand instanceof AggregationCommand) || (aggregationCommand = (AggregationCommand)consistentSolveCommand) == this || aggregationCommand.getFunctionName().equalsIgnoreCase("NO AGGREGATE")) continue;
            return false;
        }
        return !(consistentSolveSpecification.getCommands()[0] instanceof ModelCommand) || consistentSolveSpecification.getCommands()[n - 1] instanceof ModelCommand;
    }

    public AggregationCommand(String string) {
        this(null, string, null, null, null, null, true, true, true, false, null, null, true);
    }

    public AggregationCommand(String string, FunctionArgument[] functionArgumentArray, MdmPrimaryDimension mdmPrimaryDimension) {
        this(string, functionArgumentArray, null, mdmPrimaryDimension, null, true, true, true, false, null, null, true);
    }

    public AggregationCommand(String string, FunctionArgument[] functionArgumentArray, MdmPrimaryDimension mdmPrimaryDimension, MdmHierarchy[] mdmHierarchyArray) {
        this(string, functionArgumentArray, null, mdmPrimaryDimension, mdmHierarchyArray, true, true, true, false, null, null, true);
    }

    public AggregationCommand(String string, FunctionArgument[] functionArgumentArray, AggregationCase[] aggregationCaseArray, MdmPrimaryDimension mdmPrimaryDimension, MdmHierarchy[] mdmHierarchyArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, functionArgumentArray, aggregationCaseArray, mdmPrimaryDimension, mdmHierarchyArray, bl, bl2, bl3, bl4, null, null, true);
    }

    public AggregationCommand(String string, FunctionArgument[] functionArgumentArray, AggregationCase[] aggregationCaseArray, MdmPrimaryDimension mdmPrimaryDimension, MdmHierarchy[] mdmHierarchyArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Condition condition) {
        this(string, functionArgumentArray, aggregationCaseArray, mdmPrimaryDimension, mdmHierarchyArray, bl, bl2, bl3, bl4, condition, null, true);
    }

    public AggregationCommand(String string, List<FunctionArgument> list, List<AggregationCase> list2, MdmPrimaryDimension mdmPrimaryDimension, List<MdmHierarchy> list3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, AggregationCommand.getFunctionArgumentArrayClone(list), AggregationCommand.createAggregationCaseArray(list2), mdmPrimaryDimension, AggregationCommand.createMdmHierarchyArray(list3), bl, bl2, bl3, bl4, null, null, false);
    }

    public AggregationCommand(String string, List<FunctionArgument> list, List<AggregationCase> list2, MdmPrimaryDimension mdmPrimaryDimension, List<MdmHierarchy> list3, boolean bl, boolean bl2, boolean bl3, boolean bl4, Condition condition) {
        this(string, AggregationCommand.getFunctionArgumentArrayClone(list), AggregationCommand.createAggregationCaseArray(list2), mdmPrimaryDimension, AggregationCommand.createMdmHierarchyArray(list3), bl, bl2, bl3, bl4, condition, null, false);
    }

    public AggregationCommand(String string, List<FunctionArgument> list, List<AggregationCase> list2, MdmPrimaryDimension mdmPrimaryDimension, List<MdmHierarchy> list3, boolean bl, boolean bl2, boolean bl3, boolean bl4, Condition condition, MdmPrimaryDimension mdmPrimaryDimension2) {
        this(string, AggregationCommand.getFunctionArgumentArrayClone(list), AggregationCommand.createAggregationCaseArray(list2), mdmPrimaryDimension, AggregationCommand.createMdmHierarchyArray(list3), bl, bl2, bl3, bl4, condition, mdmPrimaryDimension2, false);
    }

    public AggregationCommand(String string, List<FunctionArgument> list, List<AggregationCase> list2, MdmPrimaryDimension mdmPrimaryDimension, List<MdmHierarchy> list3, boolean bl, boolean bl2, boolean bl3, boolean bl4, Condition condition, MdmBaseAttribute mdmBaseAttribute) {
        this(string, AggregationCommand.getFunctionArgumentArrayClone(list), AggregationCommand.createAggregationCaseArray(list2), mdmPrimaryDimension, AggregationCommand.createMdmHierarchyArray(list3), bl, bl2, bl3, bl4, condition, mdmBaseAttribute, false);
    }

    public AggregationCommand(ExpParser expParser, String string, List<FunctionArgument> list, List<AggregationCase> list2, BaseMetadataObjectReference baseMetadataObjectReference, List<BaseMetadataObjectReference> list3, boolean bl, boolean bl2, boolean bl3, boolean bl4, Condition condition, BaseMetadataObjectReference baseMetadataObjectReference2) {
        this(expParser, string, AggregationCommand.getFunctionArgumentArrayClone(list), AggregationCommand.createAggregationCaseArray(list2), baseMetadataObjectReference, AggregationCommand.createMdmHierarchyArray(expParser, list3), bl, bl2, bl3, bl4, condition, baseMetadataObjectReference2, false);
    }

    public AggregationCommand(String string, List<FunctionArgument> list, MdmPrimaryDimension mdmPrimaryDimension, List<MdmHierarchy> list2) {
        this(string, AggregationCommand.getFunctionArgumentArrayClone(list), null, mdmPrimaryDimension, AggregationCommand.createMdmHierarchyArray(list2), true, true, true, false, null, null, false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitAggregationCommand(this, object);
    }

    public MdmHierarchy[] getHierarchies() {
        if (null != this.getHierarchiesInternal()) {
            MdmHierarchy[] mdmHierarchyArray = new MdmHierarchy[this.getHierarchiesInternal().length];
            for (int i = 0; i < this.getHierarchiesInternal().length; ++i) {
                mdmHierarchyArray[i] = (MdmHierarchy)this.getHierarchiesInternal()[i].getBaseMetadataObject();
            }
            return mdmHierarchyArray;
        }
        return null;
    }

    public String[] getHierarchyIDs() {
        if (null != this.getHierarchiesInternal()) {
            String[] stringArray = new String[this.getHierarchiesInternal().length];
            for (int i = 0; i < this.getHierarchiesInternal().length; ++i) {
                stringArray[i] = this.getHierarchiesInternal()[i].getIdentifier().toString();
            }
            return stringArray;
        }
        return null;
    }

    public AggregationCase[] getAggregationCases() {
        if (null == this.getAggregationCasesInternal()) {
            return null;
        }
        return (AggregationCase[])this.getAggregationCasesInternal().clone();
    }

    public MdmPrimaryDimension getPrimaryDimension() {
        if (null != this.m_PrimaryDimension) {
            return (MdmPrimaryDimension)this.m_PrimaryDimension.getBaseMetadataObject();
        }
        return null;
    }

    public String getPrimaryDimensionID() {
        if (null != this.m_PrimaryDimension) {
            return this.m_PrimaryDimension.getIdentifier().toString();
        }
        return null;
    }

    public MdmObject getAggregationSwitch() {
        if (null != this.m_AggregationSwitch) {
            return (MdmObject)this.m_AggregationSwitch.getBaseMetadataObject();
        }
        return null;
    }

    public String getAggregationSwitchID() {
        if (null != this.m_AggregationSwitch) {
            return this.m_AggregationSwitch.getIdentifier().toString();
        }
        return null;
    }

    public boolean getIgnoreNulls() {
        return this.m_IgnoreNulls;
    }

    public boolean getAllowOverflow() {
        return this.m_AllowOverflow;
    }

    public boolean getAllowDivisionByZero() {
        return this.m_AllowDivisionByZero;
    }

    public boolean getMaintainCount() {
        return this.m_MaintainCount;
    }

    public Condition getMembersCondition() {
        return this.m_MembersCondition;
    }
}

