/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.AggregateOverClause;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.UnresolvedMetadataObjectReference;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class AggregateOverMembersClause
extends AggregateOverClause {
    private String[] m_Members;
    private BaseMetadataObjectReference m_Dimension = null;

    private String[] getMembersInternal() {
        return this.m_Members;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        this.m_Dimension.toSyntax(syntaxPrintingContext);
        syntaxPrintingContext.append(" IN (");
        for (int i = 0; i < this.getMembersInternal().length; ++i) {
            if (0 < i) {
                syntaxPrintingContext.append(", ");
            }
            syntaxPrintingContext.appendQuotedString(this.getMembersInternal()[i]);
        }
        syntaxPrintingContext.append(")");
    }

    private AggregateOverMembersClause(MdmPrimaryDimension mdmPrimaryDimension, String[] stringArray, boolean bl) {
        AggregateOverMembersClause.validateValue(mdmPrimaryDimension);
        this.m_Dimension = new MetadataObjectReference(mdmPrimaryDimension, MdmPrimaryDimension.class);
        AggregateOverMembersClause.validateValues(stringArray, 1);
        this.m_Members = bl ? (String[])stringArray.clone() : stringArray;
        this.initialize();
    }

    private AggregateOverMembersClause(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, String[] stringArray, boolean bl) {
        AggregateOverMembersClause.validateValue(baseMetadataObjectReference);
        this.m_Dimension = baseMetadataObjectReference;
        AggregateOverMembersClause.validateValues(stringArray, 1);
        this.m_Members = bl ? (String[])stringArray.clone() : stringArray;
        this.initialize();
    }

    private static String[] createStringArray(List<String> list) {
        if (null == list) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_Dimension.isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    public AggregateOverMembersClause(MdmPrimaryDimension mdmPrimaryDimension, String[] stringArray) {
        this(mdmPrimaryDimension, stringArray, true);
    }

    public AggregateOverMembersClause(MdmPrimaryDimension mdmPrimaryDimension, List<String> list) {
        this(mdmPrimaryDimension, AggregateOverMembersClause.createStringArray(list), false);
    }

    public AggregateOverMembersClause(ExpParser expParser, UnresolvedMetadataObjectReference unresolvedMetadataObjectReference, String[] stringArray) {
        this(expParser, unresolvedMetadataObjectReference, stringArray, true);
    }

    public AggregateOverMembersClause(ExpParser expParser, UnresolvedMetadataObjectReference unresolvedMetadataObjectReference, List<String> list) {
        this(expParser, unresolvedMetadataObjectReference, AggregateOverMembersClause.createStringArray(list), false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitAggregateOverMembersClause(this, object);
    }

    public MdmPrimaryDimension getDimension() {
        return (MdmPrimaryDimension)this.m_Dimension.getBaseMetadataObject();
    }

    public String getDimensionID() {
        return this.m_Dimension.getIdentifier().toString();
    }

    public String[] getMembers() {
        return (String[])this.getMembersInternal().clone();
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        this.m_Dimension = (BaseMetadataObjectReference)validationContext.validate(this.m_Dimension);
        return this;
    }
}

