/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Date;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.Mdm10_1_0_3_ObjectVisitor;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmMember;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.metadata.mdm.MdmTimeDimension;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;
import oracle.olapi.metadata.mdm.MdmXMLTags;

public class MdmTimeMember
extends MdmSource
implements MdmMember {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.PARENT, MdmXMLTags.LEVEL_REF, MdmXMLTags.VALUE_HIER_REF, MdmXMLTags.PARENT_LEVEL_REF, MdmXMLTags.TIMESPAN, MdmXMLTags.END_DATE, MdmXMLTags.PRECEDENCE};

    public MdmTimeMember(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    @Override
    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        Mdm10_1_0_3_ObjectVisitor mdm10_1_0_3_ObjectVisitor = null;
        try {
            mdm10_1_0_3_ObjectVisitor = (Mdm10_1_0_3_ObjectVisitor)mdmObjectVisitor;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return mdm10_1_0_3_ObjectVisitor.visitMdmTimeMember(this, object);
    }

    @Override
    protected XMLTag getXMLTag() {
        return MdmXMLTags.TIME_MEMBER_TAG;
    }

    public Date getEndDate() {
        return new Date(this.getPropertyIntegerValue(MdmXMLTags.END_DATE, 0) * 1000);
    }

    public int getTimeSpan() {
        return this.getPropertyIntegerValue(MdmXMLTags.TIMESPAN, 0);
    }

    @Override
    public int getPrecedence() {
        return this.getPropertyIntegerValue(MdmXMLTags.PRECEDENCE, 10);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public void setPrecedence(int n) {
        this.setPropertyIntegerValue(MdmXMLTags.PRECEDENCE, n);
    }

    public void setEndDate(Date date) {
        if (null != date) {
            this.setPropertyIntegerValue(MdmXMLTags.END_DATE, (int)(date.getTime() / 1000L));
        }
    }

    public void setTimeSpan(int n) {
        if (n > 0) {
            this.setPropertyIntegerValue(MdmXMLTags.TIMESPAN, n);
        }
    }

    @Override
    public MdmPrimaryDimension getOwnerDimension() {
        if (this.getLevel() != null) {
            return this.getLevel().getPrimaryDimension();
        }
        return this.getValueHierarchy().getPrimaryDimension();
    }

    @Override
    public String getValue() {
        String string = this.getLocalValue();
        MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
        if (mdmMetadataProvider.usingUniqueValues()) {
            if (this.getLevel() != null) {
                return mdmMetadataProvider.getValueConverter().convertLocalValueToUniqueValue(mdmMetadataProvider, this.getLevel(), string);
            }
            return mdmMetadataProvider.getValueConverter().convertLocalValueToUniqueValue(mdmMetadataProvider, this.getValueHierarchy(), string);
        }
        return string;
    }

    @Override
    public String getLocalValue() {
        return this.getName();
    }

    @Override
    public MdmLevel getLevel() {
        return (MdmLevel)this.getPropertyObjectValue(MdmXMLTags.LEVEL_REF);
    }

    public void setLevel(MdmLevel mdmLevel) {
        this.setPropertyObjectValue(MdmXMLTags.LEVEL_REF, mdmLevel);
    }

    public MdmValueHierarchy getValueHierarchy() {
        return (MdmValueHierarchy)this.getPropertyObjectValue(MdmXMLTags.VALUE_HIER_REF);
    }

    public void setValueHierarchy(MdmValueHierarchy mdmValueHierarchy) {
        this.setPropertyObjectValue(MdmXMLTags.VALUE_HIER_REF, mdmValueHierarchy);
    }

    @Override
    public int getLevelDepth() {
        if (this.getLevel() == null) {
            return 0;
        }
        return this.getLevel().getLevelDepth();
    }

    @Override
    public String getParentValue() {
        String string = this.getParentLocalValue();
        if (string == null || !this.getMetadataProvider().usingUniqueValues()) {
            return string;
        }
        MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
        if (mdmMetadataProvider.usingUniqueValues()) {
            return mdmMetadataProvider.getValueConverter().convertLocalValueToUniqueValue(mdmMetadataProvider, this.getParentLevel(), string);
        }
        return string;
    }

    @Override
    public String getParentLocalValue() {
        return this.getPropertyStringValue(MdmXMLTags.PARENT);
    }

    public void setParentLocalValue(String string) {
        this.setPropertyStringValue(MdmXMLTags.PARENT, string);
    }

    @Override
    public MdmLevel getParentLevel() {
        return (MdmLevel)this.getPropertyObjectValue(MdmXMLTags.PARENT_LEVEL_REF);
    }

    public void setParentLevel(MdmLevel mdmLevel) {
        this.setPropertyObjectValue(MdmXMLTags.PARENT_LEVEL_REF, mdmLevel);
    }

    public final MdmTimeDimension getTimeDimension() {
        return (MdmTimeDimension)this.getContainedByObject();
    }

    @Override
    void initializeSourceDefinition() {
    }

    @Override
    public MetadataObject getType() {
        return null;
    }
}

