/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmSourceDefinition;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.metadata.mtm.MtmSourceMap;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.transaction.Transaction;

public abstract class MdmSource
extends MdmObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.DATA_TYPE, MdmXMLTags.METADATA_MAP, MdmXMLTags.MODEL};
    private SourceDefinition _sourceDefinition;

    final SQLDataType convertOldDataTypeToSQLDataType(MetadataObject metadataObject) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getMetadataProvider().getDataProvider().getFundamentalMetadataProvider();
        if (fundamentalMetadataProvider.getStringDataType() == metadataObject) {
            return DataType.VARCHAR2.toSQLDataType();
        }
        if (fundamentalMetadataProvider.getNumberDataType() == metadataObject || fundamentalMetadataProvider.getBooleanDataType() == metadataObject || fundamentalMetadataProvider.getIntegerDataType() == metadataObject || fundamentalMetadataProvider.getShortDataType() == metadataObject || fundamentalMetadataProvider.getDoubleDataType() == metadataObject || fundamentalMetadataProvider.getFloatDataType() == metadataObject) {
            return DataType.NUMBER.toSQLDataType();
        }
        if (fundamentalMetadataProvider.getDateDataType() == metadataObject) {
            return DataType.DATE.toSQLDataType();
        }
        return DataType.VARCHAR2.toSQLDataType();
    }

    final MetadataObject convertSQLDataTypeToOldDataType(SQLDataType sQLDataType, boolean bl) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getMetadataProvider().getDataProvider().getFundamentalMetadataProvider();
        if (null == sQLDataType) {
            return fundamentalMetadataProvider.getValueDataType();
        }
        DataType dataType = sQLDataType.getDataType();
        if (dataType.matchesCategory(2)) {
            if (bl) {
                return fundamentalMetadataProvider.getBooleanDataType();
            }
            return fundamentalMetadataProvider.getNumberDataType();
        }
        if (dataType.matchesCategory(1)) {
            return fundamentalMetadataProvider.getStringDataType();
        }
        if (dataType.matchesCategory(24)) {
            return fundamentalMetadataProvider.getDateDataType();
        }
        return fundamentalMetadataProvider.getValueDataType();
    }

    public MdmSource(String string, String string2, short s, BaseMetadataProvider baseMetadataProvider, BaseMetadataObject baseMetadataObject) {
        super(baseMetadataProvider, string, string2, s, baseMetadataObject);
    }

    public FundamentalMetadataObject getDataType() {
        try {
            for (MetadataObject metadataObject = this; metadataObject != null; metadataObject = metadataObject.getType()) {
                if (!(metadataObject instanceof FundamentalMetadataObject)) continue;
                return (FundamentalMetadataObject)metadataObject;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public MdmModel getModel() {
        return (MdmModel)this.getPropertyObjectValue(MdmXMLTags.MODEL);
    }

    public final MtmSourceMap getSourceMap() throws MetadataNotFoundException {
        return (MtmSourceMap)this.getPropertyObjectValue(MdmXMLTags.METADATA_MAP);
    }

    public final Source getSource() {
        if (null == this.getSourceDefinition()) {
            this.initializeSourceDefinition();
        }
        if (null == this.getSourceDefinition()) {
            return null;
        }
        return this.getSourceDefinition().getSource();
    }

    protected final SourceDefinition getSourceDefinition() {
        return this._sourceDefinition;
    }

    public abstract MetadataObject getType();

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    void initializeSourceDefinition() {
        this.setSourceDefinition(new MdmSourceDefinition(this.getMetadataProvider(), this, this.getMetadataProvider().getDataProvider()));
    }

    protected final void setSourceDefinition(SourceDefinition sourceDefinition) {
        this._sourceDefinition = sourceDefinition;
    }

    final void setSourceMap(MtmSourceMap mtmSourceMap) {
        this.setPropertyObjectValue(MdmXMLTags.METADATA_MAP, mtmSourceMap);
        mtmSourceMap.setMdmSource(this);
    }

    public void setType(MetadataObject metadataObject) {
        this.setTypeProperty(metadataObject);
        if (this.getModel() != null) {
            this.getModel().setDefaultPrecedence(this.getModel().getDefaultPrecedence());
        }
    }

    public void setModel(MdmModel mdmModel) {
        this.setPropertyObjectValue(MdmXMLTags.MODEL, mdmModel);
    }

    @Override
    public void gatherReferencedSources(List list, Transaction transaction) {
        Source source;
        if (null == this.getSourceMap() && null != (source = this.getSource())) {
            list.add(source);
        }
        super.gatherReferencedSources(list, transaction);
    }

    @Override
    protected void appendAdditionalXMLAttributes(MetadataToXMLConverter metadataToXMLConverter) {
        if (this.getSourceMap() == null && metadataToXMLConverter.getXMLFormat().is10gMode()) {
            metadataToXMLConverter.appendAttribute(MdmXMLTags.SOURCE_DEF_REF, this.getSourceDefinition().getID());
        }
        super.appendAdditionalXMLAttributes(metadataToXMLConverter);
    }

    MdmSource(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    protected Set getInputDefinitions() {
        return Collections.EMPTY_SET;
    }

    protected List getOutputDefinitions() {
        return Collections.EMPTY_LIST;
    }

    protected SourceDefinition getTypeDefinition() {
        return null;
    }

    protected void setTypeProperty(MetadataObject metadataObject) {
        this.setPropertyObjectValue(MdmXMLTags.DATA_TYPE, metadataObject);
    }

    @Override
    protected void updateID(String string) {
        super.updateID(string);
        if (null != this.getSourceDefinition()) {
            this.getSourceDefinition().updatePersistentID();
        }
    }
}

