/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.Locale;
import oracle.olapi.internal.ObjectHolder;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import org.xml.sax.SAXException;

public final class MdmDescription
extends BaseMetadataObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.DESC_TYPE, MdmXMLTags.LANGUAGE, MdmXMLTags.DESCRIPTION_VALUE};

    MdmDescription(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public MdmDescription(String string, String string2, short s, BaseMetadataObject baseMetadataObject, XMLTag[] xMLTagArray, String[] stringArray) {
        super(baseMetadataObject.getBaseMetadataProvider(), string, s, baseMetadataObject, xMLTagArray, stringArray);
    }

    @Override
    protected void finishObjectCreation() {
        super.finishObjectCreation();
        if (this.hasProperty(MdmXMLTags.LANGUAGE)) {
            return;
        }
        String string = this.getBaseMetadataProvider().getDataProvider().getCurrentSession().getDefaultLanguage(false);
        MdmXMLTags.LANGUAGE.initializeProperty((BaseMetadataObject)this, (Object)string, this.getPersistenceType());
    }

    @Override
    protected XMLTag getXMLTag() {
        return MdmXMLTags.DESCRIPTION_TAG;
    }

    @Override
    protected final XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader) throws SAXException {
        String string4 = metadataXMLReader.getAttributeValue(MdmXMLTags.DESC_TYPE);
        String string5 = metadataXMLReader.getAttributeValue(MdmXMLTags.LANGUAGE, false);
        string5 = string5 == null ? metadataXMLReader.getMetadataProvider().getDataProvider().getCurrentSession().getDefaultLanguage(false) : MdmDescription.stripLanguage(string5);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("$DESC");
        arrayList.add(string4);
        arrayList.add(string5);
        return MdmDescription.generateIDFromXML(baseMetadataObject, xMLTag, null, string2, string3, metadataXMLReader, arrayList);
    }

    @Override
    protected void appendIDAttrsForXMLObjectRef(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, MetadataToXMLConverter metadataToXMLConverter) {
        metadataToXMLConverter.appendIDAttribute(MdmXMLTags.DESC_TYPE, this.getType(), (BaseMetadataObject)this);
        metadataToXMLConverter.appendIDAttribute(MdmXMLTags.LANGUAGE, this.getLanguage(), (BaseMetadataObject)this);
        super.appendIDAttrsForXMLObjectRef(baseMetadataObject, xMLTag, metadataToXMLConverter);
    }

    public final String getType() {
        return this.getPropertyStringValue(MdmXMLTags.DESC_TYPE);
    }

    final void setType(String string) {
        this.setPropertyStringValue(MdmXMLTags.DESC_TYPE, string);
    }

    public final String getLanguage() {
        return this.getPropertyStringValue(MdmXMLTags.LANGUAGE);
    }

    final void setLanguage(String string) {
        this.setPropertyStringValue(MdmXMLTags.LANGUAGE, string);
    }

    public final String getValue() {
        return this.getPropertyStringValue(MdmXMLTags.DESCRIPTION_VALUE);
    }

    public final void setValue(String string) {
        this.setPropertyStringValue(MdmXMLTags.DESCRIPTION_VALUE, string);
    }

    public final MdmObject getDescribedObject() {
        return (MdmObject)this.getContainedByObject();
    }

    @Override
    public String getName() {
        return "$DESC." + this.getType() + "." + this.getLanguage();
    }

    @Override
    protected boolean verifySetProperty(XMLTag xMLTag, ObjectHolder objectHolder) {
        if (MdmXMLTags.LANGUAGE == xMLTag) {
            String string = (String)objectHolder.getObject();
            string = MdmDescription.stripLanguage(string);
            objectHolder.setObject(string);
        }
        return true;
    }

    public static String stripLanguage(String string) {
        if (null == string) {
            return null;
        }
        String string2 = string;
        int n = string.indexOf("_");
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2.toUpperCase(Locale.ENGLISH);
    }

    public static final boolean classHasPrivateName() {
        return true;
    }
}

