/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.List;
import oracle.olapi.ArraySet;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataObjectState;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.MetadataModificationException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.PersistentLanguageFetcher;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.deployment.AWCubeOrganization;
import oracle.olapi.metadata.deployment.CubeOrganization;
import oracle.olapi.metadata.mdm.Mdm11_ObjectVisitor;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmNamedBuildProcess;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmOrganizationalSchema;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmStandardDimension;
import oracle.olapi.metadata.mdm.MdmTable;
import oracle.olapi.metadata.mdm.MdmTimeDimension;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import org.xml.sax.SAXException;

public class MdmDatabaseSchema
extends MdmSchema {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.ORGANIZATIONAL_SCHEMA_REF_CONTAINED, MdmXMLTags.AW_REF_CONTAINED, MdmXMLTags.PRIMARY_DIMENSION_REF_CONTAINED, MdmXMLTags.CUBE_REF_CONTAINED, MdmXMLTags.NAMED_BUILD_PROCESS_REF_CONTAINED, MdmXMLTags.OWNER};

    protected MdmDatabaseSchema(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    @Override
    protected XMLTag getXMLTag() {
        return MdmXMLTags.DATABASESCHEMA_TAG;
    }

    @Override
    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        if (mdmObjectVisitor instanceof Mdm11_ObjectVisitor) {
            return ((Mdm11_ObjectVisitor)mdmObjectVisitor).visitMdmDatabaseSchema(this, object);
        }
        return super.acceptVisitor(mdmObjectVisitor, object);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader) throws SAXException {
        return string;
    }

    public BaseMetadataObject getTopLevelObject(String string) {
        return this.getTopLevelObject("", string);
    }

    public BaseMetadataObject getTopLevelObject(String string, String string2) {
        if (null == string2) {
            return null;
        }
        String string3 = MdmDatabaseSchema.generateNamespaceID(string, new String[]{this.getName(), string2});
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string3);
        if (metadataObject instanceof MdmCube || metadataObject instanceof MdmPrimaryDimension || metadataObject instanceof MdmTable || metadataObject instanceof MdmOrganizationalSchema || metadataObject instanceof AW || metadataObject instanceof MdmNamedBuildProcess) {
            return (BaseMetadataObject)metadataObject;
        }
        return null;
    }

    public final void addOrganizationalSchema(MdmOrganizationalSchema mdmOrganizationalSchema) {
        this.addToListProperty(MdmXMLTags.ORGANIZATIONAL_SCHEMA_REF_CONTAINED, mdmOrganizationalSchema);
    }

    @Override
    public final void addSubSchema(MdmSchema mdmSchema) {
        if (mdmSchema instanceof MdmOrganizationalSchema) {
            this.addToListProperty(MdmXMLTags.ORGANIZATIONAL_SCHEMA_REF_CONTAINED, mdmSchema);
        }
    }

    public final void addNamedBuildProcess(MdmNamedBuildProcess mdmNamedBuildProcess) {
        this.addToListProperty(MdmXMLTags.NAMED_BUILD_PROCESS_REF_CONTAINED, mdmNamedBuildProcess);
    }

    public final void removeOrganizationalSchema(MdmOrganizationalSchema mdmOrganizationalSchema) {
        this.removeFromListProperty(MdmXMLTags.ORGANIZATIONAL_SCHEMA_REF_CONTAINED, mdmOrganizationalSchema);
    }

    @Override
    public final void removeSubSchema(MdmSchema mdmSchema) {
        if (mdmSchema instanceof MdmOrganizationalSchema) {
            this.removeFromListProperty(MdmXMLTags.ORGANIZATIONAL_SCHEMA_REF_CONTAINED, mdmSchema);
        }
    }

    public final void removeNamedBuildProcess(MdmNamedBuildProcess mdmNamedBuildProcess) {
        this.removeFromListProperty(MdmXMLTags.NAMED_BUILD_PROCESS_REF_CONTAINED, mdmNamedBuildProcess);
    }

    public final List getOrganizationalSchemas() {
        return this.getPropertyListValues(MdmXMLTags.ORGANIZATIONAL_SCHEMA_REF_CONTAINED);
    }

    @Override
    public final List getSubSchemas() {
        List list = this.getOrganizationalSchemas();
        for (MdmOrganizationalSchema mdmOrganizationalSchema : this.getOrganizationalSchemas()) {
            list.removeAll(mdmOrganizationalSchema.getOrganizationalSchemas());
        }
        return list;
    }

    public final List getNamedBuildProcesses() {
        return this.getPropertyListValues(MdmXMLTags.NAMED_BUILD_PROCESS_REF_CONTAINED);
    }

    @Override
    public final MdmDatabaseSchema getOwner() {
        return this;
    }

    public final void addSchemaObject(BaseMetadataObject baseMetadataObject) {
        if (baseMetadataObject instanceof MdmPrimaryDimension) {
            this.addDimension((MdmPrimaryDimension)baseMetadataObject);
        } else if (baseMetadataObject instanceof MdmCube) {
            this.addCube((MdmCube)baseMetadataObject);
        } else if (baseMetadataObject instanceof AW) {
            this.addAW((AW)baseMetadataObject);
        } else if (baseMetadataObject instanceof MdmOrganizationalSchema) {
            this.addOrganizationalSchema((MdmOrganizationalSchema)baseMetadataObject);
        } else if (baseMetadataObject instanceof MdmNamedBuildProcess) {
            this.addNamedBuildProcess((MdmNamedBuildProcess)baseMetadataObject);
        } else {
            throw new MetadataModificationException("InvalidArguments", baseMetadataObject.getID());
        }
    }

    public final void removeSchemaObject(BaseMetadataObject baseMetadataObject) {
        if (baseMetadataObject instanceof MdmPrimaryDimension) {
            this.removeDimension((MdmPrimaryDimension)baseMetadataObject);
        } else if (baseMetadataObject instanceof MdmCube) {
            this.removeCube((MdmCube)baseMetadataObject);
        } else if (baseMetadataObject instanceof AW) {
            this.removeAW((AW)baseMetadataObject);
        } else if (baseMetadataObject instanceof MdmOrganizationalSchema) {
            this.removeOrganizationalSchema((MdmOrganizationalSchema)baseMetadataObject);
        } else if (baseMetadataObject instanceof MdmNamedBuildProcess) {
            this.removeNamedBuildProcess((MdmNamedBuildProcess)baseMetadataObject);
        } else {
            throw new MetadataModificationException("InvalidArguments", baseMetadataObject.getID());
        }
    }

    public final List<BaseMetadataObject> getSchemaObjects() {
        ArrayList<BaseMetadataObject> arrayList = new ArrayList<BaseMetadataObject>();
        arrayList.addAll(this.getDimensions());
        arrayList.addAll(this.getCubes());
        arrayList.addAll(this.getOrganizationalSchemas());
        arrayList.addAll(this.getAWs());
        arrayList.addAll(this.getNamedBuildProcesses());
        return arrayList;
    }

    public MdmOrganizationalSchema findOrCreateOrganizationalSchema(String string) {
        return this.findOrCreateOrganizationalSchema(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmOrganizationalSchema findOrCreateOrganizationalSchema(String string, String string2) {
        MdmOrganizationalSchema mdmOrganizationalSchema = null;
        MdmObject mdmObject = (MdmObject)this.getTopLevelObject(string2, string);
        if (null == mdmObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                mdmObject = (MdmObject)this.getTopLevelObject(string);
                if (null == mdmObject) {
                    String string3 = MdmDatabaseSchema.generateID(new String[]{this.getName(), string});
                    mdmOrganizationalSchema = new MdmOrganizationalSchema(string, string3, 0, this.getBaseMetadataProvider());
                    this.addOrganizationalSchema(mdmOrganizationalSchema);
                    mdmOrganizationalSchema.setOwner(this);
                    return mdmOrganizationalSchema;
                }
            }
        }
        if (mdmObject instanceof MdmOrganizationalSchema) {
            mdmOrganizationalSchema = (MdmOrganizationalSchema)mdmObject;
            this.addOrganizationalSchema(mdmOrganizationalSchema);
        } else if (null != mdmObject) {
            throw new DuplicateMetadataIDException(mdmObject.getID());
        }
        return mdmOrganizationalSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AW findOrCreateAW(String string) {
        AW aW = null;
        String string2 = string + "." + "AW";
        BaseMetadataObject baseMetadataObject = this.getTopLevelObject(string2);
        if (null == baseMetadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                baseMetadataObject = this.getTopLevelObject(string2);
                if (null == baseMetadataObject) {
                    String string3 = MdmDatabaseSchema.generateID(new String[]{this.getName(), string2});
                    aW = new AW(string, string3, 0, this.getBaseMetadataProvider());
                    this.addAW(aW);
                    aW.setOwner(this);
                    return aW;
                }
            }
        }
        if (baseMetadataObject instanceof AW) {
            aW = (AW)baseMetadataObject;
            this.addAW(aW);
        } else if (null != baseMetadataObject) {
            throw new DuplicateMetadataIDException(baseMetadataObject.getID());
        }
        return aW;
    }

    public MdmStandardDimension findOrCreateStandardDimension(String string) {
        return this.findOrCreateStandardDimension(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmStandardDimension findOrCreateStandardDimension(String string, String string2) {
        MdmStandardDimension mdmStandardDimension = null;
        MdmObject mdmObject = (MdmObject)this.getTopLevelObject(string2, string);
        if (null == mdmObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                mdmObject = (MdmObject)this.getTopLevelObject(string);
                if (null == mdmObject) {
                    String string3 = MdmDatabaseSchema.generateID(new String[]{this.getName(), string});
                    mdmStandardDimension = new MdmStandardDimension(string, string3, 0, this.getBaseMetadataProvider());
                    this.addDimension(mdmStandardDimension);
                    mdmStandardDimension.setOwner(this);
                    return mdmStandardDimension;
                }
            }
        }
        if (mdmObject instanceof MdmStandardDimension) {
            mdmStandardDimension = (MdmStandardDimension)mdmObject;
            this.addDimension(mdmStandardDimension);
        } else if (null != mdmObject) {
            throw new DuplicateMetadataIDException(mdmObject.getID());
        }
        return mdmStandardDimension;
    }

    public MdmTimeDimension findOrCreateTimeDimension(String string) {
        return this.findOrCreateTimeDimension(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmTimeDimension findOrCreateTimeDimension(String string, String string2) {
        MdmTimeDimension mdmTimeDimension = null;
        MdmObject mdmObject = (MdmObject)this.getTopLevelObject(string2, string);
        if (null == mdmObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                mdmObject = (MdmObject)this.getTopLevelObject(string);
                if (null == mdmObject) {
                    String string3 = MdmDatabaseSchema.generateID(new String[]{this.getName(), string});
                    mdmTimeDimension = new MdmTimeDimension(string, string3, 0, this.getBaseMetadataProvider());
                    this.addDimension(mdmTimeDimension);
                    mdmTimeDimension.setOwner(this);
                    return mdmTimeDimension;
                }
            }
        }
        if (mdmObject instanceof MdmTimeDimension) {
            mdmTimeDimension = (MdmTimeDimension)mdmObject;
            this.addDimension(mdmTimeDimension);
        } else if (null != mdmObject) {
            throw new DuplicateMetadataIDException(mdmObject.getID());
        }
        return mdmTimeDimension;
    }

    public MdmCube findOrCreateCube(String string) {
        return this.findOrCreateCube(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmCube findOrCreateCube(String string, String string2) {
        MdmCube mdmCube = null;
        MdmObject mdmObject = (MdmObject)this.getTopLevelObject(string2, string);
        if (null == mdmObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                mdmObject = (MdmObject)this.getTopLevelObject(string);
                if (null == mdmObject) {
                    String string3 = MdmDatabaseSchema.generateID(new String[]{this.getName(), string});
                    mdmCube = new MdmCube(string, string3, 0, this.getBaseMetadataProvider());
                    this.addCube(mdmCube);
                    mdmCube.setOwner(this);
                    return mdmCube;
                }
            }
        }
        if (mdmObject instanceof MdmCube) {
            mdmCube = (MdmCube)mdmObject;
            this.addCube(mdmCube);
        } else if (null != mdmObject) {
            throw new DuplicateMetadataIDException(mdmObject.getID());
        }
        return mdmCube;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdmNamedBuildProcess findOrCreateNamedBuildProcess(String string) {
        MdmNamedBuildProcess mdmNamedBuildProcess = null;
        MdmObject mdmObject = (MdmObject)this.getTopLevelObject(string);
        if (null == mdmObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                mdmObject = (MdmObject)this.getTopLevelObject(string);
                if (null == mdmObject) {
                    String string2 = MdmDatabaseSchema.generateID(new String[]{this.getName(), string});
                    mdmNamedBuildProcess = new MdmNamedBuildProcess(string, string2, 0, this.getBaseMetadataProvider());
                    this.addNamedBuildProcess(mdmNamedBuildProcess);
                    mdmNamedBuildProcess.setOwner(this);
                    return mdmNamedBuildProcess;
                }
            }
        }
        if (mdmObject instanceof MdmNamedBuildProcess) {
            mdmNamedBuildProcess = (MdmNamedBuildProcess)mdmObject;
            this.addNamedBuildProcess(mdmNamedBuildProcess);
        } else if (null != mdmObject) {
            throw new DuplicateMetadataIDException(mdmObject.getID());
        }
        return mdmNamedBuildProcess;
    }

    public final List<AW> getAWs() {
        return this.getPropertyListValues(MdmXMLTags.AW_REF_CONTAINED);
    }

    public final void addAW(AW aW) {
        this.addToListProperty(MdmXMLTags.AW_REF_CONTAINED, aW);
    }

    public final void removeAW(AW aW) {
        this.removeFromListProperty(MdmXMLTags.AW_REF_CONTAINED, aW);
    }

    public final void removeAW(AW aW, boolean bl) {
        List<AW> list;
        Object object;
        Object object2;
        ArrayList<Object> arrayList22;
        if (!bl) {
            this.removeAW(aW);
            return;
        }
        if (this != aW.getOwner()) {
            return;
        }
        List list2 = aW.getCubes();
        for (ArrayList<Object> arrayList22 : list2) {
            this.removeCube((MdmCube)((Object)arrayList22));
        }
        List list3 = aW.getDimensions();
        arrayList22 = list3.iterator();
        while (arrayList22.hasNext()) {
            object2 = (MdmPrimaryDimension)arrayList22.next();
            this.removeDimension((MdmPrimaryDimension)object2);
        }
        arrayList22 = new ArrayList<Object>();
        object2 = this.getOrganizationalSchemas();
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            object = (MdmOrganizationalSchema)object3.next();
            int n = 0;
            list = ((MdmSchema)object).getMeasures();
            for (MdmMeasure mdmMeasure : list) {
                CubeOrganization cubeOrganization = mdmMeasure.getCube().getOrganization();
                if (!(cubeOrganization instanceof AWCubeOrganization) || ((AWCubeOrganization)cubeOrganization).getAW() != aW) continue;
                ((MdmSchema)object).removeMeasure(mdmMeasure);
                ++n;
            }
            if (list.size() != n || n <= 0) continue;
            arrayList22.add(object);
            this.removeOrganizationalSchema((MdmOrganizationalSchema)object);
        }
        object2.removeAll(arrayList22);
        object3 = object2.iterator();
        while (object3.hasNext()) {
            object = (MdmOrganizationalSchema)object3.next();
            List list4 = ((MdmOrganizationalSchema)object).getSubSchemas();
            for (Object object4 : list4) {
                if (!arrayList22.contains(object4)) continue;
                ((MdmOrganizationalSchema)object).removeSubSchema((MdmSchema)object4);
            }
        }
        object3 = this.getNamedBuildProcesses();
        object = object3.iterator();
        while (object.hasNext()) {
            MdmNamedBuildProcess mdmNamedBuildProcess = (MdmNamedBuildProcess)object.next();
            list = mdmNamedBuildProcess.getReferencedAWs();
            if (1 != list.size() || list.get(0) != aW) continue;
            this.removeNamedBuildProcess(mdmNamedBuildProcess);
        }
        this.removeAW(aW);
    }

    @Override
    public List getMeasures() {
        ArrayList<MdmMeasure> arrayList = new ArrayList<MdmMeasure>();
        this.getMeasures(arrayList);
        return arrayList;
    }

    @Override
    protected void appendXMLString(MetadataToXMLConverter metadataToXMLConverter, XMLTag xMLTag) {
        if (metadataToXMLConverter.getXMLFormat().is10gMode()) {
            super.appendXMLString(metadataToXMLConverter, xMLTag);
            return;
        }
        BaseMetadataObjectState baseMetadataObjectState = null;
        ArraySet arraySet = new ArraySet();
        if (metadataToXMLConverter.getXMLFormat().is11gPartialXMLMode()) {
            baseMetadataObjectState = metadataToXMLConverter.getIncrementalSendState(this);
            baseMetadataObjectState.getDeletedChildren(arraySet);
            for (BaseMetadataObject baseMetadataObject : arraySet) {
                metadataToXMLConverter.appendAttributeToNextElement(BaseMetadataXMLTags.ACTION, "REMOVE");
                baseMetadataObject.appendObjectRefXMLString(null, null, metadataToXMLConverter);
            }
        }
    }

    protected void getMeasures(List<MdmMeasure> list) {
        List list2 = this.getCubes();
        for (MdmCube mdmCube : list2) {
            list.addAll(mdmCube.getMeasures());
        }
    }

    @Override
    public final void addMeasure(MdmMeasure mdmMeasure) {
        throw new UnsupportedOperationException("MdmDatabaseSchema.addMeasure()");
    }

    @Override
    public final void removeMeasure(MdmMeasure mdmMeasure) {
        throw new UnsupportedOperationException("MdmDatabaseSchema.removeMeasure()");
    }

    public List getPersistentLanguages() {
        int n = this.getCubes().size() + this.getDimensions().size() + this.getOrganizationalSchemas().size() + this.getNamedBuildProcesses().size();
        String[] stringArray = new String[n];
        ArrayList arrayList = new ArrayList();
        this.addIDs(this.getCubes(), arrayList);
        this.addIDs(this.getDimensions(), arrayList);
        this.addIDs(this.getOrganizationalSchemas(), arrayList);
        this.addIDs(this.getNamedBuildProcesses(), arrayList);
        arrayList.toArray(stringArray);
        return PersistentLanguageFetcher.fetchPersistentLanguages(stringArray, this.getMetadataProvider().getDataProvider());
    }

    private void addIDs(List list, List list2) {
        for (MdmObject mdmObject : list) {
            list2.add(mdmObject.getID());
        }
    }

    @Override
    protected String generateInternalID() {
        return null;
    }
}

