/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.Iterator;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLSourceColumn;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValueComparisonCondition;

abstract class LegacyXMLExternalSourceExpression
extends LegacyXMLBaseObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.SOURCE_COLUMNS, LegacyXMLTags.TARGET_OBJECT_REF};

    protected LegacyXMLExternalSourceExpression(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    final List<LegacyXMLSourceColumn> getSourceColumns() {
        return this.getPropertyListValues(LegacyXMLTags.SOURCE_COLUMNS);
    }

    final LegacyXMLBaseObject getTargetObject() {
        return (LegacyXMLBaseObject)this.getPropertyObjectValue(LegacyXMLTags.TARGET_OBJECT_REF);
    }

    final TypedExpression getSourceColumnsKeyExpression() {
        StringBuffer stringBuffer = new StringBuffer();
        List<LegacyXMLSourceColumn> list = this.getSourceColumns();
        if (null != list) {
            boolean bl = true;
            Iterator<LegacyXMLSourceColumn> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuffer.append(" || '_' || ");
                } else {
                    bl = false;
                }
                LegacyXMLSourceColumn legacyXMLSourceColumn = iterator.next();
                stringBuffer.append(legacyXMLSourceColumn.getColumn());
            }
        }
        return (TypedExpression)this.toSyntaxExpression(stringBuffer.toString());
    }

    final TypedExpression getSourceColumnsDataExpression() {
        List<LegacyXMLSourceColumn> list = this.getSourceColumns();
        if (null == list || list.size() == 0) {
            return null;
        }
        LegacyXMLSourceColumn legacyXMLSourceColumn = list.get(0);
        return (TypedExpression)this.toSyntaxExpression(legacyXMLSourceColumn.getColumn());
    }

    final Query getSourceColumnsQuery() {
        String string = null;
        List<LegacyXMLSourceColumn> list = this.getSourceColumns();
        if (null != list && list.size() > 0) {
            LegacyXMLSourceColumn legacyXMLSourceColumn = list.get(0);
            string = legacyXMLSourceColumn.getTableID();
        }
        return this.toSyntaxQuery(string);
    }

    final Condition getSourceColumnsJoinCondition(TypedExpression typedExpression) {
        return new ValueComparisonCondition(this.getSourceColumnsKeyExpression(), "=", typedExpression);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        List<LegacyXMLSourceColumn> list = this.getSourceColumns();
        legacyXMLConverter.validateRequiredProperty(LegacyXMLTags.SOURCE_COLUMNS, list, this);
        String string = null;
        for (LegacyXMLSourceColumn legacyXMLSourceColumn : list) {
            if (!legacyXMLSourceColumn.validate(legacyXMLConverter, false)) {
                return false;
            }
            String string2 = legacyXMLSourceColumn.getTableID();
            if (null == string) {
                string = string2;
                continue;
            }
            if (null != string2 && string2.equals(string)) continue;
            legacyXMLConverter.reportError("UnsupportedSourceColumnsConversion", this.getID());
        }
        return true;
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        List<LegacyXMLSourceColumn> list = this.getSourceColumns();
        if (null == list || list.size() == 0) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        int n = -1;
        for (LegacyXMLSourceColumn legacyXMLSourceColumn : list) {
            int n2 = legacyXMLSourceColumn.getConvertOrderNumber(legacyXMLConverter, false);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }
}

