/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAW;
import oracle.olapi.metadata.conversion.LegacyXMLAWObject;
import oracle.olapi.metadata.conversion.LegacyXMLAggregationDefinition;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLCubeDimRef;
import oracle.olapi.metadata.conversion.LegacyXMLDerivedMeasure;
import oracle.olapi.metadata.conversion.LegacyXMLDimension;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchy;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchyLevelAssociation;
import oracle.olapi.metadata.conversion.LegacyXMLLevel;
import oracle.olapi.metadata.conversion.LegacyXMLMeasure;
import oracle.olapi.metadata.conversion.LegacyXMLOlapMeasure;
import oracle.olapi.metadata.conversion.LegacyXMLSolveDefinition;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.deployment.AWCubeOrganization;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;

final class LegacyXMLCube
extends LegacyXMLAWObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.SPARSE_TYPE, LegacyXMLTags.DEFAULT_DATA_TYPE, LegacyXMLTags.AUTO_SOLVE, LegacyXMLTags.USE_GLOBAL_INDEX, LegacyXMLTags.DEFAULT_AGGREGATION_DEFINITION_REF, LegacyXMLTags.PARTITION_HIERARCHY_REF, LegacyXMLTags.PARTITION_LEVEL_REF, LegacyXMLTags.SOLVE_DEFINITIONS, LegacyXMLTags.CUBE_DIM_REFS, LegacyXMLTags.MEASURES, LegacyXMLTags.DERIVED_MEASURES, LegacyXMLTags.OLAP_MEASURES};

    protected LegacyXMLCube(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    String getSparseType() {
        return this.getPropertyStringValue(LegacyXMLTags.SPARSE_TYPE);
    }

    String getDefaultDataType() {
        return this.getPropertyStringValue(LegacyXMLTags.DEFAULT_DATA_TYPE);
    }

    String getAutoSolve() {
        return this.getPropertyStringValue(LegacyXMLTags.AUTO_SOLVE);
    }

    boolean getUseGlobalIndex() {
        return this.getPropertyBooleanValue(LegacyXMLTags.USE_GLOBAL_INDEX);
    }

    LegacyXMLAggregationDefinition getDefaultAggregationDefinition() {
        return (LegacyXMLAggregationDefinition)this.getPropertyObjectValue(LegacyXMLTags.DEFAULT_AGGREGATION_DEFINITION_REF);
    }

    LegacyXMLHierarchy getPartitionHierarchy() {
        return (LegacyXMLHierarchy)this.getPropertyObjectValue(LegacyXMLTags.PARTITION_HIERARCHY_REF);
    }

    LegacyXMLLevel getPartitionLevel() {
        return (LegacyXMLLevel)this.getPropertyObjectValue(LegacyXMLTags.PARTITION_LEVEL_REF);
    }

    List<LegacyXMLSolveDefinition> getSolveDefinitions() {
        return this.getPropertyListValues(LegacyXMLTags.SOLVE_DEFINITIONS);
    }

    List<LegacyXMLCubeDimRef> getCubeDimRefs() {
        return this.getPropertyListValues(LegacyXMLTags.CUBE_DIM_REFS);
    }

    List<LegacyXMLMeasure> getMeasures() {
        return this.getPropertyListValues(LegacyXMLTags.MEASURES);
    }

    List<LegacyXMLDerivedMeasure> getDerivedMeasures() {
        return this.getPropertyListValues(LegacyXMLTags.DERIVED_MEASURES);
    }

    List<LegacyXMLOlapMeasure> getOlapMeasures() {
        return this.getPropertyListValues(LegacyXMLTags.OLAP_MEASURES);
    }

    LegacyXMLAW getAW() {
        return (LegacyXMLAW)this.getContainedByObject();
    }

    MdmCube getMdmCube() {
        return (MdmCube)this.getConvertToObject();
    }

    boolean hasSparseDimension() {
        for (LegacyXMLCubeDimRef legacyXMLCubeDimRef : this.getCubeDimRefs()) {
            if (!legacyXMLCubeDimRef.getSparse()) continue;
            return true;
        }
        return false;
    }

    LegacyXMLCubeDimRef getCubeDimRef(LegacyXMLDimension legacyXMLDimension) {
        for (LegacyXMLCubeDimRef legacyXMLCubeDimRef : this.getCubeDimRefs()) {
            if (legacyXMLCubeDimRef.getDimension() != legacyXMLDimension) continue;
            return legacyXMLCubeDimRef;
        }
        return null;
    }

    LegacyXMLHierarchyLevelAssociation getPartitionedHierarchyLevelAssociation() {
        if (null != this.getPartitionLevel() && null != this.getPartitionHierarchy()) {
            LegacyXMLLevel legacyXMLLevel = this.getPartitionLevel();
            return this.getPartitionHierarchy().getHierarchyLevelAssociation(legacyXMLLevel);
        }
        return null;
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.CUBE_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation = this.getPartitionedHierarchyLevelAssociation();
        return null == legacyXMLHierarchyLevelAssociation || legacyXMLHierarchyLevelAssociation.isValid();
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        MdmDatabaseSchema mdmDatabaseSchema = this.getMdmDatabaseSchema(legacyXMLConverter);
        MdmCube mdmCube = mdmDatabaseSchema.findOrCreateCube(this.getName());
        if (mdmCube.isPersistent()) {
            legacyXMLConverter.reportError("DuplicateMetadataID", mdmCube.getID());
        }
        AW aW = this.getAW().getMdmAW();
        AWCubeOrganization aWCubeOrganization = mdmCube.findOrCreateAWCubeOrganization(aW);
        if (!this.hasSparseDimension()) {
            aWCubeOrganization.setSparseType("DENSE");
            aWCubeOrganization.setMeasureStorage("INDEPENDENT");
        } else if ("COMPRESSED" == this.getSparseType()) {
            aWCubeOrganization.setSparseType("COMPRESSED");
            aWCubeOrganization.setMeasureStorage("SHARED");
        } else if (null == this.getPartitionLevel() || !this.getUseGlobalIndex()) {
            aWCubeOrganization.setSparseType("SPARSE");
            aWCubeOrganization.setMeasureStorage("INDEPENDENT");
        } else {
            aWCubeOrganization.setSparseType("SPARSE_GLOBAL");
            aWCubeOrganization.setMeasureStorage("INDEPENDENT");
        }
        LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation = this.getPartitionedHierarchyLevelAssociation();
        if (null != legacyXMLHierarchyLevelAssociation) {
            aWCubeOrganization.setPartitionLevel(legacyXMLHierarchyLevelAssociation.getMdmHierarchyLevel());
        }
        this.setMdmCube(mdmCube);
        super.convertToMdm(legacyXMLConverter);
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        LegacyXMLHierarchyLevelAssociation legacyXMLHierarchyLevelAssociation = this.getPartitionedHierarchyLevelAssociation();
        if (null != legacyXMLHierarchyLevelAssociation) {
            return legacyXMLHierarchyLevelAssociation.getConvertOrderNumber(legacyXMLConverter) + 1;
        }
        return super.getBaseConvertOrderNumber(legacyXMLConverter);
    }

    private void setMdmCube(MdmCube mdmCube) {
        this.setConvertToObject(mdmCube);
    }
}

