/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAttribute;
import oracle.olapi.metadata.conversion.LegacyXMLAttributeProjection;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLDimensionMapGroup;
import oracle.olapi.metadata.conversion.LegacyXMLExternalSourceExpression;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchy;
import oracle.olapi.metadata.conversion.LegacyXMLLevel;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mapping.AttributeMap;
import oracle.olapi.metadata.mapping.DimensionMap;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.syntax.TypedExpression;

final class LegacyXMLAttributeSourceExpression
extends LegacyXMLExternalSourceExpression {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.LANGUAGE, LegacyXMLTags.LEVEL_REF, LegacyXMLTags.HIERARCHY_REF, LegacyXMLTags.BASE_ATTRIBUTE_REF};

    protected LegacyXMLAttributeSourceExpression(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    String getLanguage() {
        return this.getPropertyStringValue(LegacyXMLTags.LANGUAGE);
    }

    LegacyXMLLevel getLevel() {
        return (LegacyXMLLevel)this.getPropertyObjectValue(LegacyXMLTags.LEVEL_REF);
    }

    LegacyXMLHierarchy getHierarchy() {
        return (LegacyXMLHierarchy)this.getPropertyObjectValue(LegacyXMLTags.HIERARCHY_REF);
    }

    LegacyXMLAttribute getBaseAttribute() {
        return (LegacyXMLAttribute)this.getPropertyObjectValue(LegacyXMLTags.BASE_ATTRIBUTE_REF);
    }

    LegacyXMLDimensionMapGroup getDimensionMapGroup() {
        return (LegacyXMLDimensionMapGroup)this.getContainedByObject();
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.ATTRIBUTE_SOURCE_EXPRESSION_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        legacyXMLConverter.validateRequiredProperty(LegacyXMLTags.BASE_ATTRIBUTE_REF, this.getBaseAttribute(), this);
        if (!this.getBaseAttribute().isValid()) {
            return false;
        }
        LegacyXMLAttribute legacyXMLAttribute = null;
        if (this.getTargetObject() instanceof LegacyXMLAttributeProjection) {
            legacyXMLAttribute = ((LegacyXMLAttributeProjection)this.getTargetObject()).getAttribute();
        }
        if (legacyXMLAttribute != this.getBaseAttribute()) {
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.TARGET_OBJECT_REF, this.getTargetObject(), this);
        }
        this.getDimensionMapGroup().getAWObject().validateSubDimRefs(legacyXMLConverter, this.getHierarchy(), this.getLevel(), this);
        return true;
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        MdmBaseAttribute mdmBaseAttribute = this.getBaseAttribute().getMdmBaseAttribute();
        DimensionMap dimensionMap = this.getDimensionMapGroup().getMdmDimensionMap();
        AttributeMap attributeMap = dimensionMap.findOrCreateAttributeMap(mdmBaseAttribute);
        TypedExpression typedExpression = this.getSourceColumnsKeyExpression();
        if (null != typedExpression) {
            attributeMap.setExpression(typedExpression);
        }
        if (null != this.getLanguage() && this.getLanguage().length() > 0) {
            attributeMap.setLanguage(this.getLanguage());
        }
        super.convertToMdm(legacyXMLConverter);
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        if (null != this.getBaseAttribute()) {
            return this.getBaseAttribute().getConvertOrderNumber(legacyXMLConverter) + 1;
        }
        return super.getBaseConvertOrderNumber(legacyXMLConverter);
    }
}

