/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.Iterator;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAggregation;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLDimension;
import oracle.olapi.metadata.conversion.LegacyXMLHierarchy;
import oracle.olapi.metadata.conversion.LegacyXMLPreComputeClause;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.AggregationCommand;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.FunctionArgument;

final class LegacyXMLAggregationHierarchySpecification
extends LegacyXMLAggregation {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.DIMENSION_REF, LegacyXMLTags.HIERARCHIES_REF, LegacyXMLTags.PRE_COMPUTE_CLAUSE};

    protected LegacyXMLAggregationHierarchySpecification(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    LegacyXMLDimension getDimension() {
        return (LegacyXMLDimension)this.getPropertyObjectValue(LegacyXMLTags.DIMENSION_REF);
    }

    List<LegacyXMLHierarchy> getHierarchies() {
        return this.getPropertyListValues(LegacyXMLTags.HIERARCHIES_REF);
    }

    LegacyXMLPreComputeClause getPreComputeClause() {
        return (LegacyXMLPreComputeClause)this.getPropertyObjectValue(LegacyXMLTags.PRE_COMPUTE_CLAUSE);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.AGGREGATION_HIER_SPECIFICATION_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        LegacyXMLDimension legacyXMLDimension = this.getDimension();
        if (null != legacyXMLDimension && !legacyXMLDimension.isValid()) {
            return false;
        }
        List<LegacyXMLHierarchy> list = this.getHierarchies();
        if (null == list || list.size() == 0) {
            legacyXMLConverter.validateRequiredProperty(LegacyXMLTags.DIMENSION_REF, legacyXMLDimension, this);
        } else {
            for (LegacyXMLHierarchy legacyXMLHierarchy : list) {
                if (!legacyXMLHierarchy.isValid()) {
                    return false;
                }
                if (null != legacyXMLDimension && legacyXMLHierarchy.getDimension() != legacyXMLDimension) {
                    legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.HIERARCHIES_REF, legacyXMLHierarchy, this);
                    return false;
                }
                if (null != legacyXMLDimension) continue;
                legacyXMLDimension = legacyXMLHierarchy.getDimension();
            }
        }
        return null == this.getPreComputeClause() || this.getPreComputeClause().validate(legacyXMLConverter, false);
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        int n;
        int n2;
        int n3 = -1;
        List<LegacyXMLHierarchy> list = this.getHierarchies();
        for (LegacyXMLHierarchy legacyXMLHierarchy : list) {
            int n4 = legacyXMLHierarchy.getConvertOrderNumber(legacyXMLConverter);
            if (n4 <= n3) continue;
            n3 = n4;
        }
        if (null != this.getDimension() && (n2 = this.getDimension().getConvertOrderNumber(legacyXMLConverter)) > n3) {
            n3 = n2;
        }
        if (null != this.getPreComputeClause() && (n = this.getPreComputeClause().getConvertOrderNumber(legacyXMLConverter, false)) > n3) {
            n3 = n;
        }
        if (-1 == n3) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        return n3;
    }

    @Override
    Condition createPrecomputeCondition() {
        if (null != this.getPreComputeClause()) {
            return this.getPreComputeClause().createPrecomputeCondition();
        }
        return null;
    }

    @Override
    LegacyXMLDimension getAggregationDimension() {
        if (null != this.getDimension()) {
            return this.getDimension();
        }
        List<LegacyXMLHierarchy> list = this.getHierarchies();
        if (null != list && list.size() > 0) {
            LegacyXMLHierarchy legacyXMLHierarchy = list.get(0);
            return legacyXMLHierarchy.getDimension();
        }
        return null;
    }

    @Override
    AggregationCommand createAggregationCommand(String string, FunctionArgument[] functionArgumentArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        MdmPrimaryDimension mdmPrimaryDimension = null;
        MdmHierarchy[] mdmHierarchyArray = null;
        List<LegacyXMLHierarchy> list = this.getHierarchies();
        if (null != list && list.size() > 0) {
            mdmHierarchyArray = new MdmHierarchy[list.size()];
            Iterator<LegacyXMLHierarchy> iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                LegacyXMLHierarchy legacyXMLHierarchy = iterator.next();
                mdmHierarchyArray[n] = legacyXMLHierarchy.getMdmHierarchy();
                if (null == mdmPrimaryDimension) {
                    mdmPrimaryDimension = mdmHierarchyArray[n].getPrimaryDimension();
                }
                ++n;
            }
        } else {
            mdmPrimaryDimension = this.getDimension().getMdmPrimaryDimension();
        }
        return new AggregationCommand(string, functionArgumentArray, null, mdmPrimaryDimension, mdmHierarchyArray, bl, bl2, bl3, bl4);
    }
}

