/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLCalculationSpecification;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLCube;
import oracle.olapi.metadata.conversion.LegacyXMLDimension;
import oracle.olapi.metadata.conversion.LegacyXMLSolveDefDimRef;
import oracle.olapi.metadata.conversion.LegacyXMLSolveDefinition;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.deployment.AWCubeOrganization;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.ConsistentSolveCommand;
import oracle.olapi.syntax.ConsistentSolveSpecification;
import oracle.olapi.syntax.SymmetricCondition;

final class LegacyXMLAggregationDefinition
extends LegacyXMLSolveDefinition {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.AGG_INDEX, LegacyXMLTags.CACHE_STORE, LegacyXMLTags.CACHE_NA, LegacyXMLTags.CALCULATION_SPECIFICATIONS, LegacyXMLTags.SOLVE_DEF_DIM_REFS};

    protected LegacyXMLAggregationDefinition(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    String getAggIndex() {
        return this.getPropertyStringValue(LegacyXMLTags.AGG_INDEX);
    }

    String getCacheStore() {
        return this.getPropertyStringValue(LegacyXMLTags.CACHE_STORE);
    }

    String getCacheNa() {
        return this.getPropertyStringValue(LegacyXMLTags.CACHE_NA);
    }

    List<LegacyXMLCalculationSpecification> getCalculationSpecifications() {
        return this.getPropertyListValues(LegacyXMLTags.CALCULATION_SPECIFICATIONS);
    }

    List<LegacyXMLSolveDefDimRef> getSolveDefDimRefs() {
        return this.getPropertyListValues(LegacyXMLTags.SOLVE_DEF_DIM_REFS);
    }

    LegacyXMLCube getCube() {
        return (LegacyXMLCube)this.getContainedByObject();
    }

    List<LegacyXMLCalculationSpecification> getSortedCalculationSpecifications() {
        List<LegacyXMLCalculationSpecification> list = this.getCalculationSpecifications();
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((LegacyXMLCalculationSpecification)object).getCalculationOrder();
                return n2 > (n = ((LegacyXMLCalculationSpecification)object2).getCalculationOrder()) ? 1 : (n2 < n ? -1 : 0);
            }
        });
        return list;
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.AGGREGATION_DEFINITION_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        List<LegacyXMLCalculationSpecification> list = this.getCalculationSpecifications();
        legacyXMLConverter.validateRequiredProperty(LegacyXMLTags.CALCULATION_SPECIFICATIONS, list, this);
        for (LegacyXMLCalculationSpecification legacyXMLCalculationSpecification : list) {
            if (legacyXMLCalculationSpecification.validate(legacyXMLConverter, false)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        ConsistentSolveSpecification consistentSolveSpecification = this.createConsistentSolveSpecification();
        if (this.getCube().getDefaultAggregationDefinition() == this) {
            MdmCube mdmCube = this.getCube().getMdmCube();
            mdmCube.setConsistentSolveSpecification(consistentSolveSpecification);
            SymmetricCondition symmetricCondition = this.createPrecomputeCondition();
            if (null != symmetricCondition) {
                AWCubeOrganization aWCubeOrganization = (AWCubeOrganization)mdmCube.getOrganization();
                aWCubeOrganization.setPrecomputeCondition(symmetricCondition);
            }
        }
        this.setSynConsistentSolveSpecification(consistentSolveSpecification);
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        int n = -1;
        List<LegacyXMLCalculationSpecification> list = this.getCalculationSpecifications();
        for (LegacyXMLCalculationSpecification legacyXMLCalculationSpecification : list) {
            int n2 = legacyXMLCalculationSpecification.getConvertOrderNumber(legacyXMLConverter, false);
            if (n2 <= n) continue;
            n = n2;
        }
        if (-1 == n) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        return n;
    }

    private ConsistentSolveSpecification createConsistentSolveSpecification() {
        List<LegacyXMLCalculationSpecification> list = this.getSortedCalculationSpecifications();
        ArrayList<ConsistentSolveCommand> arrayList = new ArrayList<ConsistentSolveCommand>(list.size());
        for (LegacyXMLCalculationSpecification legacyXMLCalculationSpecification : list) {
            ConsistentSolveCommand consistentSolveCommand = legacyXMLCalculationSpecification.createConsistentSolveCommand();
            if (null == consistentSolveCommand) continue;
            arrayList.add(consistentSolveCommand);
        }
        return new ConsistentSolveSpecification(arrayList);
    }

    private SymmetricCondition createPrecomputeCondition() {
        List<LegacyXMLCalculationSpecification> list = this.getSortedCalculationSpecifications();
        ArrayList<Condition> arrayList = new ArrayList<Condition>(list.size());
        ArrayList<MdmPrimaryDimension> arrayList2 = new ArrayList<MdmPrimaryDimension>(list.size());
        for (LegacyXMLCalculationSpecification legacyXMLCalculationSpecification : list) {
            Condition condition = legacyXMLCalculationSpecification.createPrecomputeCondition();
            if (null == condition) continue;
            arrayList.add(condition);
            LegacyXMLDimension legacyXMLDimension = legacyXMLCalculationSpecification.getAggregationDimension();
            arrayList2.add(legacyXMLDimension.getMdmPrimaryDimension());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return new SymmetricCondition(arrayList2, arrayList);
    }
}

