/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.express.idl.ExpressMdmModule.MetadataProviderInterface;
import oracle.express.idl.util.WstringHolder;
import oracle.express.olapi.data.full.ExpressDataProvider;
import oracle.express.olapi.transaction.ExpressTransactionProvider;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.olapi.transaction.TransactionProvider;

public class ServerXMLReader {
    public static final String JDBC_URL_PROPERTY_NAME = "url";
    public static final String USER_ID_PROPERTY_NAME = "user";
    public static final String PASSWORD_PROPERTY_NAME = "password";

    public static void main(String[] stringArray) {
        new ServerXMLReader().run(stringArray);
    }

    private void run(String[] stringArray) {
        Properties properties = this.parseCommandLineProperties(stringArray);
        try {
            OracleConnection oracleConnection = this.connect(properties);
            ExpressDataProvider expressDataProvider = new ExpressDataProvider(oracleConnection, (TransactionProvider)new ExpressTransactionProvider(), properties);
            expressDataProvider.initialize();
            MetadataProviderInterface metadataProviderInterface = expressDataProvider.getMetadataProviderInterface();
            WstringHolder wstringHolder = new WstringHolder();
            String[] stringArray2 = new String[]{"RootSchema"};
            metadataProviderInterface.getMetadataCLOB(stringArray2, wstringHolder);
            System.out.println(wstringHolder.value);
            metadataProviderInterface.getMetadataCLOB(stringArray2, wstringHolder);
            System.out.println(wstringHolder.value);
            oracleConnection.close();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            throw new RuntimeException(exception.toString());
        }
    }

    private Properties parseCommandLineProperties(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i + 1 == stringArray.length) {
                throw new IllegalArgumentException("Command-line arguments must be specified in the form -<PropertyName> <PropertyValue>, with name and value separated by whitespace.");
            }
            properties.put(stringArray[i].substring(1), stringArray[i + 1]);
        }
        return properties;
    }

    private OracleConnection connect(Properties properties) throws SQLException {
        String string = (String)properties.get(JDBC_URL_PROPERTY_NAME);
        if (null == string) {
            throw new IllegalArgumentException("Must specifiy -url");
        }
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection connection = DriverManager.getConnection(string, properties);
        return (OracleConnection)connection;
    }
}

