/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.MetadataXMLReaderState;
import oracle.olapi.metadata.XMLReaderPropertyAction;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.xml.TagHandler;
import oracle.olapi.xml.XMLState;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

final class MetadataXMLReaderElementState
extends MetadataXMLReaderState {
    private BaseMetadataObject m_CurrentMetadataObject = null;
    private boolean m_IsNewObject = false;

    void addPropertyValue(XMLTag xMLTag, String string, XMLReaderPropertyAction xMLReaderPropertyAction, MetadataXMLReader metadataXMLReader) throws SAXException {
        metadataXMLReader.initializeProperty(this.getCurrentMetadataObject(), xMLTag, string, xMLReaderPropertyAction);
    }

    void addPair(XMLTag xMLTag, MetadataObjectHolder metadataObjectHolder, MetadataObjectHolder metadataObjectHolder2, XMLReaderPropertyAction xMLReaderPropertyAction, MetadataXMLReader metadataXMLReader) throws SAXException {
        xMLTag.initializePairProperty(this.getCurrentMetadataObject(), metadataObjectHolder.getObjectID(), metadataObjectHolder2.getObjectID(), xMLReaderPropertyAction);
    }

    @Override
    protected void enter(String string, Attributes attributes, TagHandler tagHandler) throws SAXException {
        MetadataXMLReader metadataXMLReader = (MetadataXMLReader)tagHandler;
        if (this.isContainerElementState()) {
            XMLReaderPropertyAction xMLReaderPropertyAction = metadataXMLReader.getPropertyAction(this.getPropertyTag(), attributes, false);
            this.setPropertyAction(xMLReaderPropertyAction);
            return;
        }
        BaseMetadataObject baseMetadataObject = null;
        MetadataXMLReaderElementState metadataXMLReaderElementState = this.getEffectiveParent();
        if (null != metadataXMLReaderElementState) {
            baseMetadataObject = metadataXMLReaderElementState.getCurrentMetadataObject();
        }
        XMLTag xMLTag = this.getPropertyTag();
        BaseMetadataObject baseMetadataObject2 = metadataXMLReader.findOrCreateMetadataObject(xMLTag, baseMetadataObject, attributes);
        this.setIsNewObject(metadataXMLReader.isNewObject());
        this.setCurrentMetadataObject(baseMetadataObject2);
        XMLTag xMLTag2 = this.getPropertyTag();
        XMLReaderPropertyAction xMLReaderPropertyAction = null;
        if (null != metadataXMLReaderElementState && this.getParent().isContainerElementState()) {
            xMLTag2 = this.getParent().getPropertyTag();
            XMLReaderPropertyAction xMLReaderPropertyAction2 = this.getParent().getPropertyAction();
            if (null != xMLReaderPropertyAction2) {
                xMLReaderPropertyAction = metadataXMLReader.getPropertyAction(xMLTag2, attributes, false);
                if (null != xMLReaderPropertyAction && xMLReaderPropertyAction.getAction() != xMLReaderPropertyAction2.getAction()) {
                    metadataXMLReader.reportError("InvalidXMLAttr", new String[]{"Action", metadataXMLReader.getAttributeValue(attributes, BaseMetadataXMLTags.ACTION, false), this.getFullXmlTagName(metadataXMLReader)});
                }
                xMLReaderPropertyAction = xMLReaderPropertyAction2;
            }
        }
        if (null == xMLReaderPropertyAction) {
            xMLReaderPropertyAction = metadataXMLReader.getPropertyAction(xMLTag2, attributes, this.isNewObject());
        }
        if (null != metadataXMLReaderElementState && null != xMLReaderPropertyAction) {
            metadataXMLReaderElementState.addContainedObject(baseMetadataObject2, xMLTag2, xMLReaderPropertyAction, this.isNewObject(), metadataXMLReader);
        }
        this.initializeAttributes(attributes, xMLReaderPropertyAction, metadataXMLReader);
    }

    @Override
    protected MetadataXMLReaderState exit(TagHandler tagHandler) throws SAXException {
        MetadataXMLReader metadataXMLReader = (MetadataXMLReader)tagHandler;
        MetadataXMLReaderState metadataXMLReaderState = null;
        this.setPropertyAction(null);
        metadataXMLReaderState = null == this.getParent() ? metadataXMLReader.getMetadataInitialState() : this.getParent();
        metadataXMLReader.removeElementState();
        return metadataXMLReaderState;
    }

    BaseMetadataObject getCurrentMetadataObject() {
        return this.m_CurrentMetadataObject;
    }

    public void initializeAttributes(Attributes attributes, XMLReaderPropertyAction xMLReaderPropertyAction, MetadataXMLReader metadataXMLReader) throws SAXException {
        Object object;
        metadataXMLReader.setInAttributes(true);
        String string = metadataXMLReader.getXMLFormat().getVersion();
        int n = attributes.getLength();
        boolean bl = false;
        XMLReaderPropertyAction xMLReaderPropertyAction2 = metadataXMLReader.getDefaultPropertyAction();
        for (int i = 0; i < n; ++i) {
            object = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            XMLTag xMLTag = this.getCurrentMetadataObject().getPropertyXMLTag((String)object, string);
            if (xMLTag == BaseMetadataXMLTags.OWNER) {
                bl = true;
            }
            if (null != xMLReaderPropertyAction && xMLReaderPropertyAction.hasPropertyXMLTag((String)object, string) || metadataXMLReader.canSkipPropertyXMLTag(xMLTag, this.getCurrentMetadataObject())) continue;
            if (!metadataXMLReader.isValidPropertyXMLTag(xMLTag, this.getCurrentMetadataObject(), true)) {
                String[] stringArray = new String[]{object, string2, null};
                metadataXMLReader.reportError("InvalidXMLAttr", stringArray);
                continue;
            }
            if (xMLTag == null) continue;
            string2 = metadataXMLReader.getAttributeValue(attributes, xMLTag);
            if (metadataXMLReader.suppressXMLAttribute(xMLTag, this.getCurrentMetadataObject().getID(), this.getCurrentMetadataObject().getClass(), (String)object, string2) || !this.isNewObject() && 3 == xMLTag.getXMLType()) continue;
            if (!metadataXMLReader.getXMLFormat().is10gMode() && (3 == xMLTag.getXMLType() && 0 == xMLTag.getDataType() || xMLTag.isXMLObjectReference())) {
                string2 = metadataXMLReader.getMetadataObjectRefID(xMLTag, this.getCurrentMetadataObject(), attributes);
            }
            if (BaseMetadataXMLTags.NAME == xMLTag) {
                string2 = metadataXMLReader.applyRename(this.getCurrentMetadataObject(), string2);
            }
            metadataXMLReader.initializeProperty(this.getCurrentMetadataObject(), xMLTag, string2, xMLReaderPropertyAction2);
        }
        metadataXMLReader.setInAttributes(false);
        if (null == this.getParent() && 0 == metadataXMLReader.getPersistenceType()) {
            BaseMetadataObject baseMetadataObject = this.getCurrentMetadataObject();
            if (null != metadataXMLReader.getContextSchema() && !bl && this.isNewObject()) {
                metadataXMLReader.initializeProperty(baseMetadataObject, BaseMetadataXMLTags.OWNER, metadataXMLReader.getContextSchema().getID(), xMLReaderPropertyAction2);
            }
            if ((object = baseMetadataObject.getOwner()) instanceof MdmDatabaseSchema && baseMetadataObject != object) {
                if (xMLReaderPropertyAction != null && xMLReaderPropertyAction.isRemove()) {
                    ((MdmDatabaseSchema)object).removeSchemaObject(baseMetadataObject);
                } else if (this.isNewObject()) {
                    ((MdmDatabaseSchema)object).addSchemaObject(baseMetadataObject);
                }
            }
        }
    }

    private void setCurrentMetadataObject(BaseMetadataObject baseMetadataObject) {
        this.m_CurrentMetadataObject = baseMetadataObject;
    }

    @Override
    protected XMLState transition(String string, Attributes attributes, TagHandler tagHandler) throws SAXException {
        MetadataXMLReader metadataXMLReader = (MetadataXMLReader)tagHandler;
        MetadataXMLReaderState metadataXMLReaderState = null;
        String string2 = metadataXMLReader.getXMLFormat().getVersion();
        XMLTag xMLTag = null;
        xMLTag = this.isContainerElementState() ? this.getPropertyTag().findObjectTag(string, string2) : this.getCurrentMetadataObject().getPropertyXMLTag(string, string2);
        if (!metadataXMLReader.isValidPropertyXMLTag(xMLTag, this.getCurrentMetadataObject(), false)) {
            return null;
        }
        if (null == xMLTag && metadataXMLReader.getXMLFormat().getMode() == 0) {
            metadataXMLReaderState = metadataXMLReader.getListItemState();
            return metadataXMLReaderState;
        }
        if (1 == xMLTag.getXMLType()) {
            metadataXMLReaderState = metadataXMLReader.getListItemState();
        } else if (xMLTag.isXMLObjectReference()) {
            metadataXMLReaderState = metadataXMLReader.getReferenceState();
        } else if (0 == xMLTag.getXMLType()) {
            metadataXMLReaderState = metadataXMLReader.getPairState();
        } else if (2 == xMLTag.getXMLType()) {
            metadataXMLReaderState = metadataXMLReader.getCDataAttributeState();
        } else {
            if (!xMLTag.isXMLContainedObject() && !this.isContainerElementState()) {
                return null;
            }
            if (metadataXMLReader.getXMLFormat().is10gMode()) {
                metadataXMLReaderState = metadataXMLReader.getReferenceState();
            } else if (7 == xMLTag.getXMLType() && null != metadataXMLReader.getAttributeValue(attributes, BaseMetadataXMLTags.NAME, false)) {
                metadataXMLReaderState = metadataXMLReader.getReferenceState();
            } else if (0 == xMLTag.getDataStructureType() && "REMOVE".equals(metadataXMLReader.getAttributeValue(attributes, BaseMetadataXMLTags.ACTION, false)) || "CLEAR".equals(metadataXMLReader.getAttributeValue(attributes, BaseMetadataXMLTags.ACTION, false))) {
                metadataXMLReaderState = metadataXMLReader.getReferenceState();
            } else {
                if (metadataXMLReader.canDeferElement(this, xMLTag)) {
                    return metadataXMLReader.deferElement(string);
                }
                metadataXMLReaderState = metadataXMLReader.getNextElementState();
            }
        }
        if (metadataXMLReaderState != null) {
            metadataXMLReaderState.setPropertyTag(xMLTag);
        }
        return metadataXMLReaderState;
    }

    MetadataXMLReaderElementState getParent() {
        if (this.getParentState() instanceof MetadataXMLReaderElementState) {
            return (MetadataXMLReaderElementState)this.getParentState();
        }
        return null;
    }

    void clear() {
        this.setCurrentMetadataObject(null);
        this.setPropertyTag(null);
    }

    private boolean isContainerElementState() {
        if (null == this.getPropertyTag()) {
            return false;
        }
        return 7 == this.getPropertyTag().getXMLType();
    }

    private void addContainedObject(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, XMLReaderPropertyAction xMLReaderPropertyAction, boolean bl, MetadataXMLReader metadataXMLReader) throws SAXException {
        metadataXMLReader.initializeProperty(this.getCurrentMetadataObject(), xMLTag, baseMetadataObject.getID(), xMLReaderPropertyAction);
        if (bl) {
            XMLReaderPropertyAction xMLReaderPropertyAction2 = metadataXMLReader.getDefaultPropertyAction();
            boolean bl2 = baseMetadataObject.initializeContainedByProperty(this.getCurrentMetadataObject().getID(), xMLReaderPropertyAction2);
        }
    }

    private void setIsNewObject(boolean bl) {
        this.m_IsNewObject = bl;
    }

    boolean isNewObject() {
        return this.m_IsNewObject;
    }

    private MetadataXMLReaderElementState getEffectiveParent() {
        MetadataXMLReaderElementState metadataXMLReaderElementState = this.getParent();
        if (null == metadataXMLReaderElementState) {
            return null;
        }
        if (metadataXMLReaderElementState.isContainerElementState()) {
            return metadataXMLReaderElementState.getParent();
        }
        return metadataXMLReaderElementState;
    }

    @Override
    protected BaseMetadataObject getMetadataObject() {
        if (null != this.getCurrentMetadataObject()) {
            return this.getCurrentMetadataObject();
        }
        return super.getMetadataObject();
    }
}

