/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.log;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import oracle.olapi.log.LogEvent;
import oracle.olapi.log.Queue;

class PipeQueue
extends Queue {
    private ObjectInputStream objIn;
    private ObjectOutputStream objOut;
    private boolean _running;
    private int objCount;

    public PipeQueue() throws IOException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        this.objOut = new ObjectOutputStream(pipedOutputStream);
        this.objIn = new ObjectInputStream(pipedInputStream);
        this.objCount = 0;
    }

    @Override
    public synchronized void put(LogEvent logEvent) {
        try {
            this.objOut.writeObject(logEvent);
            this.objOut.flush();
            ++this.objCount;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.notifyAll();
    }

    @Override
    public synchronized LogEvent get() {
        if (!this.waitWhileEmpty()) {
            return null;
        }
        try {
            Object object = this.objIn.readObject();
            --this.objCount;
            this.notifyAll();
            return (LogEvent)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.objCount == 0;
    }
}

